/*
 * Decompiled with CFR 0.152.
 */
package com.prunoideae.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.prunoideae.recipe.BotaniaRecipeJS;
import dev.latvian.mods.kubejs.util.ListJS;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.level.block.Block;

public class OrechidRecipeJS
extends BotaniaRecipeJS {
    private Block input;
    private Block output;
    private int weight = 100;
    private final List<String> biomes = new ArrayList<String>();
    private int biomeBonus = 100;

    public void create(ListJS args) {
        this.output = this.getBlockJS(args.get(0));
        this.input = this.getBlockJS(args.get(1));
        if (args.size() > 2) {
            this.weight = (int)((Double)args.get(2)).doubleValue();
        }
        if (args.size() > 3) {
            this.biomes.addAll(ListJS.orSelf((Object)args.get(3)).stream().map(String::valueOf).collect(Collectors.toList()));
        }
        if (args.size() > 4) {
            this.biomeBonus = (int)((Double)args.get(4)).doubleValue();
        }
        this.outputItems.add(this.asItemStackJS(this.output));
        this.inputItems.add(this.asItemStackJS(this.input));
    }

    public void deserialize() {
        this.output = this.getBlockJS(this.json.get("output").getAsJsonObject().get("block").getAsString());
        this.input = this.getBlockJS(this.json.get("input").getAsString());
        this.outputItems.add(this.asItemStackJS(this.output));
        this.inputItems.add(this.asItemStackJS(this.input));
        this.weight = this.json.get("weight").getAsInt();
        if (this.json.has("biomes")) {
            for (JsonElement biome : this.json.get("biomes").getAsJsonArray()) {
                this.biomes.add(biome.getAsString());
            }
        }
        if (this.json.has("biome_bonus")) {
            this.biomeBonus = this.json.get("biome_bonus").getAsInt();
        }
    }

    public void serialize() {
        if (this.serializeOutputs) {
            JsonObject outputJS = new JsonObject();
            outputJS.addProperty("type", "block");
            outputJS.addProperty("block", this.getBlockId(this.output));
            this.json.add("output", (JsonElement)outputJS);
        }
        if (this.serializeInputs) {
            this.json.addProperty("input", this.getBlockId(this.input));
        }
        this.json.addProperty("weight", (Number)this.weight);
        if (!this.biomes.isEmpty()) {
            JsonArray biomesJS = new JsonArray();
            for (String biome : this.biomes) {
                biomesJS.add(biome);
            }
            this.json.add("biomes", (JsonElement)biomesJS);
            this.json.addProperty("biome_bonus", (Number)this.biomeBonus);
        }
    }
}

