/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals.blocks.tile_entities;

import com.hakimen.peripherals.peripherals.GrinderPeripheral;
import com.hakimen.peripherals.registry.BlockEntityRegister;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.Capabilities;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class GrinderEntity
extends BlockEntity {
    public LazyOptional<IPeripheral> peripheral = LazyOptional.of(() -> new GrinderPeripheral(this));
    public final ItemStackHandler inventory = this.createHandler();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.inventory);

    public GrinderEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegister.grinderEntity.get(), pos, state);
    }

    public void m_142466_(CompoundTag tag) {
        this.inventory.deserializeNBT(tag);
        super.m_142466_(tag);
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128391_(this.inventory.serializeNBT());
        super.m_183515_(tag);
    }

    public void tick() {
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        if (cap == Capabilities.CAPABILITY_PERIPHERAL) {
            return this.peripheral;
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler;
        }
        return super.getCapability(cap);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                GrinderEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                switch (slot) {
                    case 0: {
                        return stack.m_41720_() instanceof SwordItem;
                    }
                }
                return false;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }
}

