/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals.peripherals;

import com.hakimen.peripherals.blocks.tile_entities.MagneticCardManiputalorEntity;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MagneticCardManiputalorPeripheral
implements IPeripheral {
    private final MagneticCardManiputalorEntity tileEntity;

    public MagneticCardManiputalorPeripheral(MagneticCardManiputalorEntity tileEntity) {
        this.tileEntity = tileEntity;
    }

    @NotNull
    public String getType() {
        return "magnetic_card_manipulator";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other == this;
    }

    public void attach(@NotNull IComputerAccess computer) {
        this.tileEntity.computers.add(computer);
        super.attach(computer);
    }

    public void detach(@NotNull IComputerAccess computer) {
        this.tileEntity.computers.remove(computer);
        super.detach(computer);
    }

    @LuaFunction
    public final String readCard() throws LuaException {
        if (!this.tileEntity.inventory.getStackInSlot(0).m_41720_().equals(Items.f_41852_)) {
            return this.tileEntity.inventory.getStackInSlot(0).m_41784_().m_128461_("data");
        }
        throw new LuaException("No card found");
    }

    @LuaFunction
    public final void writeCard(String data) throws LuaException {
        if (this.tileEntity.inventory.getStackInSlot(0).m_41720_().equals(Items.f_41852_)) {
            throw new LuaException("No card found");
        }
        System.out.println(data);
        this.tileEntity.inventory.getStackInSlot(0).m_41784_().m_128359_("data", data);
    }

    @LuaFunction
    public final boolean hasCard() {
        return !this.tileEntity.inventory.getStackInSlot(0).m_41720_().equals(Items.f_41852_);
    }

    @LuaFunction
    public final boolean ejectCard(IComputerAccess computer) {
        if (!this.tileEntity.inventory.getStackInSlot(0).m_41720_().equals(Items.f_41852_)) {
            this.tileEntity.m_58904_().m_7967_((Entity)new ItemEntity(this.tileEntity.m_58904_(), (double)this.tileEntity.m_58899_().m_123341_() + 0.5, (double)this.tileEntity.m_58899_().m_123342_() + 0.5, (double)this.tileEntity.m_58899_().m_123343_() + 0.5, this.tileEntity.inventory.extractItem(0, 1, false)));
            computer.queueEvent("card_remove", new Object[0]);
            return true;
        }
        return false;
    }

    @LuaFunction
    public final boolean setLabel(String label) {
        if (!this.tileEntity.inventory.getStackInSlot(0).m_41720_().equals(Items.f_41852_)) {
            if (label.equals("")) {
                this.tileEntity.inventory.getStackInSlot(0).m_41787_();
            } else {
                this.tileEntity.inventory.getStackInSlot(0).m_41714_((Component)new TextComponent(label));
            }
            return true;
        }
        return false;
    }

    @LuaFunction
    public final String getLabel() throws LuaException {
        if (!this.tileEntity.inventory.getStackInSlot(0).m_41720_().equals(Items.f_41852_)) {
            return this.tileEntity.inventory.getStackInSlot(0).m_41786_().getString();
        }
        throw new LuaException("No card found");
    }

    @LuaFunction
    public final void setSecure(boolean sensibility) throws LuaException {
        if (this.tileEntity.inventory.getStackInSlot(0).m_41720_().equals(Items.f_41852_)) {
            throw new LuaException("No card found");
        }
        this.tileEntity.inventory.getStackInSlot(0).m_41784_().m_128379_("sensible", sensibility);
    }
}

