/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals.peripherals;

import com.hakimen.peripherals.blocks.tile_entities.TradingInterfaceEntity;
import com.hakimen.peripherals.utils.Utils;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.Container;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TradingInterfacePeripheral
implements IPeripheral {
    private final TradingInterfaceEntity tileEntity;

    public TradingInterfacePeripheral(TradingInterfaceEntity tileEntity) {
        this.tileEntity = tileEntity;
    }

    @NotNull
    public String getType() {
        return "trading_interface";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other == this;
    }

    @LuaFunction
    public final String getProfession() throws LuaException {
        if (this.tileEntity.villager == null) {
            throw new LuaException("villager not in range");
        }
        return this.tileEntity.villager.m_7141_().m_35571_().m_150028_();
    }

    @LuaFunction
    public final List<Map<String, Map<String, Map<String, ?>>>> getTrades() throws LuaException {
        if (this.tileEntity.villager == null) {
            throw new LuaException("villager not in range");
        }
        ArrayList offerList = new ArrayList();
        List<MerchantOffer> offers = this.tileEntity.villager.m_6616_().stream().toList();
        offers.forEach(offer -> {
            HashMap map = new HashMap();
            HashMap<String, HashMap<String, Object>> itemSet = new HashMap<String, HashMap<String, Object>>();
            HashMap<String, HashMap<String, Object>> itemSet2 = new HashMap<String, HashMap<String, Object>>();
            HashMap<String, HashMap<String, Object>> itemSet3 = new HashMap<String, HashMap<String, Object>>();
            HashMap<String, Object> itemSetDetails = TradingInterfacePeripheral.getItemInfo(EnchantmentHelper.m_44831_((ItemStack)offer.m_45352_()), offer.m_45352_().m_41613_());
            itemSet.put(offer.m_45352_().m_41720_().getRegistryName().toString(), itemSetDetails);
            map.put("costA", itemSet);
            HashMap<String, Object> itemSetDetails2 = TradingInterfacePeripheral.getItemInfo(EnchantmentHelper.m_44831_((ItemStack)offer.m_45364_()), offer.m_45364_().m_41613_());
            itemSet2.put(offer.m_45364_().m_41720_().getRegistryName().toString(), itemSetDetails2);
            map.put("costB", itemSet2);
            HashMap<String, Object> itemSetDetails3 = TradingInterfacePeripheral.getItemInfo(EnchantmentHelper.m_44831_((ItemStack)offer.m_45368_()), offer.m_45368_().m_41613_());
            itemSet3.put(offer.m_45368_().m_41720_().getRegistryName().toString(), itemSetDetails3);
            map.put("result", itemSet3);
            offerList.add(map);
        });
        return offerList;
    }

    @LuaFunction
    public final boolean trade(IComputerAccess computer, String from, String to, int trade) throws LuaException {
        if (!Utils.isFromMinecraft(computer, from)) {
            throw new LuaException("this method needs a vanilla inventory as input");
        }
        if (this.tileEntity.villager == null) {
            throw new LuaException("villager not in range");
        }
        if (trade - 1 < 0 || trade - 1 > this.tileEntity.villager.m_6616_().stream().toList().size()) {
            throw new LuaException("trade index out of range");
        }
        MerchantOffer offer = (MerchantOffer)this.tileEntity.villager.m_6616_().stream().toList().get(trade - 1);
        IPeripheral inputLocation = computer.getAvailablePeripheral(from);
        if (inputLocation == null) {
            throw new LuaException("the input " + from + " was not found");
        }
        IItemHandler input = TradingInterfacePeripheral.extractHandler(inputLocation.getTarget());
        IPeripheral outlocation = computer.getAvailablePeripheral(to);
        if (outlocation == null) {
            throw new LuaException("the input " + to + " was not found");
        }
        IItemHandler result = TradingInterfacePeripheral.extractHandler(outlocation.getTarget());
        boolean validA = false;
        boolean validB = false;
        int[] slots = new int[]{-1, -1};
        for (int slot = 0; slot < input.getSlots(); ++slot) {
            ItemStack test = input.getStackInSlot(slot);
            if (!validA && test.m_41613_() >= offer.m_45352_().m_41613_() && test.m_41656_(offer.m_45352_())) {
                validA = true;
                slots[0] = slot;
            }
            if (validB || test.m_41613_() < offer.m_45364_().m_41613_() || !test.m_41656_(offer.m_45364_())) continue;
            validB = true;
            slots[1] = slot;
        }
        if (validA && validB || !validB && validA) {
            ItemStack out = offer.m_45370_();
            ItemStack rest = out.m_41777_();
            if (!rest.m_41619_()) {
                for (int slot = 0; slot < result.getSlots() && !(rest = result.insertItem(slot, out, false)).m_41619_(); ++slot) {
                    out = rest;
                }
            }
            if (rest.m_41619_()) {
                input.getStackInSlot(slots[0]).m_41774_(offer.m_45352_().m_41613_());
                if (validB) {
                    input.getStackInSlot(slots[1]).m_41774_(offer.m_45364_().m_41613_());
                }
                return true;
            }
            throw new LuaException("destination inventory full");
        }
        return false;
    }

    @LuaFunction
    public final void restock() throws LuaException {
        if (this.tileEntity.villager == null) {
            throw new LuaException("villager not in range");
        }
        this.tileEntity.villager.m_35510_();
    }

    @LuaFunction
    public final void cycleTrades() throws LuaException {
        if (this.tileEntity.villager == null) {
            throw new LuaException("villager not in range");
        }
        VillagerProfession lastProfession = this.tileEntity.villager.m_7141_().m_35571_();
        this.tileEntity.villager.m_141967_(this.tileEntity.villager.m_7141_().m_35565_(VillagerProfession.f_35585_));
        this.tileEntity.villager.m_141967_(this.tileEntity.villager.m_7141_().m_35561_(1));
        this.tileEntity.villager.m_35546_(0);
        this.tileEntity.villager.m_141967_(this.tileEntity.villager.m_7141_().m_35565_(lastProfession));
    }

    private static HashMap<String, Object> getItemInfo(Map<Enchantment, Integer> enchants, int count) {
        HashMap<String, Object> itemSetDetails = new HashMap<String, Object>();
        ArrayList enchantList = new ArrayList();
        enchants.forEach((e, i) -> enchantList.add(e.getRegistryName() + " " + i));
        itemSetDetails.put("enchants", enchantList);
        itemSetDetails.put("count", count);
        return itemSetDetails;
    }

    @javax.annotation.Nullable
    private static IItemHandler extractHandler(@javax.annotation.Nullable Object object) {
        ICapabilityProvider provider;
        LazyOptional cap;
        BlockEntity blockEntity;
        if (object instanceof BlockEntity && (blockEntity = (BlockEntity)object).m_58901_()) {
            return null;
        }
        if (object instanceof ICapabilityProvider && (cap = (provider = (ICapabilityProvider)object).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).isPresent()) {
            return (IItemHandler)cap.orElseThrow(NullPointerException::new);
        }
        if (object instanceof IItemHandler) {
            IItemHandler handler = (IItemHandler)object;
            return handler;
        }
        if (object instanceof Container) {
            Container container = (Container)object;
            return new InvWrapper(container);
        }
        return null;
    }

    private static int moveItem(IItemHandler from, int fromSlot, IItemHandler to, int toSlot, int limit) {
        int inserted;
        ItemStack extracted = from.extractItem(fromSlot, limit, true);
        if (extracted.m_41619_()) {
            return 0;
        }
        int extractCount = Math.min(extracted.m_41613_(), limit);
        extracted.m_41764_(extractCount);
        ItemStack remainder = toSlot < 0 ? ItemHandlerHelper.insertItem((IItemHandler)to, (ItemStack)extracted, (boolean)false) : to.insertItem(toSlot, extracted, false);
        int n = inserted = remainder.m_41619_() ? extractCount : extractCount - remainder.m_41613_();
        if (inserted <= 0) {
            return 0;
        }
        from.extractItem(fromSlot, inserted, false);
        return inserted;
    }
}

