/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals.peripherals;

import com.hakimen.peripherals.blocks.tile_entities.XPBottlerEntity;
import com.hakimen.peripherals.peripherals.XPCollectorPeripheral;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import net.minecraft.world.Container;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XPBottlerPeripheral
implements IPeripheral {
    private final XPBottlerEntity tileEntity;

    public XPBottlerPeripheral(XPBottlerEntity tileEntity) {
        this.tileEntity = tileEntity;
    }

    @NotNull
    public String getType() {
        return "xp_bottler";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other instanceof XPBottlerPeripheral;
    }

    @LuaFunction
    public boolean bottleXP(IComputerAccess computer, String from, String to, String xp_collector) throws LuaException {
        IPeripheral inputPeripheral = computer.getAvailablePeripheral(from);
        if (inputPeripheral == null) {
            throw new LuaException("the input " + from + " was not found");
        }
        IItemHandler input = XPBottlerPeripheral.extractHandler(inputPeripheral.getTarget());
        IPeripheral xpCollectorPeripheral = computer.getAvailablePeripheral(xp_collector);
        if (xpCollectorPeripheral == null) {
            throw new LuaException("the xp collector " + xp_collector + " was not found");
        }
        IPeripheral outPeripheral = computer.getAvailablePeripheral(to);
        if (outPeripheral == null) {
            throw new LuaException("the output " + outPeripheral + " was not found");
        }
        IItemHandler output = XPBottlerPeripheral.extractHandler(outPeripheral.getTarget());
        XPCollectorPeripheral collector = (XPCollectorPeripheral)xpCollectorPeripheral;
        int xp = collector.tileEntity.xpPoints;
        int bottles = xp / 8;
        if (bottles == 0) {
            return false;
        }
        block0: for (int bottle = 0; bottle < bottles; ++bottle) {
            int i;
            boolean hasBottle = false;
            for (i = 0; i < input.getSlots(); ++i) {
                if (input.getStackInSlot(i).m_41720_() != Items.f_42590_) continue;
                input.extractItem(i, 1, false);
                hasBottle = true;
                break;
            }
            if (hasBottle) {
                for (i = 0; i < output.getSlots(); ++i) {
                    if ((output.getStackInSlot(i).m_41613_() >= output.getSlotLimit(i) || !output.getStackInSlot(i).m_41656_(Items.f_42612_.m_7968_())) && !output.getStackInSlot(i).m_41619_()) continue;
                    output.insertItem(i, Items.f_42612_.m_7968_(), false);
                    collector.tileEntity.xpPoints -= 8;
                    collector.tileEntity.m_6596_();
                    continue block0;
                }
                continue;
            }
            throw new LuaException("no bottles found in input");
        }
        collector.tileEntity.m_6596_();
        return true;
    }

    @javax.annotation.Nullable
    private static IItemHandler extractHandler(@javax.annotation.Nullable Object object) {
        ICapabilityProvider provider;
        LazyOptional cap;
        BlockEntity blockEntity;
        if (object instanceof BlockEntity && (blockEntity = (BlockEntity)object).m_58901_()) {
            return null;
        }
        if (object instanceof ICapabilityProvider && (cap = (provider = (ICapabilityProvider)object).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).isPresent()) {
            return (IItemHandler)cap.orElseThrow(NullPointerException::new);
        }
        if (object instanceof IItemHandler) {
            IItemHandler handler = (IItemHandler)object;
            return handler;
        }
        if (object instanceof Container) {
            Container container = (Container)object;
            return new InvWrapper(container);
        }
        return null;
    }
}

