/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.client.renderer.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.talhanation.smallships.client.model.CannonModel;
import com.talhanation.smallships.client.model.ShipModel;
import com.talhanation.smallships.client.model.sail.BriggSailModel;
import com.talhanation.smallships.client.model.sail.CogSailModel;
import com.talhanation.smallships.client.model.sail.DrakkarSailModel;
import com.talhanation.smallships.client.model.sail.GalleySailModel;
import com.talhanation.smallships.client.model.sail.SailModel;
import com.talhanation.smallships.duck.BoatLeashAccess;
import com.talhanation.smallships.world.entity.projectile.Cannon;
import com.talhanation.smallships.world.entity.ship.Attributes;
import com.talhanation.smallships.world.entity.ship.BriggEntity;
import com.talhanation.smallships.world.entity.ship.CogEntity;
import com.talhanation.smallships.world.entity.ship.DrakkarEntity;
import com.talhanation.smallships.world.entity.ship.GalleyEntity;
import com.talhanation.smallships.world.entity.ship.Ship;
import com.talhanation.smallships.world.entity.ship.abilities.Bannerable;
import com.talhanation.smallships.world.entity.ship.abilities.Cannonable;
import com.talhanation.smallships.world.entity.ship.abilities.Leashable;
import com.talhanation.smallships.world.entity.ship.abilities.Paddleable;
import com.talhanation.smallships.world.entity.ship.abilities.Sailable;
import com.talhanation.smallships.world.entity.ship.abilities.Shieldable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ShieldModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class ShipRenderer<T extends Ship>
extends EntityRenderer<T> {
    protected final Map<Boat.Type, Pair<ResourceLocation, ShipModel<T>>> boatResources;
    private static final ModelPart bannerModel;
    private static final ShieldModel shieldModel;
    private static final Map<Class<? extends Ship>, SailModel> sailModels;

    public ShipRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.8f;
        this.boatResources = (Map)Stream.of(Boat.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)this.getTextureLocation((Boat.Type)type), this.createBoatModel(context, (Boat.Type)type))));
    }

    protected abstract ShipModel<T> createBoatModel(EntityRendererProvider.Context var1, Boat.Type var2);

    protected abstract ResourceLocation getTextureLocation(Boat.Type var1);

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T shipEntity) {
        return (ResourceLocation)this.boatResources.get(shipEntity.m_38387_()).getFirst();
    }

    public void render(T shipEntity, float entityYaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int packedLight) {
        float l;
        float k;
        Attributes shipAttributes = ((Ship)shipEntity).getAttributes();
        float h = ((float)shipEntity.m_38385_() - partialTicks) / (shipAttributes.maxHealth * shipEntity.m_20205_() / 40.0f);
        float j = shipEntity.m_38384_() - partialTicks;
        if (j < 0.0f) {
            j = 0.0f;
        } else if (j > shipAttributes.maxHealth * 0.5f) {
            shipEntity.m_183503_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, shipEntity.m_20208_(0.5), shipEntity.m_20186_() + 1.0, shipEntity.m_20262_(0.5), 0.0, 0.0, 0.0);
        }
        if (h > 0.0f) {
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14031_((float)h) * h * j / 10.0f * (float)shipEntity.m_38386_()));
        }
        if (!Mth.m_14033_((float)(k = shipEntity.m_38352_(partialTicks)), (float)0.0f)) {
            poseStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 1.0f), k, true));
        }
        if (!Mth.m_14033_((float)(l = ((Ship)shipEntity).getWaveAngle(partialTicks)), (float)0.0f)) {
            poseStack.m_85845_(this.getWaveAngleRotation().m_122240_(l));
        }
        Pair<ResourceLocation, ShipModel<T>> pair = this.boatResources.get(shipEntity.m_38387_());
        ResourceLocation resourceLocation = (ResourceLocation)pair.getFirst();
        ShipModel shipModel = (ShipModel)((Object)pair.getSecond());
        poseStack.m_85841_(-1.3f, -1.3f, 1.3f);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(270.0f));
        shipModel.m_6973_((Entity)shipEntity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        if (shipEntity instanceof Cannonable) {
            Cannonable cannonShipEntity = (Cannonable)shipEntity;
            this.renderCannon(cannonShipEntity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
        }
        if (shipEntity instanceof Bannerable) {
            Bannerable bannerShipEntity = (Bannerable)shipEntity;
            this.renderBanner(bannerShipEntity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
        }
        if (shipEntity instanceof Paddleable) {
            Paddleable paddleShipEntity = (Paddleable)shipEntity;
            this.renderPaddle(paddleShipEntity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
        }
        if (shipEntity instanceof Sailable) {
            Sailable sailShipEntity = (Sailable)shipEntity;
            this.renderSail(sailShipEntity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
        }
        if (shipEntity instanceof Shieldable) {
            Shieldable shieldShipEntity = (Shieldable)shipEntity;
            this.renderShields(shieldShipEntity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
        }
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(shipModel.m_103119_(resourceLocation));
        shipModel.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        super.m_7392_(shipEntity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
        if (shipEntity instanceof Leashable) {
            Leashable leashShipEntity = (Leashable)shipEntity;
            this.renderLeash(leashShipEntity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
        }
    }

    private void renderCannon(Cannonable cannonShipEntity, float entityYaw, float partialTicks, PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int packedLight) {
        for (byte i = 0; i < cannonShipEntity.getCannonCount(); i = (byte)(i + 1)) {
            Cannon cannon = new Cannon(cannonShipEntity.self(), cannonShipEntity.getCannonPosition(i));
            poseStack.m_85836_();
            poseStack.m_85845_(Vector3f.f_122224_.m_122240_(this.getCannonAngleOffset() + cannon.getAngle()));
            poseStack.m_85837_(cannon.isRightSided() ? -cannon.getOffsetX() : cannon.getOffsetX(), -cannon.getOffsetY() + (double)this.getCannonHeightOffset(), -cannon.getOffsetZ());
            poseStack.m_85841_(0.6f, 0.6f, 0.6f);
            CannonModel cannonModel = new CannonModel();
            cannonModel.setupAnim((Ship)((Object)cannonShipEntity), partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
            VertexConsumer vertexConsumer = multiBufferSource.m_6299_(cannonModel.m_103119_(cannonShipEntity.getTextureLocation()));
            cannonModel.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
        }
    }

    protected float getCannonAngleOffset() {
        return 0.0f;
    }

    protected float getCannonHeightOffset() {
        return 0.0f;
    }

    private void renderBanner(Bannerable bannerShipEntity, float entityYaw, float partialTicks, PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int packedLight) {
        ItemStack item = bannerShipEntity.self().getData(Ship.BANNER);
        Item item2 = item.m_41720_();
        if (item2 instanceof BannerItem) {
            BannerItem bannerItem = (BannerItem)item2;
            poseStack.m_85836_();
            Bannerable.BannerPosition pos = bannerShipEntity.getBannerPosition();
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(pos.yp));
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(pos.zp));
            poseStack.m_85837_(pos.x, pos.y, pos.z);
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            float bannerWaveAngle = bannerShipEntity.getBannerWaveAngle(partialTicks);
            if (!Mth.m_14033_((float)bannerWaveAngle, (float)0.0f)) {
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_(bannerWaveAngle * 0.5f));
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(bannerWaveAngle));
            }
            List patterns = BannerBlockEntity.m_58484_((DyeColor)bannerItem.m_40545_(), (ListTag)BannerBlockEntity.m_58487_((ItemStack)item));
            BannerRenderer.m_112065_((PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (int)packedLight, (int)OverlayTexture.f_118083_, (ModelPart)bannerModel, (Material)ModelBakery.f_119224_, (boolean)true, (List)patterns);
            poseStack.m_85849_();
        }
    }

    private void renderShields(Shieldable shieldShipEntity, float entityYaw, float partialTicks, PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int packedLight) {
        for (int i = 0; i < shieldShipEntity.getShields().size(); i = (int)((byte)(i + 1))) {
            VertexConsumer vertexConsumer;
            ItemStack itemStack = (ItemStack)shieldShipEntity.getShields().get(i);
            if (!itemStack.m_150930_(Items.f_42740_)) continue;
            poseStack.m_85836_();
            Shieldable.ShieldPosition pos = shieldShipEntity.getShieldPosition(i);
            poseStack.m_85837_(pos.x, pos.y, pos.z);
            poseStack.m_85841_(0.8f, -0.8f, -0.8f);
            if (pos.isRightSided) {
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            }
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(20.0f));
            boolean flag = BlockItem.m_186336_((ItemStack)itemStack) != null;
            Material material = flag ? ModelBakery.f_119225_ : ModelBakery.f_119226_;
            try (TextureAtlasSprite sprite = material.m_119204_();){
                vertexConsumer = sprite.m_118381_(ItemRenderer.m_115222_((MultiBufferSource)multiBufferSource, (RenderType)shieldModel.m_103119_(material.m_119193_()), (boolean)true, (boolean)itemStack.m_41790_()));
            }
            if (flag) {
                List patterns = BannerBlockEntity.m_58484_((DyeColor)ShieldItem.m_43102_((ItemStack)itemStack), (ListTag)BannerBlockEntity.m_58487_((ItemStack)itemStack));
                BannerRenderer.m_112074_((PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (int)packedLight, (int)OverlayTexture.f_118083_, (ModelPart)shieldModel.m_103701_(), (Material)material, (boolean)false, (List)patterns, (boolean)itemStack.m_41790_());
            } else {
                shieldModel.m_103701_().m_104306_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            shieldModel.m_103711_().m_104306_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
        }
    }

    public Vector3f getWaveAngleRotation() {
        return Vector3f.f_122222_;
    }

    private void renderPaddle(Paddleable paddleShipEntity, float entityYaw, float partialTicks, PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int packedLight) {
    }

    private void renderSail(Sailable sailShipEntity, float entityYaw, float partialTicks, PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int packedLight) {
        SailModel sailModel = sailModels.get(sailShipEntity.getClass());
        sailModel.m_6973_((Entity)((Ship)((Object)sailShipEntity)), partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(sailModel.m_103119_(SailModel.getSailColor((String)sailShipEntity.self().getData(Ship.SAIL_COLOR)).location));
        sailModel.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public boolean shouldRender(T ship, Frustum frustum, double d, double e, double f) {
        if (super.m_5523_(ship, frustum, d, e, f)) {
            return true;
        }
        if (ship instanceof Leashable) {
            Entity entity = ((BoatLeashAccess)ship).getLeashHolder();
            return entity != null ? frustum.m_113029_(entity.m_6921_()) : false;
        }
        return false;
    }

    private void renderLeash(Leashable leashShipEntity, float entityYaw, float partialTicks, PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int packedLight) {
        int v;
        Entity leashHolderEntity = ((BoatLeashAccess)((Object)leashShipEntity)).getLeashHolder();
        if (leashHolderEntity == null) {
            return;
        }
        poseStack.m_85836_();
        Vec3 vec3 = leashHolderEntity.m_7398_(partialTicks);
        double d = Mth.m_14139_((double)partialTicks, (double)0.0, (double)0.0) * 0.01745329238474369 + 1.5707963267948966;
        Vec3 vec32 = ((Ship)((Object)leashShipEntity)).m_7939_();
        double e = Math.cos(d) * vec32.f_82481_ + Math.sin(d) * vec32.f_82479_;
        double g = Math.sin(d) * vec32.f_82481_ - Math.cos(d) * vec32.f_82479_;
        double h = Mth.m_14139_((double)partialTicks, (double)((Ship)((Object)leashShipEntity)).f_19854_, (double)((Ship)((Object)leashShipEntity)).m_20185_()) + e;
        double i = Mth.m_14139_((double)partialTicks, (double)((Ship)((Object)leashShipEntity)).f_19855_, (double)((Ship)((Object)leashShipEntity)).m_20186_()) + vec32.f_82480_;
        double j = Mth.m_14139_((double)partialTicks, (double)((Ship)((Object)leashShipEntity)).f_19856_, (double)((Ship)((Object)leashShipEntity)).m_20189_()) + g;
        poseStack.m_85837_(e, vec32.f_82480_, g);
        float k = (float)(vec3.f_82479_ - h);
        float l = (float)(vec3.f_82480_ - i);
        float m = (float)(vec3.f_82481_ - j);
        float n = 0.025f;
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110475_());
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        float o = Mth.m_14195_((float)(k * k + m * m)) * n / 2.0f;
        float p = m * o;
        float q = k * o;
        BlockPos blockPos = new BlockPos(((Ship)((Object)leashShipEntity)).m_20299_(partialTicks));
        BlockPos blockPos2 = new BlockPos(leashHolderEntity.m_20299_(partialTicks));
        int r = this.m_6086_((Entity)((Ship)((Object)leashShipEntity)), blockPos);
        int s = this.f_114476_.m_114382_(leashHolderEntity).m_6086_(leashHolderEntity, blockPos2);
        int t = ((Ship)((Object)leashShipEntity)).m_183503_().m_45517_(LightLayer.SKY, blockPos);
        int u = ((Ship)((Object)leashShipEntity)).m_183503_().m_45517_(LightLayer.SKY, blockPos2);
        for (v = 0; v <= 24; ++v) {
            MobRenderer.m_174307_((VertexConsumer)vertexConsumer, (Matrix4f)matrix4f, (float)k, (float)l, (float)m, (int)r, (int)s, (int)t, (int)u, (float)n, (float)n, (float)p, (float)q, (int)v, (boolean)false);
        }
        for (v = 24; v >= 0; --v) {
            MobRenderer.m_174307_((VertexConsumer)vertexConsumer, (Matrix4f)matrix4f, (float)k, (float)l, (float)m, (int)r, (int)s, (int)t, (int)u, (float)n, (float)0.0f, (float)p, (float)q, (int)v, (boolean)true);
        }
        poseStack.m_85849_();
    }

    public static String getNameFromType(Boat.Type type) {
        return type.m_38429_().replace(":", "/");
    }

    static {
        ModelPart model = BannerRenderer.m_173522_().m_171564_();
        model.m_171324_((String)"pole").f_104207_ = false;
        model.m_171324_((String)"bar").f_104207_ = false;
        bannerModel = model;
        shieldModel = new ShieldModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171179_));
        sailModels = new HashMap<Class<? extends Ship>, SailModel>();
        sailModels.put(CogEntity.class, new CogSailModel());
        sailModels.put(BriggEntity.class, new BriggSailModel());
        sailModels.put(GalleyEntity.class, new GalleySailModel());
        sailModels.put(DrakkarEntity.class, new DrakkarSailModel());
    }
}

