/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.mixin.leashing;

import com.talhanation.smallships.duck.BoatLeashAccess;
import com.talhanation.smallships.world.entity.ship.abilities.Leashable;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Boat.class})
public abstract class BoatMixin
implements BoatLeashAccess {
    private static final String LEASH_TAG = "Leash";
    @Nullable
    private Entity leashHolder;
    private int delayedLeashHolderId;
    @Nullable
    private CompoundTag leashInfoTag;

    private Boat self() {
        return (Boat)this;
    }

    private boolean isClientSide() {
        return this.self().m_183503_().m_5776_();
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickLeash(CallbackInfo ci) {
        if (!this.isClientSide() && (this.self() instanceof Leashable || this.self().getClass().equals(Boat.class))) {
            this.tickLeash();
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    private void addAdditionalSaveDataAdditionalShipData(CompoundTag compoundTag, CallbackInfo ci) {
        if (this.leashHolder != null) {
            CompoundTag leashTag = new CompoundTag();
            if (this.leashHolder instanceof LivingEntity) {
                UUID uUID = this.leashHolder.m_142081_();
                leashTag.m_128362_("UUID", uUID);
            } else if (this.leashHolder instanceof HangingEntity) {
                BlockPos blockPos = ((HangingEntity)this.leashHolder).m_31748_();
                leashTag.m_128405_("X", blockPos.m_123341_());
                leashTag.m_128405_("Y", blockPos.m_123342_());
                leashTag.m_128405_("Z", blockPos.m_123343_());
            }
            compoundTag.m_128365_(LEASH_TAG, (Tag)leashTag);
        } else if (this.leashInfoTag != null) {
            compoundTag.m_128365_(LEASH_TAG, (Tag)this.leashInfoTag.m_6426_());
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    private void readAdditionalSaveDataAdditionalShipData(CompoundTag compoundTag, CallbackInfo ci) {
        if (compoundTag.m_128425_(LEASH_TAG, 10)) {
            this.leashInfoTag = compoundTag.m_128469_(LEASH_TAG);
        }
    }

    @Inject(method={"interact"}, at={@At(value="HEAD")}, cancellable=true)
    private void interactLeashShip(Player player, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResult> cir) {
        if (this.self() instanceof Leashable || this.self().getClass().equals(Boat.class)) {
            ItemStack itemStack;
            if (this.getLeashHolder() == player) {
                this.dropLeash(true, !player.m_150110_().f_35937_);
                cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)this.isClientSide()));
            }
            if ((itemStack = player.m_21120_(interactionHand)).m_150930_(Items.f_42655_) && this.canBeLeashed()) {
                this.setLeashedTo((Entity)player, true);
                itemStack.m_41774_(1);
                cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)this.isClientSide()));
            }
        }
    }

    protected void tickLeash() {
        Entity entity;
        if (this.leashInfoTag != null) {
            this.restoreLeashFromSave();
        }
        if (!(this.leashHolder == null || this.self().m_6084_() && this.leashHolder.m_6084_())) {
            this.dropLeash(true, true);
        }
        if ((entity = this.getLeashHolder()) != null && entity.m_183503_() == this.self().m_183503_()) {
            float distanceToHolderEntity = this.self().m_20270_(entity);
            if (distanceToHolderEntity > 10.0f) {
                this.dropLeash(true, true);
            } else if (distanceToHolderEntity > 6.0f) {
                double d1 = (entity.m_20185_() - this.self().m_20185_()) / (double)distanceToHolderEntity;
                double d2 = (entity.m_20186_() - this.self().m_20186_()) / (double)distanceToHolderEntity;
                double d3 = (entity.m_20189_() - this.self().m_20189_()) / (double)distanceToHolderEntity;
                double shipWeight = this.self() instanceof Leashable ? (double)(-((Leashable)this.self()).getDefaultShipWeight() / (((Leashable)this.self()).getDefaultShipWeight() + 1.0f) + 1.0f) : (double)0.4f;
                this.self().m_20256_(this.self().m_20184_().m_82520_(Math.copySign(d1 * d1 * shipWeight, d1), Math.copySign(d2 * d2 * shipWeight, d2), Math.copySign(d3 * d3 * shipWeight, d3)));
            }
        }
    }

    @Override
    public void dropLeash(boolean shouldUnlink, boolean shouldDropItem) {
        if (this.leashHolder != null) {
            Level level;
            this.leashHolder = null;
            this.leashInfoTag = null;
            if (!this.isClientSide() && shouldDropItem) {
                this.self().m_20000_((ItemLike)Items.f_42655_, 4);
            }
            if (!this.isClientSide() && shouldUnlink && (level = this.self().m_183503_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_7726_().m_8445_((Entity)this.self(), (Packet)new ClientboundSetEntityLinkPacket((Entity)this.self(), null));
            }
        }
    }

    public boolean canBeLeashed() {
        return !this.isLeashed() && !(this.self().m_146895_() instanceof Player);
    }

    @Override
    public boolean isLeashed() {
        return this.leashHolder != null;
    }

    @Override
    @Nullable
    public Entity getLeashHolder() {
        if (this.leashHolder == null && this.delayedLeashHolderId != 0 && this.isClientSide()) {
            this.leashHolder = this.self().m_183503_().m_6815_(this.delayedLeashHolderId);
        }
        return this.leashHolder;
    }

    @Override
    public void setLeashedTo(Entity entity, boolean shouldLink) {
        Level level;
        this.leashHolder = entity;
        this.leashInfoTag = null;
        if (!this.isClientSide() && shouldLink && (level = this.self().m_183503_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7726_().m_8445_((Entity)this.self(), (Packet)new ClientboundSetEntityLinkPacket((Entity)this.self(), this.leashHolder));
        }
        if (this.self().m_20159_()) {
            this.self().m_8127_();
        }
    }

    @Override
    public void setDelayedLeashHolderId(int i) {
        this.delayedLeashHolderId = i;
        this.dropLeash(false, false);
    }

    private void restoreLeashFromSave() {
        Level level;
        if (this.leashInfoTag != null && (level = this.self().m_183503_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.leashInfoTag.m_128403_("UUID")) {
                UUID uUID = this.leashInfoTag.m_128342_("UUID");
                Entity entity = serverLevel.m_8791_(uUID);
                if (entity != null) {
                    this.setLeashedTo(entity, true);
                    return;
                }
            } else if (this.leashInfoTag.m_128425_("X", 99) && this.leashInfoTag.m_128425_("Y", 99) && this.leashInfoTag.m_128425_("Z", 99)) {
                BlockPos blockPos = NbtUtils.m_129239_((CompoundTag)this.leashInfoTag);
                this.setLeashedTo((Entity)LeashFenceKnotEntity.m_31844_((Level)this.self().m_183503_(), (BlockPos)blockPos), true);
                return;
            }
            if (this.self().f_19797_ > 100) {
                this.self().m_20000_((ItemLike)Items.f_42655_, 4);
                this.leashInfoTag = null;
            }
        }
    }
}

