/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.mixin.leashing;

import com.talhanation.smallships.duck.BoatLeashAccess;
import java.util.Iterator;
import java.util.List;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ChunkMap.class})
public class ChunkMapMixin {
    private List<Entity> list;
    private ServerPlayer serverPlayer;
    private Entity peekedEntity = null;

    @Inject(method={"playerLoadedChunk"}, at={@At(value="INVOKE", target="Lcom/google/common/collect/Lists;newArrayList()Ljava/util/ArrayList;", ordinal=1, remap=false)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void playerLoadedChunkLeashShipCaptureListAndPlayer(ServerPlayer serverPlayer, MutableObject<ClientboundLevelChunkWithLightPacket> mutableObject, LevelChunk levelChunk, CallbackInfo ci, List<Entity> list) {
        this.list = list;
        this.serverPlayer = serverPlayer;
    }

    @ModifyConstant(method={"playerLoadedChunk"}, constant={@Constant(classValue=Mob.class, ordinal=0)})
    private Class<?> playerLoadedChunkLeashShipAddBoatsToList(Object object, Class<Mob> constant) {
        BoatLeashAccess boat;
        if (object instanceof BoatLeashAccess && (boat = (BoatLeashAccess)object).getLeashHolder() != null) {
            this.list.add((Entity)object);
        }
        return constant;
    }

    @Redirect(method={"playerLoadedChunk"}, at=@At(value="INVOKE", target="Ljava/util/Iterator;hasNext()Z", ordinal=1))
    private boolean playerLoadedChunkLeashShipSendLinkPacket(Iterator<Entity> instance) {
        while (instance.hasNext()) {
            Entity entity;
            if (this.peekedEntity == null) {
                this.peekedEntity = instance.next();
            }
            if ((entity = this.peekedEntity) instanceof BoatLeashAccess) {
                BoatLeashAccess boat = (BoatLeashAccess)entity;
                this.serverPlayer.f_8906_.m_141995_((Packet)new ClientboundSetEntityLinkPacket(this.peekedEntity, boat.getLeashHolder()));
                this.peekedEntity = null;
                continue;
            }
            return instance.hasNext() || this.peekedEntity != null;
        }
        return false;
    }

    @Redirect(method={"playerLoadedChunk"}, at=@At(value="INVOKE", target="Ljava/util/Iterator;next()Ljava/lang/Object;", ordinal=1))
    private Object playerLoadedChunkLeashShipIteratorPeekImpl(Iterator<Entity> instance) {
        if (this.peekedEntity != null) {
            Entity next = this.peekedEntity;
            this.peekedEntity = null;
            return next;
        }
        return instance.next();
    }
}

