/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.mixin.leashing.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.talhanation.smallships.duck.BoatLeashAccess;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BoatRenderer.class})
public abstract class BoatRendererMixin
extends EntityRenderer<Boat> {
    protected BoatRendererMixin(EntityRendererProvider.Context context) {
        super(context);
        throw new AssertionError();
    }

    @Shadow
    @NotNull
    public abstract ResourceLocation m_5478_(Boat var1);

    public boolean shouldRender(Boat boat, Frustum frustum, double d, double e, double f) {
        if (super.m_5523_((Entity)boat, frustum, d, e, f)) {
            return true;
        }
        Entity entity = ((BoatLeashAccess)boat).getLeashHolder();
        return entity != null ? frustum.m_113029_(entity.m_6921_()) : false;
    }

    @Inject(method={"render(Lnet/minecraft/world/entity/vehicle/Boat;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="RETURN")})
    private void renderLeashBoat(Boat boat, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, CallbackInfo ci) {
        Entity entity = ((BoatLeashAccess)boat).getLeashHolder();
        if (entity != null) {
            this.renderLeash(boat, g, poseStack, multiBufferSource, entity);
        }
    }

    private <E extends Entity> void renderLeash(Boat boat, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, E entity) {
        int v;
        poseStack.m_85836_();
        Vec3 vec3 = entity.m_7398_(f);
        double d = Mth.m_14139_((double)f, (double)0.0, (double)0.0) * 0.01745329238474369 + 1.5707963267948966;
        Vec3 vec32 = boat.m_7939_();
        double e = Math.cos(d) * vec32.f_82481_ + Math.sin(d) * vec32.f_82479_;
        double g = Math.sin(d) * vec32.f_82481_ - Math.cos(d) * vec32.f_82479_;
        double h = Mth.m_14139_((double)f, (double)boat.f_19854_, (double)boat.m_20185_()) + e;
        double i = Mth.m_14139_((double)f, (double)boat.f_19855_, (double)boat.m_20186_()) + vec32.f_82480_;
        double j = Mth.m_14139_((double)f, (double)boat.f_19856_, (double)boat.m_20189_()) + g;
        poseStack.m_85837_(e, vec32.f_82480_, g);
        float k = (float)(vec3.f_82479_ - h);
        float l = (float)(vec3.f_82480_ - i);
        float m = (float)(vec3.f_82481_ - j);
        float n = 0.025f;
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110475_());
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        float o = Mth.m_14195_((float)(k * k + m * m)) * n / 2.0f;
        float p = m * o;
        float q = k * o;
        BlockPos blockPos = new BlockPos(boat.m_20299_(f));
        BlockPos blockPos2 = new BlockPos(entity.m_20299_(f));
        int r = this.m_6086_((Entity)boat, blockPos);
        int s = this.f_114476_.m_114382_(entity).m_6086_(entity, blockPos2);
        int t = boat.f_19853_.m_45517_(LightLayer.SKY, blockPos);
        int u = boat.f_19853_.m_45517_(LightLayer.SKY, blockPos2);
        for (v = 0; v <= 24; ++v) {
            MobRenderer.m_174307_((VertexConsumer)vertexConsumer, (Matrix4f)matrix4f, (float)k, (float)l, (float)m, (int)r, (int)s, (int)t, (int)u, (float)n, (float)n, (float)p, (float)q, (int)v, (boolean)false);
        }
        for (v = 24; v >= 0; --v) {
            MobRenderer.m_174307_((VertexConsumer)vertexConsumer, (Matrix4f)matrix4f, (float)k, (float)l, (float)m, (int)r, (int)s, (int)t, (int)u, (float)n, (float)0.0f, (float)p, (float)q, (int)v, (boolean)true);
        }
        poseStack.m_85849_();
    }
}

