/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.network.forge;

import com.talhanation.smallships.network.forge.ForgePacket;
import com.talhanation.smallships.world.entity.ship.ContainerShip;
import com.talhanation.smallships.world.inventory.ContainerUtility;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundOpenShipScreenForgePacket
implements ForgePacket {
    private final UUID ship;
    private final int pageIndex;

    ServerboundOpenShipScreenForgePacket(ContainerShip containerShip, int pageIndex) {
        this.ship = containerShip.m_142081_();
        this.pageIndex = pageIndex;
    }

    public ServerboundOpenShipScreenForgePacket(FriendlyByteBuf buf) {
        this.ship = buf.m_130259_();
        this.pageIndex = buf.readInt();
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.ship);
        buf.writeInt(this.pageIndex);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            player.m_183503_().m_6443_(ContainerShip.class, player.m_6921_().m_82400_(16.0), containerShip -> containerShip.m_142081_().equals(this.ship)).stream().filter(Entity::m_6084_).findAny().ifPresent(containerShip -> {
                int pageIndex = Mth.m_14045_((int)this.pageIndex, (int)0, (int)(containerShip.containerData.m_6413_(1) - 1));
                containerShip.containerData.m_8050_(2, pageIndex);
                ContainerUtility.openShipMenu((Player)player, containerShip);
            });
        });
        ctx.get().setPacketHandled(true);
    }
}

