/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.projectile;

import com.mojang.datafixers.util.Pair;
import com.talhanation.smallships.world.entity.projectile.CannonBallEntity;
import com.talhanation.smallships.world.entity.ship.Ship;
import com.talhanation.smallships.world.entity.ship.abilities.Cannonable;
import com.talhanation.smallships.world.sound.ModSoundTypes;
import java.util.Objects;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class Cannon
extends Entity {
    private final Random random;
    private final double offsetX;
    private final double offsetY;
    private final double offsetZ;
    private int time;
    private int coolDown;
    private final Ship ship;
    private final Level level;
    private double angle;
    private boolean isRightSided;
    private boolean isLeftSided;

    public Cannon(Ship ship, Cannonable.CannonPosition cannonPosition) {
        this(ship, cannonPosition.x, cannonPosition.y, cannonPosition.z, cannonPosition.isRightSided, !cannonPosition.isRightSided);
    }

    public Cannon(Ship ship, double offsetX, double offsetY, double offsetZ, boolean isRightSided, boolean isLeftSided) {
        super(EntityType.f_20529_, ship.m_183503_());
        this.ship = ship;
        this.level = ship.m_183503_();
        this.random = this.level.m_5822_();
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        this.resetTimer();
        this.coolDown = 0;
        if (isRightSided) {
            this.setRightSided();
        }
        if (isLeftSided) {
            this.setLeftSided();
        }
    }

    public void m_8119_() {
        if (this.coolDown > 0) {
            --this.coolDown;
        }
        this.updatePosition();
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compoundTag) {
    }

    protected void m_7380_(CompoundTag compoundTag) {
    }

    public Packet<?> m_5654_() {
        return null;
    }

    public void trigger() {
        if (this.coolDown == 0) {
            if (this.time > 0) {
                --this.time;
            }
            if (this.time == 0) {
                this.shoot();
                this.resetTimer();
                this.setCoolDown();
            }
        }
    }

    public void trigger(Vec3 shootVec, double yShootVec, LivingEntity driverEntity, double speed, double accuracy) {
        if (this.coolDown == 0) {
            if (this.time > 0) {
                --this.time;
            }
            if (this.time == 0) {
                this.shoot(shootVec, yShootVec, driverEntity, speed, accuracy);
                this.resetTimer();
                this.setCoolDown();
            }
        }
    }

    public void updatePosition() {
        Vec3 forward = this.ship.m_20156_();
        float x0 = 0.0f;
        double f0 = Math.cos(this.ship.m_146908_() * ((float)Math.PI / 180)) * (double)x0;
        double f1 = Math.sin(this.ship.m_146908_() * ((float)Math.PI / 180)) * (double)x0;
        double f2 = this.getOffsetX();
        double d1 = this.ship.m_20185_() - forward.f_82479_ * f2 + f0;
        double d2 = this.ship.m_20186_() - forward.f_82480_ + this.getOffsetY();
        double d3 = this.ship.m_20189_() - forward.f_82481_ * f2 + f1;
        this.m_6027_(d1, d2, d3);
    }

    private void resetTimer() {
        this.time = 10 + this.random.nextInt(10);
    }

    private void setCoolDown() {
        this.coolDown = 50;
    }

    public void shoot() {
        LivingEntity driverEntity = (LivingEntity)this.ship.m_6688_();
        if (driverEntity == null) {
            return;
        }
        Vec3 forward = this.ship.m_20156_().m_82541_();
        Vec3 shootVec = this.getShootVector(forward, driverEntity);
        double speed = 2.2f;
        double accuracy = 3.0;
        boolean playerView = driverEntity.m_20154_().f_82480_ >= 0.0;
        double yShootVec = playerView ? shootVec.m_7098_() + driverEntity.m_20154_().f_82480_ * (double)0.95f : shootVec.m_7098_() + (double)0.15f;
        this.shoot(shootVec, yShootVec, driverEntity, speed, accuracy);
    }

    public void shoot(Vec3 shootVec, double yShootVec, LivingEntity driverEntity, double speed, double accuracy) {
        if (shootVec != null) {
            CannonBallEntity cannonBallEntity = new CannonBallEntity(this.level, driverEntity, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
            cannonBallEntity.m_6686_(shootVec.m_7096_(), yShootVec, shootVec.m_7094_(), (float)speed, (float)accuracy);
            this.level.m_7967_((Entity)cannonBallEntity);
            this.ship.m_5496_(SoundEvents.f_12512_, 1.0f, 1.125f);
            this.playCannonShotSound();
            Ship ship = this.ship;
            if (ship instanceof Cannonable) {
                Cannonable cannonable = (Cannonable)((Object)ship);
                cannonable.consumeCannonBall();
            }
        }
    }

    public Vec3 getShootVector(Vec3 forward, LivingEntity driver) {
        Vec3 VecRight = forward.m_82524_(-1.57f).m_82541_();
        Vec3 VecLeft = forward.m_82524_(1.57f).m_82541_();
        Vec3 playerVec = driver.m_20154_().m_82541_();
        if (playerVec.m_82554_(VecLeft) > playerVec.m_82554_(VecRight)) {
            return VecRight;
        }
        if (playerVec.m_82554_(VecLeft) < playerVec.m_82554_(VecRight)) {
            return VecLeft;
        }
        return null;
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public double getOffsetZ() {
        return this.offsetZ;
    }

    public float getAngle() {
        return (float)this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public void setLeftSided() {
        this.isLeftSided = true;
        this.setAngle(0.0);
    }

    public void setRightSided() {
        this.isRightSided = true;
        this.setAngle(180.0);
    }

    public boolean isRightSided() {
        return this.isRightSided;
    }

    public boolean canShootDirection() {
        LivingEntity driver = (LivingEntity)this.ship.m_6688_();
        if (driver == null) {
            return false;
        }
        Vec3 forward = this.ship.m_20156_().m_82541_();
        Vec3 shootVec = this.getShootVector(forward, driver);
        Vec3 VecRight = forward.m_82524_(-1.57f).m_82541_();
        Vec3 VecLeft = forward.m_82524_(1.57f).m_82541_();
        if (this.isRightSided && Objects.equals(shootVec, VecRight)) {
            return true;
        }
        return this.isLeftSided && Objects.equals(shootVec, VecLeft);
    }

    public CompoundTag getData() {
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.m_128347_("x", this.getOffsetX());
        compoundtag.m_128347_("y", this.getOffsetY());
        compoundtag.m_128347_("z", this.getOffsetZ());
        compoundtag.m_128379_("isRightSided", this.isRightSided());
        return compoundtag;
    }

    private void playCannonShotSound() {
        BiConsumer<SoundEvent, Pair> play = (sound, modifier) -> {
            if (!this.ship.m_183503_().m_5776_()) {
                this.ship.m_5496_((SoundEvent)sound, ((Float)modifier.getFirst()).floatValue(), ((Float)modifier.getSecond()).floatValue());
            } else {
                this.ship.m_183503_().m_7785_(this.ship.m_20185_(), this.ship.m_20186_() + 4.0, this.ship.m_20189_(), sound, this.ship.m_5720_(), ((Float)modifier.getFirst()).floatValue(), ((Float)modifier.getSecond()).floatValue(), false);
            }
        };
        play.accept(ModSoundTypes.CANNON_SHOT, Pair.of((Object)Float.valueOf(10.0f), (Object)Float.valueOf(1.0f)));
    }
}

