/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.ship.abilities;

import com.talhanation.smallships.world.entity.ship.Ship;
import com.talhanation.smallships.world.entity.ship.abilities.Ability;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;

public interface Bannerable
extends Ability {
    public BannerPosition getBannerPosition();

    default public void tickBannerShip() {
        if (!this.self().getData(Ship.BANNER).m_41619_()) {
            this.self().prevBannerWaveAngle = this.self().bannerWaveAngle;
            this.self().bannerWaveAngle = (float)Math.sin(this.getBannerWaveSpeed() * (float)this.self().f_19797_) * this.getBannerWaveFactor();
        }
    }

    default public void defineBannerShipSynchedData() {
        this.self().m_20088_().m_135372_(Ship.BANNER, (Object)ItemStack.f_41583_);
    }

    default public void readBannerShipSaveData(CompoundTag tag) {
        Tag bannerTag = tag.m_128423_("Banner");
        if (bannerTag instanceof CompoundTag) {
            CompoundTag bannerCompound = (CompoundTag)bannerTag;
            this.self().setData(Ship.BANNER, ItemStack.m_41712_((CompoundTag)bannerCompound));
        }
    }

    default public void addBannerShipSaveData(CompoundTag tag) {
        tag.m_128365_("Banner", (Tag)this.self().getData(Ship.BANNER).m_41739_(new CompoundTag()));
    }

    default public boolean interactBanner(Player player, InteractionHand interactionHand) {
        ItemStack item = player.m_21120_(interactionHand);
        ItemStack shipBanner = this.self().getData(Ship.BANNER);
        shipBanner.m_41764_(1);
        if (item.m_41720_() instanceof BannerItem) {
            if (!shipBanner.m_41619_()) {
                this.self().m_5552_(shipBanner, 4.0f);
            }
            this.self().setData(Ship.BANNER, item.m_41777_());
            if (!player.m_7500_()) {
                item.m_41774_(1);
            }
            this.self().m_183503_().m_6263_(player, this.self().m_20185_(), this.self().m_20186_() + 4.0, this.self().m_20189_(), SoundEvents.f_12641_, this.self().m_5720_(), 15.0f, 1.0f);
            return true;
        }
        if (item.m_41720_() instanceof ShearsItem && !shipBanner.m_41619_()) {
            this.self().m_5552_(shipBanner, 4.0f);
            this.self().setData(Ship.BANNER, ItemStack.f_41583_);
            this.self().m_183503_().m_6263_(player, this.self().m_20185_(), this.self().m_20186_() + 4.0, this.self().m_20189_(), SoundEvents.f_12641_, this.self().m_5720_(), 15.0f, 1.0f);
            return true;
        }
        return false;
    }

    default public float getBannerWaveFactor() {
        return this.self().m_183503_().m_46471_() ? 4.5f : 3.0f;
    }

    default public float getBannerWaveSpeed() {
        return this.self().m_183503_().m_46471_() ? 0.55f : 0.25f;
    }

    default public float getBannerWaveAngle(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.self().prevBannerWaveAngle, (float)this.self().bannerWaveAngle);
    }

    public static class BannerPosition {
        public final float yp;
        public final float zp;
        public final double x;
        public final double y;
        public final double z;

        public BannerPosition(float yp, float zp, double x, double y, double z) {
            this.yp = yp;
            this.zp = zp;
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

