/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.inventory;

import com.talhanation.smallships.network.ModPackets;
import com.talhanation.smallships.world.entity.ship.ContainerShip;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ShipContainerMenu
extends AbstractContainerMenu {
    public static final int COLUMNS = 9;
    private final Inventory inventory;
    private final Container container;
    private final ContainerData containerData;

    public ShipContainerMenu(MenuType<ShipContainerMenu> type, int syncId, Inventory inventory, ContainerShip containerShip) {
        super(type, syncId);
        this.containerData = containerShip.containerData;
        ShipContainerMenu.m_38869_((Container)containerShip, (int)(this.getRowCount() * 9));
        this.container = containerShip;
        this.inventory = inventory;
        this.m_38884_(this.containerData);
        this.openPage();
    }

    private void openPage() {
        int m;
        int l;
        this.container.m_5856_(this.inventory.f_35978_);
        int k = (this.getRowCount() - 4) * 18;
        for (l = 0; l < this.getRowCount(); ++l) {
            for (m = 0; m < 9; ++m) {
                this.m_38897_(new Slot(this.container, m + l * 9 + this.getPageIndex() * this.getRowCount() * 9, 8 + m * 18, 18 + l * 18));
            }
        }
        for (l = 0; l < 3; ++l) {
            for (m = 0; m < 9; ++m) {
                this.m_38897_(new Slot((Container)this.inventory, m + l * 9 + 9, 8 + m * 18, 103 + l * 18 + k));
            }
        }
        for (l = 0; l < 9; ++l) {
            this.m_38897_(new Slot((Container)this.inventory, l, 8 + l * 18, 161 + k));
        }
    }

    public void m_182410_(int stateId, @NotNull List<ItemStack> list, @NotNull ItemStack itemStack) {
        super.m_182410_(stateId, list, itemStack);
    }

    public boolean m_6366_(@NotNull Player player, int i) {
        int pageIndex = Mth.m_14045_((int)(this.getPageIndex() + i), (int)0, (int)(this.getPageCount() - 1));
        ModPackets.clientSendPacket(player, ModPackets.serverOpenShipScreen.apply(this.container, pageIndex));
        this.updatePaging(this.getRowCount(), this.getPageCount(), pageIndex);
        return true;
    }

    public boolean m_6875_(@NotNull Player player) {
        return this.container.m_6542_(player);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int i) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(i);
        if (slot.m_6657_()) {
            ItemStack slotItemStack = slot.m_7993_();
            itemStack = slotItemStack.m_41777_();
            if (i < this.getRowCount() * 9 ? !this.m_38903_(slotItemStack, this.getRowCount() * 9, this.f_38839_.size(), true) : !this.m_38903_(slotItemStack, 0, this.getRowCount() * 9, false)) {
                return ItemStack.f_41583_;
            }
            if (slotItemStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemStack;
    }

    public void m_6877_(@NotNull Player player) {
        super.m_6877_(player);
        this.container.m_5785_(player);
    }

    public int getRowCount() {
        return this.containerData.m_6413_(0);
    }

    public int getPageCount() {
        return this.containerData.m_6413_(1);
    }

    public int getPageIndex() {
        return this.containerData.m_6413_(2);
    }

    public void updatePaging(int rows, int pages, int pageIndex) {
        this.containerData.m_8050_(0, rows);
        this.containerData.m_8050_(1, pages);
        this.containerData.m_8050_(2, pageIndex);
    }

    public ContainerShip getContainerShip() {
        return (ContainerShip)this.container;
    }

    public void m_38893_(ContainerListener containerListener) {
        super.m_38893_(containerListener);
    }

    public String toString() {
        return "ShipContainerMenu{rows=" + this.getRowCount() + ", pages=" + this.getPageCount() + ", pageIndex=" + this.getPageIndex() + ", itemStacksSize=" + this.getContainerShip().getItemStacks().size() + "}";
    }
}

