/*
 * Decompiled with CFR 0.152.
 */
package port;

import com.talhanation.smallships.world.entity.ship.abilities.Ability;
import java.util.function.BiConsumer;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ContainerEntity
extends Container,
MenuProvider,
Ability {
    @Nullable
    public ResourceLocation getLootTable();

    public void setLootTable(@Nullable ResourceLocation var1);

    public long getLootTableSeed();

    public void setLootTableSeed(long var1);

    public NonNullList<ItemStack> getItemStacks();

    public void clearItemStacks();

    default public boolean m_7983_() {
        return this.isChestVehicleEmpty();
    }

    default public void addChestVehicleSaveData(CompoundTag compoundTag) {
        if (this.getLootTable() != null) {
            compoundTag.m_128359_("LootTable", this.getLootTable().toString());
            if (this.getLootTableSeed() != 0L) {
                compoundTag.m_128356_("LootTableSeed", this.getLootTableSeed());
            }
        } else {
            ContainerHelper.m_18973_((CompoundTag)compoundTag, this.getItemStacks());
        }
    }

    default public void readChestVehicleSaveData(CompoundTag compoundTag) {
        this.clearItemStacks();
        if (compoundTag.m_128425_("LootTable", 8)) {
            this.setLootTable(new ResourceLocation(compoundTag.m_128461_("LootTable")));
            this.setLootTableSeed(compoundTag.m_128454_("LootTableSeed"));
        } else {
            ContainerHelper.m_18980_((CompoundTag)compoundTag, this.getItemStacks());
        }
    }

    default public void chestVehicleDestroyed(DamageSource damageSource, Level level, Entity entity) {
        Entity entity2;
        if (!level.m_46469_().m_46207_(GameRules.f_46137_)) {
            return;
        }
        Containers.m_18998_((Level)level, (Entity)entity, (Container)this);
        if (!level.f_46443_ && (entity2 = damageSource.m_7640_()) != null && entity2.m_6095_() == EntityType.f_20532_) {
            PiglinAi.m_34873_((Player)((Player)entity2), (boolean)true);
        }
    }

    default public InteractionResult interactWithChestVehicle(BiConsumer<GameEvent, Entity> biConsumer, Player player) {
        player.m_5893_((MenuProvider)this);
        if (!player.f_19853_.f_46443_) {
            biConsumer.accept(GameEvent.f_157803_, (Entity)player);
            PiglinAi.m_34873_((Player)player, (boolean)true);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    default public void unpackChestVehicleLootTable(@Nullable Player player) {
        MinecraftServer minecraftServer = this.self().m_183503_().m_142572_();
        if (this.getLootTable() != null && minecraftServer != null) {
            LootTable lootTable = minecraftServer.m_129898_().m_79217_(this.getLootTable());
            if (player != null) {
                CriteriaTriggers.f_10563_.m_54597_((ServerPlayer)player, this.getLootTable());
            }
            this.setLootTable(null);
            LootContext.Builder builder = new LootContext.Builder((ServerLevel)this.self().m_183503_()).m_78972_(LootContextParams.f_81460_, (Object)this.self().m_20182_()).m_78965_(this.getLootTableSeed());
            if (player != null) {
                builder.m_78963_(player.m_36336_()).m_78972_(LootContextParams.f_81455_, (Object)player);
            }
            lootTable.m_79123_((Container)this, builder.m_78975_(LootContextParamSets.f_81411_));
        }
    }

    default public void clearChestVehicleContent() {
        this.unpackChestVehicleLootTable(null);
        this.getItemStacks().clear();
    }

    default public boolean isChestVehicleEmpty() {
        for (ItemStack itemStack : this.getItemStacks()) {
            if (itemStack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    default public ItemStack removeChestVehicleItemNoUpdate(int n) {
        this.unpackChestVehicleLootTable(null);
        ItemStack itemStack = (ItemStack)this.getItemStacks().get(n);
        if (itemStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.getItemStacks().set(n, (Object)ItemStack.f_41583_);
        return itemStack;
    }

    default public ItemStack getChestVehicleItem(int n) {
        this.unpackChestVehicleLootTable(null);
        return (ItemStack)this.getItemStacks().get(n);
    }

    default public ItemStack removeChestVehicleItem(int n, int n2) {
        this.unpackChestVehicleLootTable(null);
        return ContainerHelper.m_18969_(this.getItemStacks(), (int)n, (int)n2);
    }

    default public void setChestVehicleItem(int n, ItemStack itemStack) {
        this.unpackChestVehicleLootTable(null);
        this.getItemStacks().set(n, (Object)itemStack);
        if (!itemStack.m_41619_() && itemStack.m_41613_() > this.m_6893_()) {
            itemStack.m_41764_(this.m_6893_());
        }
    }

    default public SlotAccess getChestVehicleSlot(final int n) {
        if (n >= 0 && n < this.m_6643_()) {
            return new SlotAccess(){

                @NotNull
                public ItemStack m_142196_() {
                    return ContainerEntity.this.getChestVehicleItem(n);
                }

                public boolean m_142104_(@NotNull ItemStack itemStack) {
                    ContainerEntity.this.setChestVehicleItem(n, itemStack);
                    return true;
                }
            };
        }
        return SlotAccess.f_147290_;
    }

    default public boolean isChestVehicleStillValid(Player player) {
        return !this.self().m_146910_() && this.self().m_20182_().m_82509_((Position)player.m_20182_(), 8.0);
    }
}

