/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vaultintegrations.altar;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.exceptions.FailedConnectionException;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.INetworkNodeGraphEntry;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.NetworkNodeGraphEntry;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.blockentity.ControllerBlockEntity;
import iskallia.vault.VaultMod;
import iskallia.vault.altar.AltarInfusionRecipe;
import iskallia.vault.altar.RequiredItems;
import iskallia.vault.block.entity.VaultAltarTileEntity;
import iskallia.vaultintegrations.VaultIntegrations;
import iskallia.vaultintegrations.altar.FloatingItem;
import iskallia.vaultintegrations.block.entity.AltarConduitBlockEntity;
import iskallia.vaultintegrations.init.VIBlocks;
import iskallia.vaultintegrations.init.VIConfigs;
import iskallia.vaultintegrations.inventory.UpgradeItemContainer;
import iskallia.vaultintegrations.mixin.NetworkNodeGraphAccessor;
import iskallia.vaultintegrations.util.VecUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class AltarConduitNode
extends NetworkNode
implements IGridNodeListener<AltarConduitBlockEntity> {
    public static final ResourceLocation ID = VaultMod.id((String)"altar_conduit_network_node");
    private AltarConduitBlockEntity altarConduit;
    private IManagedGridNode aeNode;
    private IGridConnection aeConnection;

    public AltarConduitNode(@NotNull AltarConduitBlockEntity altarConduit, Level level, BlockPos pos) {
        super(level, pos);
        this.owner = altarConduit.getOwner();
        if (!this.level.f_46443_) {
            this.setupAE(level, pos);
        }
    }

    private void setupAE(Level level, BlockPos pos) {
        Player player;
        if (this.getAltarConduit().isEmpty()) {
            return;
        }
        this.aeNode = GridHelper.createManagedNode((Object)((Object)this.altarConduit), (IGridNodeListener)this).setIdlePowerUsage((double)this.getEnergyUsage() / 2.5).setVisualRepresentation(AEItemKey.of((ItemLike)((ItemLike)VIBlocks.ALTAR_CONDUIT_BLOCK.get())));
        if (this.owner != null && (player = this.level.m_46003_(this.owner)) != null) {
            this.aeNode.setOwningPlayer(player);
        }
        this.aeNode.create(level, pos);
    }

    public IManagedGridNode getAeNode() {
        return this.aeNode;
    }

    private boolean shouldUpdate() {
        if (!this.level.m_46749_(this.pos) || this.level.m_5776_()) {
            return false;
        }
        Optional<VaultAltarTileEntity> altarOptional = this.altarConduit.getAltar();
        if (altarOptional.isEmpty()) {
            return false;
        }
        VaultAltarTileEntity altar = altarOptional.get();
        if (altar.getAltarState() != VaultAltarTileEntity.AltarState.ACCEPTING) {
            return false;
        }
        AltarInfusionRecipe recipe = altar.getRecipe();
        if (recipe == null || recipe.isComplete()) {
            return false;
        }
        Player player = this.level.m_46003_(altar.getOwner());
        return player != null;
    }

    private Optional<AltarConduitBlockEntity> getAltarConduit() {
        BlockEntity blockEntity;
        if (this.level != null && (blockEntity = this.level.m_7702_(this.pos)) instanceof AltarConduitBlockEntity) {
            AltarConduitBlockEntity conduit;
            this.altarConduit = conduit = (AltarConduitBlockEntity)blockEntity;
        }
        return Optional.ofNullable(this.altarConduit);
    }

    public void update() {
        super.update();
        if (this.getAltarConduit().isEmpty()) {
            return;
        }
        boolean aeConnected = false;
        boolean rsConnected = false;
        BlockPos controllerPos = this.updateRSConnection();
        if (controllerPos != BlockPos.f_121853_) {
            rsConnected = true;
        } else {
            controllerPos = this.updateAEConnections();
            if (controllerPos != BlockPos.f_121853_) {
                aeConnected = true;
            }
        }
        if (controllerPos == BlockPos.f_121853_ || !this.shouldUpdate() || !this.isInRange(controllerPos)) {
            return;
        }
        UpgradeItemContainer upgrades = this.altarConduit.getUpgrades();
        int speed = this.getSpeed(upgrades);
        long gameTime = this.level.m_46467_();
        if (gameTime % (long)speed != 0L) {
            return;
        }
        int stackCount = upgrades.getQuantityUpgradeCount();
        int maxItems = this.getQuantity(stackCount);
        boolean teleport = upgrades.getTeleportUpgradeCount() != 0;
        this.extractItems(controllerPos, aeConnected, rsConnected, maxItems, teleport);
    }

    private void extractItems(BlockPos controllerPos, boolean aeConnected, boolean rsConnected, int maxItems, boolean teleport) {
        List<RequiredItems> requiredItems = this.altarConduit.getAltar().orElseThrow().getRecipe().getRequiredItems().stream().filter(required -> !required.isComplete()).toList();
        for (RequiredItems requiredItem : requiredItems) {
            int amountSent = this.altarConduit.getFloatingItemCount(requiredItem);
            if (amountSent >= requiredItem.getAmountRequired() - requiredItem.getCurrentAmount()) continue;
            int limit = Math.min(maxItems, requiredItem.getAmountRequired() - (requiredItem.getCurrentAmount() + amountSent));
            List<ItemStack> items = requiredItem.getItems().stream().filter(stack -> !this.altarConduit.getBlacklist().isBlacklisted((ItemStack)stack)).toList();
            for (ItemStack stack2 : items) {
                if (rsConnected) {
                    ItemStack extracted = Objects.requireNonNull(this.network).extractItem(stack2, limit, 0, Action.PERFORM);
                    if (extracted.m_41619_() || extracted.m_41613_() <= 0) continue;
                    FloatingItem item = new FloatingItem(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)stack2.m_41720_()), Vec3.m_82512_((Vec3i)controllerPos).m_82549_(VecUtils.getRandomOffset(0.0f, 0.35f)), extracted.m_41613_());
                    if (teleport) {
                        if (!this.altarConduit.insertItem(item)) {
                            this.altarConduit.returnItems(List.of(item), controllerPos);
                        }
                        return;
                    }
                    this.altarConduit.addFloatingItem(item);
                    return;
                }
                if (!aeConnected) continue;
                IGrid grid = this.aeNode.getGrid();
                if (grid == null) {
                    return;
                }
                KeyCounter cachedInventory = grid.getStorageService().getCachedInventory();
                MEStorage inventory = grid.getStorageService().getInventory();
                Collection keys = cachedInventory.findFuzzy((AEKey)AEItemKey.of((ItemLike)stack2.m_41720_()), FuzzyMode.IGNORE_ALL);
                keys.stream().findFirst().ifPresent(key -> {
                    int amount = (int)inventory.extract((AEKey)key.getKey(), (long)limit, Actionable.MODULATE, IActionSource.empty());
                    if (amount != 0) {
                        FloatingItem item = new FloatingItem(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)stack2.m_41720_()), Vec3.m_82512_((Vec3i)controllerPos).m_82549_(VecUtils.getRandomOffset(0.0f, 0.35f)), amount);
                        if (teleport) {
                            if (!this.altarConduit.insertItem(item)) {
                                this.altarConduit.returnItems(List.of(item), controllerPos);
                            }
                            return;
                        }
                        this.altarConduit.addFloatingItem(item);
                    }
                });
            }
        }
    }

    private int getSpeed(UpgradeItemContainer upgrades) {
        int count = upgrades.getSpeedUpgradeCount();
        int speed = 13;
        return speed - count * 3;
    }

    private int getQuantity(int stackCount) {
        if (stackCount == 1) {
            return 8;
        }
        if (stackCount == 2) {
            return 32;
        }
        if (stackCount == 3) {
            return 64;
        }
        if (stackCount == 4) {
            return 128;
        }
        return 1;
    }

    private boolean isInRange(BlockPos controllerPos) {
        double maxDistance = VIConfigs.ALTAR_CONDUIT.getMaxDistance();
        double distanceSqr = controllerPos.m_123331_((Vec3i)this.pos);
        return distanceSqr <= maxDistance * maxDistance;
    }

    public int getEnergyUsage() {
        return (int)VIConfigs.ALTAR_CONDUIT.getRFUsagePerTick();
    }

    public ResourceLocation getId() {
        return ID;
    }

    private BlockPos updateRSConnection() {
        Optional<ControllerBlockEntity> rsController = this.altarConduit.getRSController();
        if (rsController.isEmpty()) {
            return BlockPos.f_121853_;
        }
        INetwork thisNetwork = this.getNetwork();
        INetwork controllerNetwork = rsController.get().getNetwork();
        if (controllerNetwork.equals(thisNetwork)) {
            return rsController.get().m_58899_();
        }
        this.onConnected(controllerNetwork);
        INetwork connected = this.getNetwork();
        if (connected != null && connected.equals(controllerNetwork)) {
            return rsController.get().m_58899_();
        }
        return BlockPos.f_121853_;
    }

    public void onConnected(INetwork controllerNetwork) {
        super.onConnected(controllerNetwork);
        Set<INetworkNodeGraphEntry> entries = ((NetworkNodeGraphAccessor)controllerNetwork.getNodeGraph()).getEntries();
        boolean exists = false;
        for (INetworkNodeGraphEntry entry : entries) {
            INetworkNode node = entry.getNode();
            if (!node.equals((Object)this)) continue;
            exists = true;
        }
        if (!exists) {
            entries.add((INetworkNodeGraphEntry)new NetworkNodeGraphEntry((INetworkNode)this));
        }
    }

    public void onDisconnected(INetwork network) {
        Level level;
        super.onDisconnected(network);
        if (this.network != null) {
            VaultIntegrations.LOGGER.info("AltarConduitNode#onDisconnected(): Invalidating...");
            this.network.getNodeGraph().invalidate(Action.PERFORM, this.network.getLevel(), this.network.getPosition());
            VaultIntegrations.LOGGER.info("AltarConduitNode#onDisconnected(): Invalidation Complete...");
        }
        if ((level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            API.instance().getNetworkNodeManager(serverLevel).removeNode(this.pos);
        }
    }

    public void disconnect() {
        Level level;
        if (this.aeNode != null) {
            this.aeNode.destroy();
        }
        if (this.network != null) {
            VaultIntegrations.LOGGER.info("AltarConduitNode#disconnect(): Invalidating...");
            this.network.getNodeGraph().invalidate(Action.PERFORM, this.network.getLevel(), this.network.getPosition());
            VaultIntegrations.LOGGER.info("AltarConduitNode#disconnect(): Invalidation Complete...");
            this.onDisconnected(this.network);
        }
        if ((level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            API.instance().getNetworkNodeManager(serverLevel).removeNode(this.pos);
        }
    }

    private BlockPos updateAEConnections() {
        if (this.aeNode == null) {
            return BlockPos.f_121853_;
        }
        IGridNode node = this.aeNode.getNode();
        if (node == null) {
            return BlockPos.f_121853_;
        }
        Optional<appeng.blockentity.networking.ControllerBlockEntity> aeControllerOptional = this.altarConduit.getAEController();
        if (aeControllerOptional.isEmpty()) {
            return BlockPos.f_121853_;
        }
        appeng.blockentity.networking.ControllerBlockEntity aeController = aeControllerOptional.get();
        try {
            IGridNode controllerGridNode = aeController.getGridNode();
            if (controllerGridNode != null && controllerGridNode.getConnections().contains(this.aeConnection)) {
                return aeController.m_58899_();
            }
            if (controllerGridNode != null) {
                this.aeConnection = GridHelper.createGridConnection((IGridNode)node, (IGridNode)controllerGridNode);
                return aeController.m_58899_();
            }
        }
        catch (FailedConnectionException ignored) {
            return aeController.m_58899_();
        }
        return BlockPos.f_121853_;
    }

    public void onSecurityBreak(AltarConduitBlockEntity altarTileEntity, IGridNode iGridNode) {
    }

    public void onSaveChanges(AltarConduitBlockEntity altarTileEntity, IGridNode iGridNode) {
    }
}

