/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vaultintegrations.block;

import appeng.items.tools.quartz.QuartzWrenchItem;
import com.refinedmods.refinedstorage.item.WrenchItem;
import iskallia.vault.block.entity.VaultAltarTileEntity;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.util.BlockHelper;
import iskallia.vault.world.data.PlayerVaultAltarData;
import iskallia.vaultintegrations.block.entity.AltarConduitBlockEntity;
import iskallia.vaultintegrations.data.AltarConduitData;
import iskallia.vaultintegrations.init.VIBlocks;
import iskallia.vaultintegrations.inventory.UpgradeItemContainer;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AltarConduitBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);

    public AltarConduitBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_().m_60913_(1.5f, 3600000.0f));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return ((BlockEntityType)VIBlocks.ALTAR_CONDUIT_BLOCK_ENTITY.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return BlockHelper.getTicker(type, (BlockEntityType)((BlockEntityType)VIBlocks.ALTAR_CONDUIT_BLOCK_ENTITY.get()), AltarConduitBlockEntity::tick);
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        if (level instanceof ServerLevel) {
            BlockEntity blockEntity;
            ServerLevel serverLevel = (ServerLevel)level;
            BlockEntity blockEntity2 = serverLevel.m_7702_(pos);
            if (!(blockEntity2 instanceof AltarConduitBlockEntity)) {
                return;
            }
            AltarConduitBlockEntity altarInterface = (AltarConduitBlockEntity)blockEntity2;
            BlockPos below = pos.m_7495_();
            if (below.equals((Object)neighbor) && serverLevel.m_8055_(neighbor).m_60795_()) {
                altarInterface.setAltar(null);
            } else if (below.equals((Object)neighbor) && (blockEntity = serverLevel.m_7702_(neighbor)) instanceof VaultAltarTileEntity) {
                VaultAltarTileEntity altar = (VaultAltarTileEntity)blockEntity;
                altarInterface.setAltar(altar);
            }
        }
    }

    public void m_6402_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity player, @NotNull ItemStack stack) {
        if (player instanceof FakePlayer) {
            if (!level.m_8055_(pos).m_60795_()) {
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            }
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AltarConduitBlockEntity) {
            CompoundTag tag;
            AltarConduitBlockEntity altarConduit = (AltarConduitBlockEntity)blockEntity;
            if (stack.m_41782_() && (tag = stack.m_41784_()).m_128441_("controllerPos")) {
                altarConduit.setControllerPos(NbtUtils.m_129239_((CompoundTag)tag.m_128469_("controllerPos")));
            }
            if (player != null) {
                altarConduit.setOwner(player.m_142081_());
            }
            altarConduit.setPlacedPos(pos);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                AltarConduitData data = AltarConduitData.get(serverPlayer.f_8924_);
                if (!data.setConduitLocation(serverPlayer, pos)) {
                    BlockPos conduitLocation = data.getConduitLocation(serverPlayer);
                    player.m_6352_((Component)new TextComponent("Unable to place the Altar Conduit. You already have one placed in the world at " + String.valueOf(conduitLocation) + "]").m_130940_(ChatFormatting.RED), Util.f_137441_);
                    if (!level.m_8055_(pos).m_60795_()) {
                        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                    }
                }
            }
        }
        super.m_6402_(level, pos, state, player, stack);
    }

    public void m_6810_(BlockState pState, Level level, BlockPos pos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof AltarConduitBlockEntity) {
            AltarConduitBlockEntity altarConduit = (AltarConduitBlockEntity)blockEntity;
            altarConduit.getNode().disconnect();
            BlockPos controllerPos = null;
            if (altarConduit.getAEController().isPresent()) {
                controllerPos = altarConduit.getAEController().get().m_58899_();
            }
            if (altarConduit.getRSController().isPresent()) {
                controllerPos = altarConduit.getRSController().get().m_58899_();
            }
            if (controllerPos != null) {
                altarConduit.returnItems(altarConduit.getFloatingItemsMap().values().stream().flatMap(Collection::stream).toList(), controllerPos);
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                AltarConduitData data = AltarConduitData.get(serverLevel.m_142572_());
                data.removeConduitLocation(pos);
                data.removeConduitLocation(altarConduit.getPlacedPos());
            }
            this.dropContents(level, pos, altarConduit);
        }
        super.m_6810_(pState, level, pos, pNewState, pIsMoving);
    }

    private void dropContents(Level level, BlockPos pos, AltarConduitBlockEntity altarConduit) {
        altarConduit.getUpgrades().getStacks().forEach(stack -> AltarConduitBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack));
        altarConduit.getUpgrades().m_6211_();
        ItemStack conduitStack = new ItemStack((ItemLike)VIBlocks.ALTAR_CONDUIT_BLOCK.get());
        altarConduit.m_187476_(conduitStack);
        AltarConduitBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)conduitStack);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (hand == InteractionHand.MAIN_HAND) {
            ItemStack returned;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (!(blockEntity instanceof AltarConduitBlockEntity)) {
                return InteractionResult.PASS;
            }
            AltarConduitBlockEntity altarConduit = (AltarConduitBlockEntity)blockEntity;
            ItemStack stack = player.m_21205_();
            AtomicReference<InteractionResult> result = new AtomicReference<InteractionResult>(InteractionResult.PASS);
            Optional<VaultAltarTileEntity> altarOptional = altarConduit.getAltar();
            if (altarOptional.isPresent() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                VaultAltarTileEntity altar = altarOptional.get();
                if (ModConfigs.VAULT_ALTAR.getOutput(stack, player.m_142081_()).isPresent()) {
                    if (altar.getAltarState() == VaultAltarTileEntity.AltarState.IDLE && altar.onAddInput(serverPlayer, stack) == InteractionResult.SUCCESS) {
                        PlayerVaultAltarData.get((ServerLevel)serverPlayer.m_183503_()).m_77762_();
                        return InteractionResult.SUCCESS;
                    }
                } else if (player.m_6144_() && (altar.getAltarState() == VaultAltarTileEntity.AltarState.ACCEPTING || altar.getAltarState() == VaultAltarTileEntity.AltarState.COMPLETE) && altar.onRemoveInput(serverPlayer.m_142081_()) == InteractionResult.SUCCESS) {
                    PlayerVaultAltarData.get((ServerLevel)serverPlayer.m_183503_()).m_77762_();
                    return InteractionResult.SUCCESS;
                }
            }
            if (stack.m_41720_() instanceof WrenchItem || stack.m_41720_() instanceof QuartzWrenchItem) {
                altarConduit.setDebugMode(!altarConduit.inDebugMode());
                return InteractionResult.SUCCESS;
            }
            UpgradeItemContainer upgrades = altarConduit.getUpgrades();
            if (upgrades.isItemValid(stack) && ((returned = upgrades.addItem(stack)).m_41619_() || returned.m_41613_() < stack.m_41613_())) {
                player.m_21008_(InteractionHand.MAIN_HAND, returned);
                result.set(InteractionResult.SUCCESS);
            }
            if (result.get() == InteractionResult.SUCCESS) {
                return result.get();
            }
            if (!(player instanceof ServerPlayer)) {
                return InteractionResult.SUCCESS;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)altarConduit, buffer -> buffer.m_130064_(pos));
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }
}

