/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vaultintegrations.block.entity;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.util.AECableType;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.network.node.INetworkNodeManager;
import com.refinedmods.refinedstorage.api.network.node.INetworkNodeProxy;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.blockentity.ControllerBlockEntity;
import iskallia.vault.altar.AltarInfusionRecipe;
import iskallia.vault.altar.RequiredItems;
import iskallia.vault.block.entity.VaultAltarTileEntity;
import iskallia.vault.util.nbt.NBTHelper;
import iskallia.vault.world.data.PlayerVaultAltarData;
import iskallia.vaultintegrations.altar.AltarConduitNode;
import iskallia.vaultintegrations.altar.FloatingItem;
import iskallia.vaultintegrations.block.entity.base.BaseBlockEntity;
import iskallia.vaultintegrations.container.AltarConduitContainer;
import iskallia.vaultintegrations.init.VIBlocks;
import iskallia.vaultintegrations.inventory.BlacklistItemContainer;
import iskallia.vaultintegrations.inventory.UpgradeItemContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AltarConduitBlockEntity
extends BaseBlockEntity
implements IInWorldGridNodeHost,
INetworkNodeProxy<AltarConduitNode>,
MenuProvider {
    private UUID owner;
    @Nullable
    private VaultAltarTileEntity connectedAltar;
    private BlockPos controllerPos;
    private BlockPos placedPos;
    private AltarConduitNode node;
    private HashMap<ResourceLocation, List<FloatingItem>> floatingItems = new HashMap();
    private List<FloatingItem> heldItems = new ArrayList<FloatingItem>();
    private boolean debugMode;
    private UpgradeItemContainer upgrades = new UpgradeItemContainer(this);
    private BlacklistItemContainer blacklist = new BlacklistItemContainer(this);
    private long ticksExisted = 0L;

    public AltarConduitBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)VIBlocks.ALTAR_CONDUIT_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
    }

    public Optional<VaultAltarTileEntity> getAltar() {
        if (this.f_58857_ != null) {
            VaultAltarTileEntity altar;
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_7495_());
            this.connectedAltar = blockEntity instanceof VaultAltarTileEntity ? (altar = (VaultAltarTileEntity)blockEntity) : null;
        }
        return Optional.ofNullable(this.connectedAltar);
    }

    public void setAltar(VaultAltarTileEntity altar) {
        this.connectedAltar = altar;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public Optional<ControllerBlockEntity> getRSController() {
        BlockEntity blockEntity;
        if (this.f_58857_ != null && this.controllerPos != null && this.f_58857_.m_46749_(this.controllerPos) && (blockEntity = this.f_58857_.m_7702_(this.controllerPos)) instanceof ControllerBlockEntity) {
            ControllerBlockEntity controller = (ControllerBlockEntity)blockEntity;
            return Optional.of(controller);
        }
        return Optional.empty();
    }

    public Optional<appeng.blockentity.networking.ControllerBlockEntity> getAEController() {
        BlockEntity blockEntity;
        if (this.f_58857_ != null && this.controllerPos != null && this.f_58857_.m_46749_(this.controllerPos) && (blockEntity = this.f_58857_.m_7702_(this.controllerPos)) instanceof appeng.blockentity.networking.ControllerBlockEntity) {
            appeng.blockentity.networking.ControllerBlockEntity controller = (appeng.blockentity.networking.ControllerBlockEntity)blockEntity;
            return Optional.of(controller);
        }
        return Optional.empty();
    }

    public void setControllerPos(BlockPos controllerPos) {
        this.controllerPos = controllerPos;
    }

    public BlockPos getPlacedPos() {
        return this.placedPos;
    }

    public void setPlacedPos(BlockPos placedPos) {
        this.placedPos = placedPos;
    }

    public HashMap<ResourceLocation, List<FloatingItem>> getFloatingItemsMap() {
        return this.floatingItems;
    }

    @NotNull
    private List<FloatingItem> getAllFloatingItems() {
        ArrayList<FloatingItem> allFloatingItems = new ArrayList<FloatingItem>();
        for (List<FloatingItem> items : this.floatingItems.values()) {
            allFloatingItems.addAll(items);
        }
        return allFloatingItems;
    }

    public int getFloatingItemCount(RequiredItems requiredItem) {
        int amountSent = 0;
        for (ResourceLocation itemId : this.getFloatingItemsMap().keySet()) {
            if (!requiredItem.containsItem(itemId)) continue;
            List<FloatingItem> items = this.getFloatingItemsMap().get(itemId);
            for (FloatingItem item : items) {
                amountSent += item.getAmount();
            }
        }
        return amountSent;
    }

    public void addFloatingItem(FloatingItem item) {
        if (this.floatingItems == null) {
            this.floatingItems = new HashMap();
        }
        if (this.floatingItems.containsKey(item.getItemId())) {
            if (this.floatingItems.get(item.getItemId()).contains(item)) {
                return;
            }
            this.floatingItems.get(item.getItemId()).add(item);
        } else {
            ArrayList<FloatingItem> floatingItems = new ArrayList<FloatingItem>();
            floatingItems.add(item);
            this.floatingItems.put(item.getItemId(), floatingItems);
        }
    }

    public boolean inDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public UpgradeItemContainer getUpgrades() {
        return this.upgrades;
    }

    public BlacklistItemContainer getBlacklist() {
        return this.blacklist;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AltarConduitBlockEntity altarConduit) {
        if (!level.m_46749_(pos)) {
            if (altarConduit.node != null) {
                altarConduit.node.disconnect();
                altarConduit.node = null;
                altarConduit.m_6596_();
            }
            return;
        }
        if (!pos.equals((Object)altarConduit.getPlacedPos())) {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            if (level.m_7702_(altarConduit.getPlacedPos()) instanceof AltarConduitBlockEntity) {
                level.m_7731_(altarConduit.getPlacedPos(), Blocks.f_50016_.m_49966_(), 3);
            }
        }
        ++altarConduit.ticksExisted;
        if (altarConduit.owner == null && altarConduit.ticksExisted > 5L) {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        }
        altarConduit.getNode();
        BlockPos controllerPos = BlockPos.f_121853_;
        if (altarConduit.controllerPos != null) {
            controllerPos = altarConduit.controllerPos;
        }
        if (controllerPos != BlockPos.f_121853_ && !altarConduit.heldItems.isEmpty()) {
            altarConduit.returnItems(altarConduit.heldItems, controllerPos);
        }
        if (altarConduit.getAltar().isEmpty()) {
            altarConduit.returnItems(altarConduit.getAllFloatingItems(), controllerPos);
            altarConduit.m_6596_();
            return;
        }
        Vec3 conduitVec = Vec3.m_82512_((Vec3i)altarConduit.m_58899_());
        ArrayList<FloatingItem> removeQueue = new ArrayList<FloatingItem>();
        List<FloatingItem> allFloatingItems = altarConduit.getAllFloatingItems();
        if (allFloatingItems.isEmpty()) {
            altarConduit.m_6596_();
            return;
        }
        for (FloatingItem item : allFloatingItems) {
            Vec3 current = item.getItemPos();
            Vec3 itemPos = new Vec3(current.f_82479_, current.f_82480_, current.f_82481_);
            item.setPrevPos(new Vec3(current.f_82479_, current.f_82480_, current.f_82481_));
            Vec3 direction = conduitVec.m_82546_(current).m_82541_();
            UpgradeItemContainer upgrades = altarConduit.getUpgrades();
            int speedUpgradeCount = upgrades.getSpeedUpgradeCount();
            double blocksPerTick = speedUpgradeCount == 0 ? 0.05 : 0.05 * ((double)speedUpgradeCount * 2.5);
            item.setItemPos(itemPos.m_82549_(direction.m_82542_(blocksPerTick, blocksPerTick, blocksPerTick)));
            if (!altarConduit.hasItemReachedConduit(itemPos, conduitVec)) continue;
            if (altarConduit.insertItem(item)) {
                removeQueue.add(item);
                continue;
            }
            removeQueue.add(item);
            altarConduit.returnItems(List.of(item), controllerPos);
        }
        if (!removeQueue.isEmpty()) {
            for (FloatingItem floatingItem : removeQueue) {
                altarConduit.floatingItems.get(floatingItem.getItemId()).remove(floatingItem);
            }
        }
        altarConduit.sendUpdates();
    }

    private boolean hasItemReachedConduit(Vec3 itemPos, Vec3 conduitVec) {
        return itemPos.m_82557_(conduitVec) <= 0.1 || itemPos == Vec3.f_82478_;
    }

    public boolean insertItem(FloatingItem floatingItem) {
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            return true;
        }
        Optional<VaultAltarTileEntity> altarOptional = this.getAltar();
        if (altarOptional.isEmpty()) {
            return false;
        }
        VaultAltarTileEntity altar = altarOptional.get();
        if (altar.getRecipe() == null) {
            return false;
        }
        AltarInfusionRecipe recipe = altar.getRecipe();
        Item item = (Item)ForgeRegistries.ITEMS.getValue(floatingItem.getItemId());
        if (item == null) {
            return false;
        }
        List requiredItems = recipe.getIncompleteRequiredItems();
        for (RequiredItems requiredItem : requiredItems) {
            HashSet<Item> items = new HashSet<Item>();
            for (ItemStack itemStack : requiredItem.getItems()) {
                if (itemStack.m_41720_() != item) continue;
                items.add(itemStack.m_41720_());
            }
            if (!items.contains(item)) continue;
            requiredItem.addAmount(floatingItem.getAmount());
            altar.sendUpdates();
            PlayerVaultAltarData.get().m_77762_();
            return true;
        }
        return false;
    }

    public void returnItems(List<FloatingItem> items, BlockPos controllerPos) {
        if (this.f_58857_ == null) {
            return;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(controllerPos);
        ArrayList<FloatingItem> removeQueue = new ArrayList<FloatingItem>();
        for (FloatingItem floatingItem : items) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(floatingItem.getItemId());
            if (item == null) continue;
            ItemStack stack = new ItemStack((ItemLike)item, floatingItem.getAmount());
            if (blockEntity instanceof ControllerBlockEntity) {
                ControllerBlockEntity rsController = (ControllerBlockEntity)blockEntity;
                rsController.getNetwork().insertItem(stack, floatingItem.getAmount(), Action.PERFORM);
            } else if (blockEntity instanceof appeng.blockentity.networking.ControllerBlockEntity) {
                appeng.blockentity.networking.ControllerBlockEntity aeController = (appeng.blockentity.networking.ControllerBlockEntity)blockEntity;
                IGridNode aeControllerGridNode = aeController.getGridNode();
                if (aeControllerGridNode == null) continue;
                IGrid aeGrid = aeControllerGridNode.getGrid();
                aeGrid.getStorageService().getInventory().insert((AEKey)AEItemKey.of((ItemStack)stack), (long)floatingItem.getAmount(), Actionable.MODULATE, IActionSource.empty());
            } else if (controllerPos.equals((Object)BlockPos.f_121853_)) {
                this.heldItems.add(floatingItem);
            }
            removeQueue.add(floatingItem);
        }
        for (FloatingItem floatingItem : removeQueue) {
            if (this.floatingItems.containsKey(floatingItem.getItemId())) {
                this.floatingItems.get(floatingItem.getItemId()).remove(floatingItem);
            }
            this.heldItems.remove(floatingItem);
        }
        this.m_6596_();
    }

    public AABB getRenderBoundingBox() {
        return AABB.m_82321_((BoundingBox)new BoundingBox(this.m_58899_()).m_191961_(64));
    }

    @NotNull
    public AltarConduitNode getNode() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            if (this.node == null) {
                this.node = this.createNode(this.f_58857_, this.f_58858_);
            }
            return this.node;
        }
        INetworkNodeManager manager = API.instance().getNetworkNodeManager((ServerLevel)this.f_58857_);
        INetworkNode node = manager.getNode(this.f_58858_);
        if (node == null) {
            manager.setNode(this.f_58858_, (INetworkNode)this.createNode(this.f_58857_, this.f_58858_));
            node = manager.getNode(this.f_58858_);
            if (node == null) {
                throw new IllegalStateException("No network node present at " + this.f_58858_.toString() + ", consider removing the block at this position");
            }
        }
        return (AltarConduitNode)node;
    }

    private AltarConduitNode createNode(Level level, BlockPos worldPosition) {
        return new AltarConduitNode(this, level, worldPosition);
    }

    @Nullable
    public IGridNode getGridNode(Direction direction) {
        if (this.getNode().getAeNode() == null) {
            return null;
        }
        return this.getNode().getAeNode().getNode();
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.GLASS;
    }

    @NotNull
    public Component m_5446_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, @NotNull Inventory inv, @NotNull Player player) {
        if (this.m_58904_() == null) {
            return null;
        }
        return new AltarConduitContainer(containerId, this.m_58904_(), this.m_58899_(), inv);
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        if (this.controllerPos != null) {
            tag.m_128365_("controllerPos", (Tag)NbtUtils.m_129224_((BlockPos)this.controllerPos));
        }
        if (this.placedPos != null) {
            tag.m_128365_("placedPos", (Tag)NbtUtils.m_129224_((BlockPos)this.placedPos));
        }
        NBTHelper.writeCollection((CompoundTag)tag, (String)"floatingItems", this.getAllFloatingItems(), CompoundTag.class, FloatingItem::serializeNBT);
        NBTHelper.writeCollection((CompoundTag)tag, (String)"heldItems", this.heldItems, CompoundTag.class, FloatingItem::serializeNBT);
        tag.m_128379_("debugMode", this.debugMode);
        tag.m_128365_("upgrades", (Tag)this.upgrades.serializeNBT());
        tag.m_128365_("blacklist", (Tag)this.blacklist.serializeNBT());
        if (this.owner != null) {
            tag.m_128362_("owner", this.owner);
        }
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("controllerPos")) {
            this.controllerPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("controllerPos"));
        } else if (tag.m_128441_("rsControllerPos")) {
            this.controllerPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("rsControllerPos"));
        } else if (tag.m_128441_("aeControllerPos")) {
            this.controllerPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("aeControllerPos"));
        }
        this.placedPos = tag.m_128441_("placedPos") ? NbtUtils.m_129239_((CompoundTag)tag.m_128469_("placedPos")) : this.f_58858_.m_122032_();
        if (this.heldItems != null) {
            this.heldItems.clear();
        }
        this.heldItems = NBTHelper.readList((CompoundTag)tag, (String)"heldItems", CompoundTag.class, FloatingItem::new);
        if (this.floatingItems != null) {
            this.floatingItems.clear();
        }
        List items = NBTHelper.readList((CompoundTag)tag, (String)"floatingItems", CompoundTag.class, FloatingItem::new);
        for (FloatingItem item : items) {
            this.addFloatingItem(item);
        }
        this.upgrades = new UpgradeItemContainer(this);
        this.upgrades.deserializeNBT(tag.m_128469_("upgrades"));
        this.blacklist = new BlacklistItemContainer(this);
        this.blacklist.deserializeNBT(tag.m_128469_("blacklist"));
        this.debugMode = tag.m_128471_("debugMode");
        this.owner = tag.m_128441_("owner") ? tag.m_128342_("owner") : null;
    }
}

