/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vaultintegrations.block.item;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.blockentity.ControllerBlockEntity;
import iskallia.vaultintegrations.init.VIBlocks;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class AltarConduitBlockItem
extends BlockItem {
    public AltarConduitBlockItem() {
        super((Block)VIBlocks.ALTAR_CONDUIT_BLOCK.get(), new Item.Properties().m_41487_(1).m_41491_(VIBlocks.CREATIVE_TAB));
    }

    @NotNull
    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (context.m_43724_() != InteractionHand.MAIN_HAND || context.m_43725_().m_5776_()) {
            return InteractionResult.PASS;
        }
        boolean foundController = false;
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        ItemStack altarConduit = context.m_43722_();
        CompoundTag conduitTag = altarConduit.m_41784_();
        BlockPos pos = context.m_8083_();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ControllerBlockEntity) {
            ControllerBlockEntity controller = (ControllerBlockEntity)blockEntity;
            boolean hasPermission = controller.getNetwork().getSecurityManager().hasPermission(Permission.EXTRACT, player);
            if (!hasPermission) {
                player.m_6352_((Component)new TextComponent("You do not have access to this controller.").m_130940_(ChatFormatting.RED), Util.f_137441_);
                return InteractionResult.FAIL;
            }
            foundController = true;
            conduitTag.m_128365_("controllerPos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
        } else {
            BlockEntity hasPermission = level.m_7702_(pos);
            if (hasPermission instanceof appeng.blockentity.networking.ControllerBlockEntity) {
                boolean hasPermission2;
                appeng.blockentity.networking.ControllerBlockEntity controller = (appeng.blockentity.networking.ControllerBlockEntity)hasPermission;
                IGrid grid = controller.getMainNode().getGrid();
                boolean bl = hasPermission2 = grid == null || grid.getSecurityService().hasPermission(player, SecurityPermissions.EXTRACT);
                if (!hasPermission2) {
                    player.m_6352_((Component)new TextComponent("You do not have access to this controller.").m_130940_(ChatFormatting.RED), Util.f_137441_);
                    return InteractionResult.FAIL;
                }
                foundController = true;
                conduitTag.m_128365_("controllerPos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
            }
        }
        if (foundController) {
            String message = String.format("The Altar Conduit has been bound to the Controller at: x%s, y%s, z%s", pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            player.m_6352_((Component)new TextComponent(message).m_130940_(ChatFormatting.GREEN), Util.f_137441_);
            level.m_5594_(null, pos, SoundEvents.f_11739_, SoundSource.PLAYERS, 0.7f, 2.0f);
            altarConduit.m_41751_(conduitTag);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

