/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vaultintegrations.inventory;

import iskallia.vaultintegrations.block.entity.AltarConduitBlockEntity;
import iskallia.vaultintegrations.init.VIItems;
import iskallia.vaultintegrations.inventory.BaseItemContainer;
import iskallia.vaultintegrations.item.EnhancementItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class UpgradeItemContainer
extends BaseItemContainer<AltarConduitBlockEntity> {
    public UpgradeItemContainer(AltarConduitBlockEntity altarConduit) {
        super(altarConduit, 4);
    }

    @Override
    public boolean isItemValid(ItemStack stack) {
        if (!(stack.m_41720_() instanceof EnhancementItem)) {
            return false;
        }
        for (int slot = 0; slot < this.m_6643_(); ++slot) {
            ItemStack stackInSlot = this.m_8020_(slot);
            if (stack.m_41720_() != VIItems.TELEPORT_ENHANCEMENT.get() || stackInSlot.m_41720_() != VIItems.TELEPORT_ENHANCEMENT.get()) continue;
            return false;
        }
        return true;
    }

    public int getSpeedUpgradeCount() {
        int count = 0;
        for (int slot = 0; slot < this.m_6643_(); ++slot) {
            ItemStack stack = this.m_8020_(slot);
            if (!this.isSpeedUpgrade(stack)) continue;
            ++count;
        }
        return count;
    }

    public int getQuantityUpgradeCount() {
        int count = 0;
        int slots = this.m_6643_();
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack stack = this.m_8020_(slot);
            if (!this.isQuantityUpgrade(stack)) continue;
            ++count;
        }
        return count;
    }

    public int getTeleportUpgradeCount() {
        int count = 0;
        int slots = this.m_6643_();
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack stack = this.m_8020_(slot);
            if (!this.isTeleportUpgrade(stack)) continue;
            ++count;
        }
        return count;
    }

    private boolean isSpeedUpgrade(@NotNull ItemStack stack) {
        EnhancementItem item;
        if (stack.m_41619_()) {
            return false;
        }
        Item item2 = stack.m_41720_();
        return item2 instanceof EnhancementItem && (item = (EnhancementItem)item2).getUpgradeType() == EnhancementItem.UpgradeType.SPEED;
    }

    private boolean isQuantityUpgrade(@NotNull ItemStack stack) {
        EnhancementItem item;
        if (stack.m_41619_()) {
            return false;
        }
        Item item2 = stack.m_41720_();
        return item2 instanceof EnhancementItem && (item = (EnhancementItem)item2).getUpgradeType() == EnhancementItem.UpgradeType.QUANTITY;
    }

    private boolean isTeleportUpgrade(@NotNull ItemStack stack) {
        EnhancementItem item;
        if (stack.m_41619_()) {
            return false;
        }
        Item item2 = stack.m_41720_();
        return item2 instanceof EnhancementItem && (item = (EnhancementItem)item2).getUpgradeType() == EnhancementItem.UpgradeType.TELEPORT;
    }

    public int m_6893_() {
        return 1;
    }
}

