/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import xaero.map.MapProcessor;
import xaero.map.file.export.PNGExportResult;
import xaero.map.gui.ConfigSettingEntry;
import xaero.map.gui.GuiSettings;
import xaero.map.gui.ISettingEntry;
import xaero.map.gui.MapTileSelection;
import xaero.map.gui.MySmallButton;
import xaero.map.settings.ModOptions;

public class ExportScreen
extends GuiSettings {
    private static final Component EXPORTING_MESSAGE = new TranslatableComponent("gui.xaero_export_screen_exporting");
    private final MapProcessor mapProcessor;
    private PNGExportResult result;
    private int stage;
    private final MapTileSelection selection;
    public boolean fullExport;

    public ExportScreen(Screen backScreen, Screen escScreen, MapProcessor mapProcessor, MapTileSelection selection) {
        super((Component)new TranslatableComponent("gui.xaero_export_screen"), backScreen, escScreen);
        this.mapProcessor = mapProcessor;
        this.selection = selection;
        this.entries = new ISettingEntry[]{new ConfigSettingEntry(ModOptions.FULL_EXPORT), new ConfigSettingEntry(ModOptions.MULTIPLE_IMAGES_EXPORT), new ConfigSettingEntry(ModOptions.NIGHT_EXPORT), new ConfigSettingEntry(ModOptions.EXPORT_HIGHLIGHTS), new ConfigSettingEntry(ModOptions.EXPORT_SCALE_DOWN_SQUARE)};
        this.canSearch = false;
        this.shouldAddBackButton = false;
    }

    @Override
    public void m_7856_() {
        if (this.stage > 0) {
            return;
        }
        super.m_7856_();
        this.m_142416_((GuiEventListener)new MySmallButton(this.f_96543_ / 2 - 155, this.f_96544_ / 6 + 168, (Component)new TranslatableComponent("gui.xaero_confirm", new Object[0]), b -> {
            this.stage = 1;
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        }));
        this.m_142416_((GuiEventListener)new MySmallButton(this.f_96543_ / 2 + 5, this.f_96544_ / 6 + 168, (Component)new TranslatableComponent("gui.xaero_cancel", new Object[0]), b -> this.goBack()));
    }

    @Override
    public void m_6305_(PoseStack matrixStack, int par1, int par2, float par3) {
        this.renderEscapeScreen(matrixStack, par1, par2, par3);
        super.m_6305_(matrixStack, par1, par2, par3);
        if (this.result != null) {
            ExportScreen.m_93215_((PoseStack)matrixStack, (Font)this.f_96541_.f_91062_, (Component)this.result.getMessage(), (int)(this.f_96543_ / 2), (int)20, (int)-1);
        }
        if (this.stage > 0) {
            ExportScreen.m_93215_((PoseStack)matrixStack, (Font)this.f_96541_.f_91062_, (Component)EXPORTING_MESSAGE, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 6 + 68), (int)-1);
            if (this.stage == 1) {
                this.stage = 2;
                return;
            }
        }
        if (this.stage != 2) {
            return;
        }
        if (this.mapProcessor.getMapSaveLoad().exportPNG(this, this.fullExport ? null : this.selection)) {
            this.stage = 3;
            this.result = null;
            for (GuiEventListener c : this.m_6702_()) {
                if (!(c instanceof Button)) continue;
                ((Button)c).f_93623_ = false;
            }
            return;
        }
        this.stage = 0;
        this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
    }

    public void onExportDone(PNGExportResult result) {
        this.result = result;
        this.stage = 0;
    }

    public MapTileSelection getSelection() {
        return this.selection;
    }
}

