/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.teleport;

import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import xaero.map.WorldMap;
import xaero.map.world.MapConnectionNode;
import xaero.map.world.MapDimension;
import xaero.map.world.MapWorld;

public class MapTeleporter {
    public void teleport(Screen screen, MapWorld mapWorld, int x, int y, int z, ResourceKey<Level> d) {
        String tpCommand;
        Minecraft.m_91087_().m_91152_(null);
        if (Minecraft.m_91087_().f_91072_.m_105205_()) {
            MapConnectionNode destinationMapKey;
            MapDimension destinationDim = mapWorld.getDimension(d != null ? d : Minecraft.m_91087_().f_91073_.m_46472_());
            MapConnectionNode playerMapKey = mapWorld.getPlayerMapKey();
            if (playerMapKey == null) {
                TextComponent messageComponent = new TextComponent(I18n.m_118938_((String)"gui.xaero_wm_teleport_never_confirmed", (Object[])new Object[0]));
                messageComponent.m_6270_(messageComponent.m_7383_().m_131140_(ChatFormatting.RED));
                Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)messageComponent);
                return;
            }
            MapConnectionNode mapConnectionNode = destinationMapKey = destinationDim == null ? null : destinationDim.getSelectedMapKeyUnsynced();
            if (!mapWorld.getMapConnections().isConnected(playerMapKey, destinationMapKey)) {
                TextComponent messageComponent = new TextComponent(I18n.m_118938_((String)"gui.xaero_wm_teleport_not_connected", (Object[])new Object[0]));
                messageComponent.m_6270_(messageComponent.m_7383_().m_131140_(ChatFormatting.RED));
                Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)messageComponent);
                return;
            }
        }
        String string = tpCommand = d == null ? mapWorld.getTeleportCommandFormat() : mapWorld.getDimensionTeleportCommandFormat();
        String yString = y == Short.MAX_VALUE ? "~" : (WorldMap.settings.partialYTeleportation ? "" + ((double)y + 0.5) : "" + y);
        tpCommand = tpCommand.replace("{x}", "" + x).replace("{y}", yString).replace("{z}", "" + z);
        if (d != null) {
            tpCommand = tpCommand.replace("{d}", d.m_135782_().toString());
        }
        screen.m_96615_(tpCommand);
        mapWorld.setCustomDimensionId(null);
        mapWorld.getMapProcessor().checkForWorldUpdate();
    }
}

