/*
 * Decompiled with CFR 0.152.
 */
package com.tom.morewires.compat.ae;

import appeng.api.networking.GridFlags;
import appeng.api.util.AECableType;
import appeng.blockentity.grid.AENetworkBlockEntity;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.ConnectorBlockEntityHelper;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireType;
import com.google.common.collect.ImmutableList;
import com.tom.morewires.MoreImmersiveWires;
import com.tom.morewires.tile.IOnCableConnector;
import java.util.Collection;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class AEConnectorBlockEntity
extends AENetworkBlockEntity
implements IOnCableConnector {
    protected GlobalWireNetwork globalNet;
    private boolean isUnloaded = false;

    public AEConnectorBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setIdlePowerUsage(0.0);
        this.getMainNode().setFlags(new GridFlags[0]);
        this.getMainNode().setExposedOnSides(EnumSet.noneOf(Direction.class));
    }

    public void setOrientation(Direction inForward, Direction inUp) {
        super.setOrientation(inForward, inUp);
        this.getMainNode().setExposedOnSides(EnumSet.of(this.getFacing()));
    }

    public void onReady() {
        this.getMainNode().setExposedOnSides(EnumSet.of(this.getFacing()));
        super.onReady();
    }

    public AECableType getCableConnectionType(Direction dir) {
        if (this.getFacing() == dir) {
            return AECableType.GLASS;
        }
        return AECableType.NONE;
    }

    public void m_142339_(Level worldIn) {
        super.m_142339_(worldIn);
        this.globalNet = GlobalWireNetwork.getNetwork((Level)worldIn);
    }

    public boolean canConnect() {
        return true;
    }

    public void connectCable(WireType cableType, ConnectionPoint target, IImmersiveConnectable other, ConnectionPoint otherTarget) {
    }

    public void removeCable(Connection connection, ConnectionPoint attachedPoint) {
        this.m_6596_();
    }

    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        LocalWireNetwork local = this.globalNet.getNullableLocalNet(new ConnectionPoint(this.f_58858_, 0));
        if (local != null && !local.getConnections(this.f_58858_).isEmpty()) {
            return false;
        }
        return cableType == MoreImmersiveWires.AE_WIRE.simple().wireType;
    }

    public BlockPos getPosition() {
        return this.f_58858_;
    }

    public BlockState getState() {
        return this.m_58900_();
    }

    @Override
    public Level getLevelNonnull() {
        return this.f_58857_;
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        ConnectorBlockEntityHelper.onChunkUnload((GlobalWireNetwork)this.globalNet, (IImmersiveConnectable)this);
        this.isUnloaded = true;
    }

    public void onLoad() {
        super.onLoad();
        ConnectorBlockEntityHelper.onChunkLoad((IImmersiveConnectable)this, (Level)this.f_58857_);
        this.isUnloaded = false;
    }

    public void setRemovedIE() {
        ConnectorBlockEntityHelper.remove((Level)this.f_58857_, (IImmersiveConnectable)this);
    }

    public void m_7651_() {
        super.m_7651_();
        if (!this.isUnloaded) {
            this.setRemovedIE();
        }
    }

    public Collection<ResourceLocation> getRequestedHandlers() {
        return ImmutableList.of((Object)MoreImmersiveWires.AE_WIRE.simple().NET_ID);
    }

    static {
        AEConnectorBlockEntity.registerBlockEntityItem((BlockEntityType)((BlockEntityType)MoreImmersiveWires.AE_WIRE.simple().CONNECTOR_ENTITY.get()), (Item)((Block)MoreImmersiveWires.AE_WIRE.simple().CONNECTOR.get()).m_5456_());
    }
}

