/*
 * Decompiled with CFR 0.152.
 */
package com.tom.morewires.compat.ftbic;

import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.common.blocks.generic.ImmersiveConnectableBlockEntity;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import com.google.common.collect.ImmutableList;
import com.tom.morewires.compat.ftbic.FTBICWireDefinition;
import com.tom.morewires.tile.IOnCableConnector;
import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.BurntCableBlock;
import dev.ftb.mods.ftbic.block.CableBlock;
import dev.ftb.mods.ftbic.block.entity.ElectricBlockEntity;
import dev.ftb.mods.ftbic.util.CachedEnergyStorage;
import dev.ftb.mods.ftbic.util.CachedEnergyStorageOrigin;
import dev.ftb.mods.ftbic.util.EnergyHandler;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import dev.ftb.mods.ftbic.util.ForgeEnergyHandler;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class FTBICConnectorBlockEntity
extends ImmersiveConnectableBlockEntity
implements IOnCableConnector,
EnergyHandler,
EnergyTransferHandler.EnergyConnector,
IEServerTickableBE {
    private final FTBICWireDefinition def;
    private final MutableEnergyStorage storageToNet;
    private final MutableEnergyStorage storageToMachine;
    public int currentTickToNet = 0;
    private long currentElectricNetwork = -1L;
    private CachedEnergyStorage[] connectedEnergyBlocks;

    public FTBICConnectorBlockEntity(FTBICWireDefinition w, BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)w.CONNECTOR_ENTITY.get(), p_155229_, p_155230_);
        this.def = w;
        this.storageToMachine = new MutableEnergyStorage(w.energyCapacity * 10, w.energyCapacity * 10, w.energyCapacity * 10);
        this.storageToNet = new MutableEnergyStorage(w.energyCapacity * 10, w.energyCapacity * 10, w.energyCapacity * 10);
    }

    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        return cableType == this.def.wireType;
    }

    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        CompoundTag toNet = new CompoundTag();
        EnergyHelper.serializeTo((EnergyStorage)this.storageToNet, (CompoundTag)toNet);
        nbt.m_128365_("toNet", (Tag)toNet);
        CompoundTag toMachine = new CompoundTag();
        EnergyHelper.serializeTo((EnergyStorage)this.storageToMachine, (CompoundTag)toMachine);
        nbt.m_128365_("toMachine", (Tag)toMachine);
    }

    public void readCustomNBT(@Nonnull CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        CompoundTag toMachine = nbt.m_128469_("toMachine");
        EnergyHelper.deserializeFrom((EnergyStorage)this.storageToMachine, (CompoundTag)toMachine);
        CompoundTag toNet = nbt.m_128469_("toNet");
        EnergyHelper.deserializeFrom((EnergyStorage)this.storageToNet, (CompoundTag)toNet);
    }

    public void tickServer() {
        this.handleEnergyOutput();
        this.currentTickToNet = 0;
    }

    public final double getEnergyCapacity() {
        return (double)this.def.energyCapacity / 10.0;
    }

    public final double getEnergy() {
        return (double)this.storageToNet.getEnergyStored() / 10.0;
    }

    public final void setEnergyRaw(double e) {
        this.storageToNet.setStoredEnergy(Mth.m_14107_((double)(e * 10.0)));
    }

    public double insertEnergy(double maxInsert, boolean simulate) {
        if (maxInsert > (double)this.def.energyCapacity / 10.0) {
            if (!simulate) {
                this.setBurnt(true);
            }
            return maxInsert;
        }
        int maxReceive = Mth.m_14107_((double)Math.min((double)(this.def.energyCapacity - this.currentTickToNet), maxInsert * 10.0));
        if (maxReceive <= 0) {
            return 0.0;
        }
        int accepted = Math.min(this.def.energyCapacity, maxReceive);
        accepted = Math.min(this.def.energyCapacity - this.storageToNet.getEnergyStored(), accepted);
        if (accepted <= 0) {
            return 0.0;
        }
        if (!simulate) {
            this.storageToNet.modifyEnergyStored(accepted);
            this.currentTickToNet += accepted;
            this.m_6596_();
        }
        return (double)accepted / 10.0;
    }

    public boolean isEnergyHandlerInvalid() {
        return this.isBurnt() || this.m_58901_();
    }

    public final double getMaxInputEnergy() {
        return (double)this.def.energyCapacity / 10.0;
    }

    public double getTotalPossibleEnergyCapacity() {
        return (double)this.def.energyCapacity / 10.0;
    }

    public final boolean canBurn() {
        return true;
    }

    public final void setBurnt(boolean b) {
        if (b && !this.f_58857_.m_5776_()) {
            this.globalNet.getLocalNet(this.f_58858_).getConnections(this.f_58858_).forEach(c -> {
                if (c instanceof EnergyTransferHandler.IEnergyWire) {
                    EnergyTransferHandler.IEnergyWire w = (EnergyTransferHandler.IEnergyWire)c;
                    w.burn(c, 1.0, this.globalNet, this.f_58857_);
                }
            });
            this.f_58857_.m_7731_(this.f_58858_, Blocks.f_50016_.m_49966_(), 3);
            ElectricBlockEntity.electricNetworkUpdated((LevelAccessor)this.f_58857_, (BlockPos)this.f_58858_);
            this.f_58857_.m_46796_(1502, this.f_58858_, 0);
        }
    }

    public final boolean isBurnt() {
        return false;
    }

    public void syncBlock() {
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 11);
        this.m_6596_();
    }

    public void handleEnergyOutput() {
        double tenergy;
        if (!this.f_58857_.m_5776_() && (tenergy = (double)this.storageToMachine.getEnergyStored() / 10.0) > 0.0) {
            CachedEnergyStorage[] blocks = this.getConnectedEnergyBlocks();
            int validBlocks = 0;
            CachedEnergyStorage[] var16 = blocks;
            int var6 = blocks.length;
            for (int var7 = 0; var7 < var6; ++var7) {
                CachedEnergyStorage storage = var16[var7];
                if (storage.isInvalid()) {
                    ElectricBlockEntity.electricNetworkUpdated((LevelAccessor)this.f_58857_, (BlockPos)storage.blockEntity.m_58899_());
                    continue;
                }
                if (!storage.shouldReceiveEnergy()) continue;
                ++validBlocks;
            }
            if (validBlocks > 0) {
                double e = tenergy / (double)validBlocks;
                CachedEnergyStorage[] var17 = blocks;
                int var18 = blocks.length;
                for (int var9 = 0; var9 < var18; ++var9) {
                    CachedEnergyStorage storage = var17[var9];
                    if (storage.isInvalid() || !storage.shouldReceiveEnergy()) continue;
                    if (storage.origin.cableTier != null && storage.origin.cableTier.transferRate < e) {
                        this.f_58857_.m_7731_(storage.origin.cablePos, BurntCableBlock.getBurntCable((BlockState)this.f_58857_.m_8055_(storage.origin.cablePos)), 3);
                        this.f_58857_.m_46796_(1502, storage.origin.cablePos, 0);
                        storage.origin.cableBurnt = true;
                        continue;
                    }
                    double a = storage.energyHandler.insertEnergy(Math.min(e, (double)this.storageToMachine.getEnergyStored() / 10.0), true);
                    if (a > 0.0) {
                        int ex = this.storageToMachine.extractEnergy(Mth.m_14107_((double)(a * 10.0)), false);
                        storage.energyHandler.insertEnergy((double)ex / 10.0, false);
                        this.m_6596_();
                    }
                    if ((double)this.storageToMachine.getEnergyStored() < e * 10.0) break;
                }
            }
        }
    }

    public boolean isValidEnergyOutputSide(Direction direction) {
        return this.getFacing() == direction;
    }

    public boolean isValidEnergyInputSide(Direction direction) {
        return this.getFacing() == direction;
    }

    public CachedEnergyStorage[] getConnectedEnergyBlocks() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            long currentId = ElectricBlockEntity.getCurrentElectricNetwork((LevelAccessor)this.f_58857_, (BlockPos)this.m_58899_());
            if (this.connectedEnergyBlocks == null || this.currentElectricNetwork == -1L || this.currentElectricNetwork != currentId) {
                HashSet<CachedEnergyStorage> set = new HashSet<CachedEnergyStorage>();
                HashSet<BlockPos> traversed = new HashSet<BlockPos>();
                traversed.add(this.f_58858_);
                for (Direction direction : FTBICUtils.DIRECTIONS) {
                    if (!this.isValidEnergyOutputSide(direction)) continue;
                    CachedEnergyStorageOrigin origin = new CachedEnergyStorageOrigin();
                    origin.direction = direction;
                    this.find(traversed, set, origin, 0, this.f_58858_, direction);
                }
                this.connectedEnergyBlocks = set.toArray(CachedEnergyStorage.EMPTY);
                this.currentElectricNetwork = currentId;
            }
            return this.connectedEnergyBlocks;
        }
        return CachedEnergyStorage.EMPTY;
    }

    private void find(Set<BlockPos> traversed, Set<CachedEnergyStorage> set, CachedEnergyStorageOrigin origin, int distance, BlockPos currentPos, Direction direction) {
        BlockPos pos;
        if (this.f_58857_ != null && distance <= (Integer)FTBICConfig.ENERGY.MAX_CABLE_LENGTH.get() && traversed.add(pos = currentPos.m_142300_(direction))) {
            BlockState state = this.f_58857_.m_8055_(pos);
            Block var10 = state.m_60734_();
            if (var10 instanceof CableBlock) {
                CableBlock cableBlock = (CableBlock)var10;
                if (origin.cableTier == null || cableBlock.tier.transferRate < origin.cableTier.transferRate) {
                    origin.cableTier = cableBlock.tier;
                    origin.cablePos = pos;
                }
                for (Direction dir : FTBICUtils.DIRECTIONS) {
                    if (!((Boolean)state.m_61143_((Property)CableBlock.CONNECTION[dir.m_122411_()])).booleanValue()) continue;
                    this.find(traversed, set, origin, distance + 1, pos, dir);
                }
            } else if (state.m_155947_()) {
                EnergyHandler handler;
                BlockEntity entity = this.f_58857_.m_7702_(pos);
                EnergyHandler energyHandler = handler = entity instanceof EnergyHandler ? (EnergyHandler)entity : null;
                if (handler != null) {
                    if (handler != this && handler.getMaxInputEnergy() > 0.0 && !handler.isBurnt() && handler.isValidEnergyInputSide(direction.m_122424_())) {
                        CachedEnergyStorage s = new CachedEnergyStorage();
                        s.origin = origin;
                        s.distance = distance;
                        s.blockEntity = entity;
                        s.energyHandler = handler;
                        set.add(s);
                    }
                } else if ((Double)FTBICConfig.ENERGY.ZAP_TO_FE_CONVERSION_RATE.get() > 0.0) {
                    if (entity == null) {
                        return;
                    }
                    LazyOptional energyCap = entity.getCapability(CapabilityEnergy.ENERGY, direction.m_122424_());
                    IEnergyStorage feStorage = (IEnergyStorage)energyCap.orElse((Object)null);
                    if (feStorage != null && feStorage.canReceive()) {
                        CachedEnergyStorage s = new CachedEnergyStorage();
                        s.origin = origin;
                        s.distance = distance;
                        s.blockEntity = entity;
                        s.energyHandler = new ForgeEnergyHandler(energyCap, feStorage);
                        set.add(s);
                    }
                }
            }
        }
    }

    public boolean isSource(ConnectionPoint cp) {
        return true;
    }

    public boolean isSink(ConnectionPoint cp) {
        return true;
    }

    public int getAvailableEnergy() {
        return this.storageToNet.getEnergyStored();
    }

    public int getRequestedEnergy() {
        return this.storageToMachine.getMaxEnergyStored() - this.storageToMachine.getEnergyStored();
    }

    public void insertEnergy(int amount) {
        this.storageToMachine.receiveEnergy(amount, false);
    }

    public void extractEnergy(int amount) {
        this.storageToNet.extractEnergy(amount, false);
    }

    public Collection<ResourceLocation> getRequestedHandlers() {
        return ImmutableList.of((Object)this.def.NET_ID);
    }
}

