/*
 * Decompiled with CFR 0.152.
 */
package com.tom.morewires.compat.ftbic;

import com.tom.morewires.CompatConfig;
import com.tom.morewires.compat.top.ProbeInfo;
import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.util.EnergyHandler;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.elements.ElementProgress;
import mcjty.theoneprobe.items.IEnumConfig;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class FTBICTOP
implements ProbeInfo {
    public static int zapbarFilledColor = -2293760;
    public static int zapbarAlternateFilledColor = -12386304;
    public static int zapbarBorderColor = -11184811;
    public static int zapMode;
    public static IEnumConfig<NumberFormat> zapFormat;
    private static ForgeConfigSpec.IntValue defaultZapMode;
    private static ForgeConfigSpec.ConfigValue<String> cfgZapbarFilledColor;
    private static ForgeConfigSpec.ConfigValue<String> cfgZapbarAlternateFilledColor;
    private static ForgeConfigSpec.ConfigValue<String> cfgZapbarBorderColor;

    public FTBICTOP() {
        CompatConfig.addConfig(ModConfig.Type.COMMON, new CompatConfig.ConfigHandler(){

            @Override
            public void reload() {
                FTBICTOP.reloadConfig();
            }

            @Override
            public void build(ForgeConfigSpec.Builder builder) {
                FTBICTOP.config(builder);
            }
        });
    }

    public static void config(ForgeConfigSpec.Builder builder) {
        builder.push("FTBIC TOP");
        defaultZapMode = builder.comment("How to display FTBIC Zaps: 0 = do not show, 1 = show in a bar, 2 = show as text").defineInRange("showZaps", 1, 0, 2);
        zapFormat = FTBICTOP.addEnumConfig((ForgeConfigSpec.Builder)builder, (String)"zapFormat", (String)"Format for displaying Zaps", (Enum)NumberFormat.COMPACT, (Enum[])new NumberFormat[]{NumberFormat.COMMAS, NumberFormat.COMPACT, NumberFormat.FULL, NumberFormat.NONE});
        cfgZapbarFilledColor = builder.comment("Color for the Zap bar").define("zapbarFilledColor", (Object)Integer.toHexString(zapbarFilledColor));
        cfgZapbarAlternateFilledColor = builder.comment("Alternate color for the Zap bar").define("zapbarAlternateFilledColor", (Object)Integer.toHexString(zapbarAlternateFilledColor));
        cfgZapbarBorderColor = builder.comment("Color for the Zap bar border").define("zapbarBorderColor", (Object)Integer.toHexString(zapbarBorderColor));
        builder.pop();
    }

    public static void reloadConfig() {
        zapbarFilledColor = FTBICTOP.parseColor((String)cfgZapbarFilledColor.get());
        zapbarAlternateFilledColor = FTBICTOP.parseColor((String)cfgZapbarAlternateFilledColor.get());
        zapbarBorderColor = FTBICTOP.parseColor((String)cfgZapbarBorderColor.get());
        zapMode = (Integer)defaultZapMode.get();
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data, BlockEntity te) {
        if (te instanceof EnergyHandler) {
            EnergyHandler h = (EnergyHandler)te;
            if (zapMode == 1) {
                probeInfo.progress((long)h.getEnergy(), (long)h.getEnergyCapacity(), probeInfo.defaultProgressStyle().suffix(FTBICConfig.ENERGY_FORMAT).filledColor(zapbarFilledColor).alternateFilledColor(zapbarAlternateFilledColor).borderColor(zapbarBorderColor).numberFormat((NumberFormat)zapFormat.get()));
            } else if (zapMode == 2) {
                probeInfo.text(CompoundText.create().style(TextStyleClass.PROGRESS).text((Component)FTBICConfig.ENERGY_FORMAT.m_6881_().m_130946_(": " + ElementProgress.format((long)((long)h.getEnergy()), (NumberFormat)((NumberFormat)zapFormat.get()), (Component)FTBICConfig.ENERGY_FORMAT))));
            }
        }
    }

    private static <T extends Enum<T>> IEnumConfig<T> addEnumConfig(ForgeConfigSpec.Builder builder, String path, String comment, T def, T ... values) {
        ForgeConfigSpec.ConfigValue configValue = builder.comment(comment).define(path, (Object)def.name());
        return () -> {
            String s = (String)configValue.get();
            for (Enum value : values) {
                if (!value.name().equals(s)) continue;
                return value;
            }
            return null;
        };
    }

    private static int parseColor(String col) {
        try {
            return (int)Long.parseLong(col, 16);
        }
        catch (NumberFormatException e) {
            System.out.println("Config.parseColor");
            return 0;
        }
    }
}

