/*
 * Decompiled with CFR 0.152.
 */
package com.tom.morewires.compat.id;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.ConnectorBlockEntityHelper;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.tom.morewires.MoreImmersiveWires;
import com.tom.morewires.compat.id.IDNetworkHandler;
import com.tom.morewires.tile.IOnCableConnector;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.api.path.IPathElement;
import org.cyclops.integrateddynamics.api.path.ISidedPathElement;
import org.cyclops.integrateddynamics.capability.cable.CableConfig;
import org.cyclops.integrateddynamics.capability.cable.CableTile;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierConfig;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierDefault;
import org.cyclops.integrateddynamics.capability.path.PathElementConfig;
import org.cyclops.integrateddynamics.capability.path.PathElementTile;
import org.cyclops.integrateddynamics.capability.path.SidedPathElement;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;

public class IDConnectorBlockEntity
extends CyclopsBlockEntity
implements IOnCableConnector {
    private final ICable cable = new CableTile<IDConnectorBlockEntity>(this){

        protected boolean isForceDisconnectable() {
            return false;
        }

        protected boolean isForceDisconnected(Direction side) {
            return IDConnectorBlockEntity.this.getFacing() != side;
        }

        protected EnumFacingMap<Boolean> getForceDisconnected() {
            return null;
        }

        protected EnumFacingMap<Boolean> getConnected() {
            return EnumFacingMap.newMap();
        }

        public boolean isConnected(Direction side) {
            return IDConnectorBlockEntity.this.getFacing() == side && CableHelpers.canCableConnectTo((BlockGetter)IDConnectorBlockEntity.this.f_58857_, (BlockPos)this.getPos(), (Direction)side, (ICable)this);
        }

        public void updateConnections() {
        }

        public ItemStack getItemStack() {
            return new ItemStack((ItemLike)MoreImmersiveWires.ID_WIRE.simple().CONNECTOR.get());
        }
    };
    private IDNetworkHandler handler;
    protected GlobalWireNetwork globalNet;
    private boolean isUnloaded = false;

    public IDConnectorBlockEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
        this.addCapabilityInternal(CableConfig.CAPABILITY, LazyOptional.of(() -> this.cable));
        this.addCapabilityInternal(NetworkCarrierConfig.CAPABILITY, LazyOptional.of(NetworkCarrierDefault::new));
        this.addCapabilityInternal(PathElementConfig.CAPABILITY, LazyOptional.of(() -> new PathElementTile<IDConnectorBlockEntity>(this, this.cable){

            public Set<ISidedPathElement> getReachableElements() {
                HashSet elements = Sets.newHashSet();
                Direction facing = IDConnectorBlockEntity.this.getFacing();
                IPathElement pathElement = (IPathElement)BlockEntityHelpers.getCapability((BlockGetter)IDConnectorBlockEntity.this.f_58857_, (BlockPos)IDConnectorBlockEntity.this.f_58858_.m_142300_(facing), (Direction)facing.m_122424_(), (Capability)PathElementConfig.CAPABILITY).orElse(null);
                if (pathElement != null) {
                    elements.add(SidedPathElement.of((IPathElement)pathElement, (Direction)facing.m_122424_()));
                }
                if (IDConnectorBlockEntity.this.handler != null) {
                    IDConnectorBlockEntity.this.handler.visitAll(elements);
                }
                return elements;
            }
        }));
    }

    public BlockState getState() {
        return this.m_58900_();
    }

    public boolean canConnect() {
        return true;
    }

    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        LocalWireNetwork local = this.globalNet.getNullableLocalNet(new ConnectionPoint(this.f_58858_, 0));
        if (local != null && !local.getConnections(this.f_58858_).isEmpty()) {
            return false;
        }
        return cableType == MoreImmersiveWires.ID_WIRE.simple().wireType;
    }

    public void connectCable(WireType cableType, ConnectionPoint target, IImmersiveConnectable other, ConnectionPoint otherTarget) {
    }

    public void removeCable(Connection connection, ConnectionPoint attachedPoint) {
        this.m_6596_();
    }

    public BlockPos getPosition() {
        return this.f_58858_;
    }

    @Override
    public Level getLevelNonnull() {
        return this.f_58857_;
    }

    public ICable getCable() {
        return this.cable;
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.m_58904_() != null && !this.m_58904_().f_46443_) {
            NetworkHelpers.invalidateNetworkElements((Level)this.m_58904_(), (BlockPos)this.m_58899_(), (BlockEntity)this);
        }
        ConnectorBlockEntityHelper.onChunkUnload((GlobalWireNetwork)this.globalNet, (IImmersiveConnectable)this);
        this.isUnloaded = true;
    }

    public void setNetworkHandler(IDNetworkHandler handler) {
        this.handler = handler;
        if (!this.f_58859_) {
            NetworkHelpers.initNetwork((Level)this.f_58857_, (BlockPos)this.f_58858_, null);
        }
    }

    public void m_142339_(Level worldIn) {
        super.m_142339_(worldIn);
        this.globalNet = GlobalWireNetwork.getNetwork((Level)worldIn);
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null) {
            ConnectorBlockEntityHelper.onChunkLoad((IImmersiveConnectable)this, (Level)this.f_58857_);
            this.isUnloaded = false;
        }
    }

    public void setRemovedIE() {
        ConnectorBlockEntityHelper.remove((Level)this.f_58857_, (IImmersiveConnectable)this);
    }

    public void m_7651_() {
        super.m_7651_();
        if (!this.isUnloaded) {
            this.setRemovedIE();
        }
    }

    public Collection<ResourceLocation> getRequestedHandlers() {
        return ImmutableList.of((Object)MoreImmersiveWires.ID_WIRE.simple().NET_ID);
    }

    public static class Ticker
    extends BlockEntityTickerDelayed<IDConnectorBlockEntity> {
        protected void update(Level level, BlockPos pos, BlockState blockState, IDConnectorBlockEntity blockEntity) {
            super.update(level, pos, blockState, (BlockEntity)blockEntity);
            NetworkHelpers.revalidateNetworkElements((Level)level, (BlockPos)pos);
        }
    }
}

