/*
 * Decompiled with CFR 0.152.
 */
package shadows.gateways.gate;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import shadows.gateways.entity.GatewayEntity;
import shadows.gateways.gate.Failure;
import shadows.gateways.gate.Reward;
import shadows.gateways.gate.SpawnAlgorithms;
import shadows.gateways.gate.Wave;
import shadows.placebo.json.ItemAdapter;
import shadows.placebo.json.NBTAdapter;
import shadows.placebo.json.PlaceboJsonReloadListener;
import shadows.placebo.json.RandomAttributeModifier;

public class Gateway
extends PlaceboJsonReloadListener.TypeKeyedBase<Gateway> {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeHierarchyAdapter(Failure.class, (Object)new Failure.Serializer()).registerTypeHierarchyAdapter(Reward.class, (Object)new Reward.Serializer()).registerTypeAdapter(ItemStack.class, (Object)ItemAdapter.INSTANCE).registerTypeAdapter(CompoundTag.class, (Object)NBTAdapter.INSTANCE).registerTypeAdapter(RandomAttributeModifier.class, (Object)new RandomAttributeModifier.Deserializer()).registerTypeAdapter(Wave.class, (Object)new Wave.Serializer()).create();
    protected final GatewayEntity.GatewaySize size;
    protected final TextColor color;
    protected final List<Wave> waves;
    protected final List<Reward> rewards;
    protected final List<Failure> failures;
    protected final int completionXp;
    protected final double spawnRange;
    protected final double leashRange;
    protected final SpawnAlgorithms.SpawnAlgorithm spawnAlgo;
    protected final boolean playerDamageOnly;
    protected final boolean allowDiscarding;

    public Gateway(GatewayEntity.GatewaySize size, TextColor color, List<Wave> waves, List<Reward> rewards, List<Failure> failures, int completionXp, double spawnRange, double leashRange, SpawnAlgorithms.SpawnAlgorithm spawnAlgo, boolean onlyPlayerDamage, boolean allowDiscarding) {
        this.size = size;
        this.color = color;
        this.waves = waves;
        this.rewards = rewards;
        this.failures = failures;
        this.completionXp = completionXp;
        this.spawnRange = spawnRange;
        this.leashRange = leashRange;
        this.spawnAlgo = spawnAlgo;
        this.playerDamageOnly = onlyPlayerDamage;
        this.allowDiscarding = allowDiscarding;
    }

    public GatewayEntity.GatewaySize getSize() {
        return this.size;
    }

    public TextColor getColor() {
        return this.color;
    }

    public List<Wave> getWaves() {
        return this.waves;
    }

    public int getNumWaves() {
        return this.waves.size();
    }

    public Wave getWave(int n) {
        return this.waves.get(n);
    }

    public List<Reward> getRewards() {
        return this.rewards;
    }

    public List<Failure> getFailures() {
        return this.failures;
    }

    public int getCompletionXp() {
        return this.completionXp;
    }

    public double getSpawnRange() {
        return this.spawnRange;
    }

    public JsonObject write() {
        JsonObject obj = new JsonObject();
        obj.addProperty("size", this.size.name().toLowerCase(Locale.ROOT));
        obj.addProperty("color", this.color.m_131274_());
        obj.add("waves", GSON.toJsonTree(this.waves));
        obj.add("rewards", GSON.toJsonTree(this.rewards));
        obj.addProperty("completion_xp", (Number)this.completionXp);
        obj.addProperty("spawn_range", (Number)this.spawnRange);
        obj.addProperty("leash_range", (Number)this.leashRange);
        return obj;
    }

    public static Gateway read(JsonObject obj) {
        GatewayEntity.GatewaySize size;
        String _size = GsonHelper.m_13906_((JsonObject)obj, (String)"size").toUpperCase(Locale.ROOT);
        try {
            size = GatewayEntity.GatewaySize.valueOf(_size);
        }
        catch (IllegalArgumentException ex) {
            throw new JsonParseException("Invalid gateway size " + _size);
        }
        String _color = GsonHelper.m_13906_((JsonObject)obj, (String)"color");
        TextColor color = TextColor.m_131268_((String)_color);
        if (color == null) {
            throw new JsonParseException("Invalid gateway color " + _color);
        }
        List waves = (List)GSON.fromJson(obj.get("waves"), new TypeToken<List<Wave>>(){}.getType());
        List rewards = (List)GSON.fromJson(obj.get("rewards"), new TypeToken<List<Reward>>(){}.getType());
        List<Failure> failures = (List<Failure>)GSON.fromJson(obj.get("failures"), new TypeToken<List<Failure>>(){}.getType());
        if (failures == null) {
            failures = Collections.emptyList();
        }
        int completionXp = GsonHelper.m_13927_((JsonObject)obj, (String)"completion_xp");
        double spawnRange = GsonHelper.m_144784_((JsonObject)obj, (String)"spawn_range");
        double leashRange = GsonHelper.m_144742_((JsonObject)obj, (String)"leash_range", (double)32.0);
        SpawnAlgorithms.SpawnAlgorithm spawnAlgo = (SpawnAlgorithms.SpawnAlgorithm)SpawnAlgorithms.NAMED_ALGORITHMS.get((Object)new ResourceLocation(GsonHelper.m_13851_((JsonObject)obj, (String)"spawn_algorithm", (String)"gateways:open_field")));
        Objects.requireNonNull(spawnAlgo);
        boolean playerDmgOnly = GsonHelper.m_13855_((JsonObject)obj, (String)"player_damage_only", (boolean)false);
        boolean allowDiscarding = GsonHelper.m_13855_((JsonObject)obj, (String)"allow_discarding", (boolean)false);
        return new Gateway(size, color, waves, rewards, failures, completionXp, spawnRange, leashRange, spawnAlgo, playerDmgOnly, allowDiscarding);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeByte(this.size.ordinal());
        buf.m_130070_(this.color.m_131274_());
        buf.m_130130_(this.waves.size());
        this.waves.forEach(w -> w.write(buf));
        buf.m_130130_(this.rewards.size());
        this.rewards.forEach(r -> r.write(buf));
        buf.m_130130_(this.failures.size());
        this.failures.forEach(r -> r.write(buf));
        buf.writeInt(this.completionXp);
        buf.writeDouble(this.spawnRange);
        buf.writeDouble(this.leashRange);
        buf.m_130085_((ResourceLocation)SpawnAlgorithms.NAMED_ALGORITHMS.inverse().get((Object)this.spawnAlgo));
        buf.writeByte(this.playerDamageOnly ? 1 : 0);
        buf.writeByte(this.allowDiscarding ? 1 : 0);
    }

    public SpawnAlgorithms.SpawnAlgorithm getSpawnAlgo() {
        return this.spawnAlgo;
    }

    public boolean playerDamageOnly() {
        return this.playerDamageOnly;
    }

    public boolean allowsDiscarding() {
        return this.allowDiscarding;
    }

    public static Gateway read(FriendlyByteBuf buf) {
        GatewayEntity.GatewaySize size = GatewayEntity.GatewaySize.values()[buf.readByte()];
        TextColor color = TextColor.m_131268_((String)buf.m_130277_());
        int nWaves = buf.m_130242_();
        ArrayList<Wave> waves = new ArrayList<Wave>(nWaves);
        for (int i = 0; i < nWaves; ++i) {
            waves.add(Wave.read(buf));
        }
        int nRewards = buf.m_130242_();
        ArrayList<Reward> rewards = new ArrayList<Reward>(nRewards);
        for (int i = 0; i < nRewards; ++i) {
            rewards.add(Reward.read(buf));
        }
        int nFailures = buf.m_130242_();
        ArrayList<Failure> failures = new ArrayList<Failure>(nFailures);
        for (int i = 0; i < nFailures; ++i) {
            failures.add(Failure.read(buf));
        }
        int completionXp = buf.readInt();
        double spawnRange = buf.readDouble();
        double leashRange = buf.readDouble();
        SpawnAlgorithms.SpawnAlgorithm spawnAlgo = (SpawnAlgorithms.SpawnAlgorithm)SpawnAlgorithms.NAMED_ALGORITHMS.get((Object)buf.m_130281_());
        boolean playerDmgOnly = buf.readByte() == 1;
        boolean allowDiscarding = buf.readByte() == 1;
        return new Gateway(size, color, waves, rewards, failures, completionXp, spawnRange, leashRange, spawnAlgo, playerDmgOnly, allowDiscarding);
    }

    public double getLeashRangeSq() {
        return this.leashRange * this.leashRange;
    }
}

