/*
 * Decompiled with CFR 0.152.
 */
package shadows.gateways.gate;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.phys.Vec3;
import shadows.gateways.Gateways;
import shadows.gateways.entity.GatewayEntity;
import shadows.gateways.gate.WaveEntity;

public class SpawnAlgorithms {
    public static final BiMap<ResourceLocation, SpawnAlgorithm> NAMED_ALGORITHMS = HashBiMap.create();
    public static final Codec<SpawnAlgorithm> CODEC;
    public static final int MAX_SPAWN_TRIES = 15;

    @Nullable
    public static Vec3 openField(ServerLevel level, Vec3 pos, GatewayEntity gate, WaveEntity toSpawn) {
        double spawnRange = gate.getGateway().getSpawnRange();
        int tries = 0;
        double x = pos.m_7096_() + (-1.0 + 2.0 * level.f_46441_.nextDouble()) * spawnRange;
        double y = pos.m_7098_() + (double)level.f_46441_.nextInt(3) - 1.0;
        double z = pos.m_7094_() + (-1.0 + 2.0 * level.f_46441_.nextDouble()) * spawnRange;
        while (!level.m_45772_(toSpawn.getAABB(x, y, z)) && tries++ < 15) {
            x = pos.m_7096_() + (level.f_46441_.nextDouble() - level.f_46441_.nextDouble()) * spawnRange + 0.5;
            y = pos.m_7098_() + (double)level.f_46441_.nextInt(3 * (int)gate.getGateway().getSize().getScale()) + 1.0;
            z = pos.m_7094_() + (level.f_46441_.nextDouble() - level.f_46441_.nextDouble()) * spawnRange + 0.5;
        }
        while (level.m_8055_(new BlockPos(x, y - 1.0, z)).m_60795_() && y > (double)level.m_141937_()) {
            y -= 1.0;
        }
        while (!level.m_45772_(toSpawn.getAABB(x, y, z))) {
            y += 1.0;
        }
        if (gate.m_20275_(x, y, z) > gate.getGateway().getLeashRangeSq()) {
            return null;
        }
        if (level.m_45772_(toSpawn.getAABB(x, y, z))) {
            return new Vec3(x, y, z);
        }
        return null;
    }

    @Nullable
    public static Vec3 inwardSpiral(ServerLevel level, Vec3 pos, GatewayEntity gate, WaveEntity toSpawn) {
        double spawnRange = gate.getGateway().getSpawnRange();
        int tries = 0;
        double x = pos.m_7096_() + (-1.0 + 2.0 * level.f_46441_.nextDouble()) * spawnRange;
        double y = pos.m_7098_() + (double)level.f_46441_.nextInt(3) - 1.0;
        double z = pos.m_7094_() + (-1.0 + 2.0 * level.f_46441_.nextDouble()) * spawnRange;
        while (!level.m_45772_(toSpawn.getAABB(x, y, z)) && tries++ < 15) {
            float scaleFactor = (float)(14 - tries) / 15.0f;
            x = pos.m_7096_() + (double)scaleFactor * (level.f_46441_.nextDouble() - level.f_46441_.nextDouble()) * spawnRange + 0.5;
            y = pos.m_7098_() + (double)(scaleFactor * (float)level.f_46441_.nextInt(3 * (int)gate.getGateway().getSize().getScale())) + 1.0;
            z = pos.m_7094_() + (double)scaleFactor * (level.f_46441_.nextDouble() - level.f_46441_.nextDouble()) * spawnRange + 0.5;
        }
        while (level.m_8055_(new BlockPos(x, y - 1.0, z)).m_60795_() && y > (double)level.m_141937_()) {
            y -= 1.0;
        }
        while (!level.m_45772_(toSpawn.getAABB(x, y, z))) {
            y += 1.0;
        }
        if (gate.m_20275_(x, y, z) > gate.getGateway().getLeashRangeSq()) {
            return null;
        }
        if (level.m_45772_(toSpawn.getAABB(x, y, z))) {
            return new Vec3(x, y, z);
        }
        return null;
    }

    static {
        NAMED_ALGORITHMS.put((Object)Gateways.loc("open_field"), SpawnAlgorithms::openField);
        NAMED_ALGORITHMS.put((Object)Gateways.loc("inward_spiral"), SpawnAlgorithms::inwardSpiral);
        CODEC = ExtraCodecs.m_184405_(sa -> ((ResourceLocation)NAMED_ALGORITHMS.inverse().get(sa)).toString(), key -> (SpawnAlgorithm)NAMED_ALGORITHMS.get((Object)new ResourceLocation(key)));
    }

    public static interface SpawnAlgorithm {
        @Nullable
        public Vec3 spawn(ServerLevel var1, Vec3 var2, GatewayEntity var3, WaveEntity var4);
    }
}

