/*
 * Decompiled with CFR 0.152.
 */
package shadows.gateways.gate;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shadows.gateways.GatewayObjects;
import shadows.gateways.entity.GatewayEntity;
import shadows.gateways.gate.Gateway;
import shadows.gateways.gate.Reward;
import shadows.gateways.gate.WaveEntity;
import shadows.placebo.json.PlaceboJsonReloadListener;
import shadows.placebo.json.RandomAttributeModifier;
import shadows.placebo.json.SerializerBuilder;
import shadows.placebo.util.StepFunction;

public record Wave(List<WaveEntity> entities, List<RandomAttributeModifier> modifiers, List<Reward> rewards, int maxWaveTime, int setupTime) {
    public List<LivingEntity> spawnWave(ServerLevel level, Vec3 pos, GatewayEntity gate) {
        ArrayList<LivingEntity> spawned = new ArrayList<LivingEntity>();
        for (WaveEntity toSpawn : this.entities) {
            Vec3 spawnPos = gate.getGateway().getSpawnAlgo().spawn(level, pos, gate, toSpawn);
            LivingEntity entity = toSpawn.createEntity((Level)level);
            if (spawnPos == null || entity == null) {
                gate.onFailure(spawned, GatewayEntity.FailureReason.SPAWN_FAILED);
                break;
            }
            entity.getPersistentData().m_128362_("gateways.owner", gate.m_142081_());
            entity.m_7678_(spawnPos.m_7096_(), spawnPos.m_7098_(), spawnPos.m_7094_(), level.f_46441_.nextFloat() * 360.0f, level.f_46441_.nextFloat() * 360.0f);
            entity.m_142429_().filter(e -> e instanceof LivingEntity).map(LivingEntity.class::cast).forEach(e -> {
                this.modifiers.forEach(m -> m.apply(level.f_46441_, e));
                e.m_21153_(entity.m_21233_());
                e.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 5, 100, true, false));
            });
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                if (toSpawn.shouldFinalizeSpawn() && !ForgeEventFactory.doSpecialSpawn((Mob)((Mob)entity), (LevelAccessor)level, (float)((float)entity.m_20185_()), (float)((float)entity.m_20186_()), (float)((float)entity.m_20189_()), null, (MobSpawnType)MobSpawnType.SPAWNER)) {
                    mob.m_6518_((ServerLevelAccessor)level, level.m_6436_(entity.m_142538_()), MobSpawnType.SPAWNER, null, null);
                }
                mob.m_6710_((LivingEntity)gate.m_183503_().m_45930_((Entity)gate, 12.0));
                mob.m_21530_();
            }
            level.m_47205_((Entity)entity);
            level.m_6263_(null, gate.m_20185_(), gate.m_20186_(), gate.m_20189_(), GatewayObjects.GATE_WARP, SoundSource.HOSTILE, 0.5f, 1.0f);
            spawned.add(entity);
            gate.spawnParticle(gate.getGateway().getColor(), entity.m_20185_() + (double)(entity.m_20205_() / 2.0f), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_() + (double)(entity.m_20205_() / 2.0f), 0);
        }
        return spawned;
    }

    public List<ItemStack> spawnRewards(ServerLevel level, GatewayEntity gate, Player summoner) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        this.rewards.forEach(r -> r.generateLoot(level, gate, summoner, s -> {
            if (!s.m_41619_()) {
                stacks.add((ItemStack)s);
            }
        }));
        return stacks;
    }

    public JsonObject write() {
        JsonObject obj = new JsonObject();
        JsonArray arr = new JsonArray();
        for (WaveEntity entity : this.entities) {
            SerializerBuilder.Serializer s = entity.getSerializer();
            ResourceLocation id = (ResourceLocation)WaveEntity.SERIALIZERS.inverse().get((Object)s);
            JsonObject entityData = s.write((Object)entity);
            entityData.addProperty("type", id.toString());
            arr.add((JsonElement)entityData);
        }
        obj.add("entities", (JsonElement)arr);
        obj.add("modifiers", Gateway.GSON.toJsonTree(this.modifiers));
        obj.add("rewards", Gateway.GSON.toJsonTree(this.rewards));
        obj.addProperty("max_wave_time", (Number)this.maxWaveTime);
        obj.addProperty("setup_time", (Number)this.setupTime);
        return obj;
    }

    public static Wave read(JsonObject obj) {
        List<Reward> rewards;
        JsonArray entities = obj.get("entities").getAsJsonArray();
        ArrayList<WaveEntity> entityList = new ArrayList<WaveEntity>();
        for (JsonElement e : entities) {
            JsonObject entity = e.getAsJsonObject();
            ResourceLocation id = entity.has("type") ? new ResourceLocation(entity.get("type").getAsString()) : PlaceboJsonReloadListener.DEFAULT;
            SerializerBuilder.Serializer s = (SerializerBuilder.Serializer)WaveEntity.SERIALIZERS.get((Object)id);
            entityList.add((WaveEntity)s.read(entity));
        }
        List<RandomAttributeModifier> modifiers = (List<RandomAttributeModifier>)Gateway.GSON.fromJson(obj.get("modifiers"), new TypeToken<List<RandomAttributeModifier>>(){}.getType());
        if (modifiers == null) {
            modifiers = Collections.emptyList();
        }
        if ((rewards = (List<Reward>)Gateway.GSON.fromJson(obj.get("rewards"), new TypeToken<List<Reward>>(){}.getType())) == null) {
            rewards = Collections.emptyList();
        }
        int maxWaveTime = GsonHelper.m_13927_((JsonObject)obj, (String)"max_wave_time");
        int recoveryTime = GsonHelper.m_13927_((JsonObject)obj, (String)"setup_time");
        return new Wave(entityList, modifiers, rewards, maxWaveTime, recoveryTime);
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.entities.size());
        for (WaveEntity entity : this.entities) {
            SerializerBuilder.Serializer s = entity.getSerializer();
            ResourceLocation id = (ResourceLocation)WaveEntity.SERIALIZERS.inverse().get((Object)s);
            buf.m_130085_(id);
            s.write((Object)entity, buf);
        }
        buf.m_130130_(this.modifiers.size());
        this.modifiers.forEach(m -> {
            buf.writeRegistryId((IForgeRegistryEntry)m.getAttribute());
            buf.writeByte(m.getOp().ordinal());
            buf.writeFloat(m.getValue().min());
        });
        buf.m_130130_(this.rewards.size());
        this.rewards.forEach(r -> r.write(buf));
        buf.writeInt(this.maxWaveTime);
        buf.writeInt(this.setupTime);
    }

    public static Wave read(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        ArrayList<WaveEntity> entities = new ArrayList<WaveEntity>(size);
        for (int i = 0; i < size; ++i) {
            ResourceLocation id = buf.m_130281_();
            SerializerBuilder.Serializer s = (SerializerBuilder.Serializer)WaveEntity.SERIALIZERS.get((Object)id);
            entities.add((WaveEntity)s.read(buf));
        }
        size = buf.m_130242_();
        ArrayList<RandomAttributeModifier> modifiers = new ArrayList<RandomAttributeModifier>(size);
        for (int i = 0; i < size; ++i) {
            Attribute attrib = (Attribute)buf.readRegistryIdSafe(Attribute.class);
            AttributeModifier.Operation op = AttributeModifier.Operation.values()[buf.readByte()];
            float value = buf.readFloat();
            modifiers.add(new RandomAttributeModifier(attrib, op, new StepFunction(value, 1, 0.0f)));
        }
        size = buf.m_130242_();
        ArrayList<Reward> rewards = new ArrayList<Reward>(size);
        for (int i = 0; i < size; ++i) {
            rewards.add(Reward.read(buf));
        }
        int maxWaveTime = buf.readInt();
        int recoveryTime = buf.readInt();
        return new Wave(entities, modifiers, rewards, maxWaveTime, recoveryTime);
    }

    public static class Serializer
    implements JsonDeserializer<Wave>,
    JsonSerializer<Wave> {
        public JsonElement serialize(Wave src, Type typeOfSrc, JsonSerializationContext context) {
            return src.write();
        }

        public Wave deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Wave.read(json.getAsJsonObject());
        }
    }
}

