/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.OptionalLong;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.commands.synchronization.EmptyArgumentSerializer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.CreativeCoreConfig;
import team.creative.creativecore.CreativeForgeLoader;
import team.creative.creativecore.ICreativeLoader;
import team.creative.creativecore.Side;
import team.creative.creativecore.client.CreativeCoreClient;
import team.creative.creativecore.common.config.event.ConfigEventHandler;
import team.creative.creativecore.common.config.gui.ClientSyncGuiLayer;
import team.creative.creativecore.common.config.gui.ConfigGuiLayer;
import team.creative.creativecore.common.config.gui.GuiInfoStackButton;
import team.creative.creativecore.common.config.gui.GuiPlayerSelectorButton;
import team.creative.creativecore.common.config.holder.CreativeConfigRegistry;
import team.creative.creativecore.common.config.sync.ConfigurationChangePacket;
import team.creative.creativecore.common.config.sync.ConfigurationClientPacket;
import team.creative.creativecore.common.config.sync.ConfigurationPacket;
import team.creative.creativecore.common.gui.dialog.GuiDialogHandler;
import team.creative.creativecore.common.gui.handler.GuiCreator;
import team.creative.creativecore.common.gui.handler.GuiLayerHandler;
import team.creative.creativecore.common.gui.integration.ContainerIntegration;
import team.creative.creativecore.common.gui.integration.GuiEventHandler;
import team.creative.creativecore.common.gui.packet.ControlSyncPacket;
import team.creative.creativecore.common.gui.packet.LayerClosePacket;
import team.creative.creativecore.common.gui.packet.LayerOpenPacket;
import team.creative.creativecore.common.gui.packet.OpenGuiPacket;
import team.creative.creativecore.common.network.CreativeNetwork;
import team.creative.creativecore.common.util.argument.StringArrayArgumentType;

@Mod(value="creativecore")
public class CreativeCore {
    private static final ICreativeLoader LOADER = new CreativeForgeLoader();
    public static final String MODID = "creativecore";
    public static final Logger LOGGER = LogManager.getLogger((String)"creativecore");
    public static final CreativeCoreConfig CONFIG = new CreativeCoreConfig();
    public static final CreativeNetwork NETWORK = new CreativeNetwork("1.0", LOGGER, new ResourceLocation("creativecore", "main"));
    public static ConfigEventHandler CONFIG_HANDLER;
    public static final ResourceLocation FAKE_WORLD_LOCATION;
    public static Holder<DimensionType> FAKE_DIMENSION;
    public static ResourceKey<Level> FAKE_DIMENSION_NAME;
    public static MenuType<ContainerIntegration> GUI_CONTAINER;
    public static final GuiCreator.GuiCreatorBasic CONFIG_OPEN;
    public static final GuiCreator.GuiCreatorBasic CLIENT_CONFIG_OPEN;

    public CreativeCore() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(MenuType.class, this::registerMenus);
        MinecraftForge.EVENT_BUS.addListener(this::server);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::client));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(CreativeCoreClient::modelEvent));
        GUI_CONTAINER = new MenuType<ContainerIntegration>(null){

            public ContainerIntegration create(int windowId, Inventory playerInv, FriendlyByteBuf extraData) {
                return new ContainerIntegration(this, windowId, playerInv.f_35978_);
            }

            public ContainerIntegration create(int windowId, Inventory playerInv) {
                return new ContainerIntegration(this, windowId, playerInv.f_35978_);
            }
        };
        GUI_CONTAINER.setRegistryName("container");
    }

    public void registerMenus(RegistryEvent.Register<MenuType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new MenuType[]{GUI_CONTAINER});
    }

    @OnlyIn(value=Dist.CLIENT)
    private void client(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register(CreativeCoreClient.class);
        CreativeCoreClient.init(event);
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
    }

    private void server(ServerStartingEvent event) {
        event.getServer().m_129892_().m_82094_().register((LiteralArgumentBuilder)Commands.m_82127_((String)"cmdconfig").executes(x -> {
            CONFIG_OPEN.open(new CompoundTag(), (Player)((CommandSourceStack)x.getSource()).m_81375_());
            return 0;
        }));
    }

    private void init(FMLCommonSetupEvent event) {
        NETWORK.registerType(ConfigurationChangePacket.class, ConfigurationChangePacket::new);
        NETWORK.registerType(ConfigurationClientPacket.class, ConfigurationClientPacket::new);
        NETWORK.registerType(ConfigurationPacket.class, ConfigurationPacket::new);
        NETWORK.registerType(LayerClosePacket.class, LayerClosePacket::new);
        NETWORK.registerType(LayerOpenPacket.class, LayerOpenPacket::new);
        NETWORK.registerType(OpenGuiPacket.class, OpenGuiPacket::new);
        NETWORK.registerType(ControlSyncPacket.class, ControlSyncPacket::new);
        CONFIG_HANDLER = new ConfigEventHandler(FMLPaths.CONFIGDIR.get().toFile(), LOGGER);
        MinecraftForge.EVENT_BUS.register(GuiEventHandler.class);
        FAKE_DIMENSION = Holder.m_205709_((Object)DimensionType.m_204497_((OptionalLong)OptionalLong.empty(), (boolean)true, (boolean)false, (boolean)false, (boolean)false, (double)1.0, (boolean)false, (boolean)true, (boolean)true, (boolean)false, (boolean)false, (int)-64, (int)384, (int)384, (TagKey)BlockTags.f_13058_, (ResourceLocation)DimensionType.f_63840_, (float)0.0f));
        ArgumentTypes.m_121601_((String)"names", StringArrayArgumentType.class, (ArgumentSerializer)new EmptyArgumentSerializer(() -> StringArrayArgumentType.stringArray()));
        GuiLayerHandler.REGISTRY.register("info", GuiInfoStackButton.INFO_LAYER);
        GuiLayerHandler.REGISTRY.register("player", GuiPlayerSelectorButton.PLAYER_LAYER);
        GuiLayerHandler.REGISTRY.register("dialog", GuiDialogHandler.DIALOG_HANDLER);
    }

    public static ICreativeLoader loader() {
        return LOADER;
    }

    static {
        FAKE_WORLD_LOCATION = new ResourceLocation(MODID, "fake");
        FAKE_DIMENSION_NAME = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)FAKE_WORLD_LOCATION);
        CONFIG_OPEN = GuiCreator.register("config", new GuiCreator.GuiCreatorBasic((player, nbt) -> new ConfigGuiLayer(CreativeConfigRegistry.ROOT, Side.SERVER)));
        CLIENT_CONFIG_OPEN = GuiCreator.register("clientconfig", new GuiCreator.GuiCreatorBasic((player, nbt) -> new ClientSyncGuiLayer(CreativeConfigRegistry.ROOT)));
    }
}

