/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.coroutil.command;

import com.corosus.coroutil.util.CULog;
import com.corosus.modconfig.ConfigMod;
import com.corosus.modconfig.CoroConfigRegistry;
import com.corosus.modconfig.ModConfigData;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;

public class CommandCoroConfig {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)CommandCoroConfig.getCommandName()).requires(s -> s.m_6761_(2))).then(Commands.m_82127_((String)"config").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"common").then(CommandCoroConfig.argumentReload(ModConfig.Type.COMMON))).then(CommandCoroConfig.argumentSave())).then(CommandCoroConfig.argumentGet())).then(CommandCoroConfig.argumentSet()))));
    }

    public static ArgumentBuilder<CommandSourceStack, ?> argumentReload(ModConfig.Type type) {
        return Commands.m_82127_((String)"reload").executes(c -> {
            CULog.log("reloading all mods common configurations from disk");
            ConfigTracker.INSTANCE.loadConfigs(type, ConfigMod.instance().getConfigPath());
            ((CommandSourceStack)c.getSource()).m_81354_((Component)new TextComponent("Reloading all common configs from disk"), true);
            return 1;
        });
    }

    public static ArgumentBuilder<CommandSourceStack, ?> argumentSave() {
        return Commands.m_82127_((String)"save").executes(c -> {
            CULog.log("saving all coro mods runtime configs to disk");
            CoroConfigRegistry.instance().forceSaveAllFilesFromRuntimeSettings();
            ((CommandSourceStack)c.getSource()).m_81354_((Component)new TextComponent("Saving all common coro configs to disk"), true);
            return 1;
        });
    }

    public static ArgumentBuilder<CommandSourceStack, ?> argumentGet() {
        return Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"file_name", (ArgumentType)StringArgumentType.word()).suggests((p_136339_, p_136340_) -> SharedSuggestionProvider.m_82970_(CommandCoroConfig.getConfigs(), (SuggestionsBuilder)p_136340_)).then(Commands.m_82129_((String)"setting_name", (ArgumentType)StringArgumentType.word()).suggests((p_136339_, p_136340_) -> SharedSuggestionProvider.m_82970_(CommandCoroConfig.getConfigSettings(StringArgumentType.getString((CommandContext)p_136339_, (String)"file_name")), (SuggestionsBuilder)p_136340_)).executes(c -> {
            String fileName = CommandCoroConfig.fileToConfig(StringArgumentType.getString((CommandContext)c, (String)"file_name"));
            String configName = CoroConfigRegistry.instance().lookupFilePathToConfig.get((Object)fileName).configID;
            String settingName = StringArgumentType.getString((CommandContext)c, (String)"setting_name");
            Object obj = CoroConfigRegistry.instance().getField(configName, settingName);
            ((CommandSourceStack)c.getSource()).m_81354_((Component)new TextComponent(settingName + " = " + obj + " in " + fileName), true);
            return 1;
        })));
    }

    public static ArgumentBuilder<CommandSourceStack, ?> argumentSet() {
        return Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"file_name", (ArgumentType)StringArgumentType.word()).suggests((p_136339_, p_136340_) -> SharedSuggestionProvider.m_82970_(CommandCoroConfig.getConfigs(), (SuggestionsBuilder)p_136340_)).then(Commands.m_82129_((String)"setting_name", (ArgumentType)StringArgumentType.word()).suggests((p_136339_, p_136340_) -> SharedSuggestionProvider.m_82970_(CommandCoroConfig.getConfigSettings(StringArgumentType.getString((CommandContext)p_136339_, (String)"file_name")), (SuggestionsBuilder)p_136340_)).then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.string()).executes(c -> {
            String fileName = CommandCoroConfig.fileToConfig(StringArgumentType.getString((CommandContext)c, (String)"file_name"));
            String configName = CoroConfigRegistry.instance().lookupFilePathToConfig.get((Object)fileName).configID;
            String settingName = StringArgumentType.getString((CommandContext)c, (String)"setting_name");
            String value = StringArgumentType.getString((CommandContext)c, (String)"value");
            boolean result = CoroConfigRegistry.instance().updateField(configName, settingName, value);
            if (result) {
                Object obj = CoroConfigRegistry.instance().getField(configName, settingName);
                CoroConfigRegistry.instance().forceSaveAllFilesFromRuntimeSettings();
                ((CommandSourceStack)c.getSource()).m_81354_((Component)new TextComponent("Set " + settingName + " to " + obj + " in " + fileName), true);
            } else {
                ((CommandSourceStack)c.getSource()).m_81354_((Component)new TextComponent("Invalid setting to use for " + settingName), true);
            }
            return 1;
        }))));
    }

    public static String getCommandName() {
        return "coro";
    }

    public static Iterable<String> getConfigs() {
        return CoroConfigRegistry.instance().lookupFilePathToConfig.keySet().stream().map(e -> e.replace("\\", "--")).toList();
    }

    public static Iterable<String> getConfigSettings(String config_name) {
        ModConfigData modConfigData = CoroConfigRegistry.instance().lookupFilePathToConfig.get(CommandCoroConfig.fileToConfig(config_name));
        if (modConfigData != null) {
            ArrayList<String> joinedList = new ArrayList<String>();
            joinedList.addAll(modConfigData.valsString.keySet());
            joinedList.addAll(modConfigData.valsInteger.keySet());
            joinedList.addAll(modConfigData.valsDouble.keySet());
            joinedList.addAll(modConfigData.valsBoolean.keySet());
            Collections.sort(joinedList);
            return joinedList;
        }
        return List.of("<-- invalid config name");
    }

    public static String fileToConfig(String str) {
        return str.replace("--", "\\");
    }
}

