/*
 * Decompiled with CFR 0.152.
 */
package io.iridium.overvaults;

import com.mojang.logging.LogUtils;
import io.iridium.overvaults.world.structure.ModStructures;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="overvaults")
public class OverVaults {
    public static final String MOD_ID = "overvaults";
    public static final Logger LOGGER = LogUtils.getLogger();

    public OverVaults() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModStructures.register(modEventBus);
    }

    private void clientSetup(FMLClientSetupEvent event) {
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    @Mod.EventBusSubscriber(modid="overvaults")
    public static class OverVaultsEventHandler {
        public static String vaultFighterEntity = "the_vault:vault_fighter_5";

        @SubscribeEvent
        public static void onAdvancement(AdvancementEvent event) {
            Entity entity;
            if (!event.getAdvancement().m_138327_().equals((Object)new ResourceLocation("overvaults:exploration/root"))) {
                return;
            }
            ServerLevel serverWorld = (ServerLevel)event.getPlayer().f_19853_;
            BlockPos pos = event.getPlayer().m_142538_();
            ArrayList<Block> blocksToSearch = new ArrayList<Block>();
            blocksToSearch.add((Block)Registry.f_122824_.m_7745_(new ResourceLocation("the_vault:chiseled_vault_stone")));
            blocksToSearch.add((Block)Registry.f_122824_.m_7745_(new ResourceLocation("the_vault:chromatic_iron_block")));
            blocksToSearch.add((Block)Registry.f_122824_.m_7745_(new ResourceLocation("the_vault:bumbo_polished_vault_stone")));
            BlockPos hunterSpawnPos = OverVaultsEventHandler.isBlockNearby(serverWorld, pos, blocksToSearch, 20);
            EntityType entityType = EntityType.m_20632_((String)vaultFighterEntity).orElse(null);
            if (hunterSpawnPos == null || entityType == null || (entity = entityType.m_20615_((Level)serverWorld)) == null) {
                OverVaultsEventHandler.removeAdvancement((ServerPlayer)event.getPlayer(), "overvaults:exploration/whispers");
                OverVaultsEventHandler.removeAdvancement((ServerPlayer)event.getPlayer(), "overvaults:exploration/root");
                return;
            }
            serverWorld.m_5594_(null, hunterSpawnPos, SoundEvents.f_12090_, SoundSource.MASTER, 1.0f, 1.0f);
            serverWorld.m_5594_(null, hunterSpawnPos, SoundEvents.f_11860_, SoundSource.MASTER, 1.0f, 0.2f);
            event.getPlayer().m_6352_((Component)new TextComponent("please send kelp").m_130940_(ChatFormatting.OBFUSCATED).m_130940_(ChatFormatting.RED), event.getPlayer().m_142081_());
            event.getPlayer().m_6352_((Component)new TextComponent("You think you can succeed? Where even I have failed?").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY), event.getPlayer().m_142081_());
            event.getPlayer().m_6352_((Component)new TextComponent("please send kelp").m_130940_(ChatFormatting.OBFUSCATED).m_130940_(ChatFormatting.RED), event.getPlayer().m_142081_());
            serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123760_, (double)hunterSpawnPos.m_123341_() + 0.5, (double)(hunterSpawnPos.m_123342_() + 1), (double)hunterSpawnPos.m_123343_() + 0.5, 8000, 1.0, 2.0, 1.0, 2.0);
            MinecraftServer server = serverWorld.m_142572_();
            ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
            scheduler.schedule(() -> server.execute(() -> {
                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123789_, (double)hunterSpawnPos.m_123341_() + 0.5, (double)(hunterSpawnPos.m_123342_() + 1), (double)hunterSpawnPos.m_123343_() + 0.5, 6000, 0.5, 2.0, 0.5, 2.0);
                entity.m_6027_((double)hunterSpawnPos.m_123341_() + 0.5, (double)(hunterSpawnPos.m_123342_() + 1), (double)hunterSpawnPos.m_123343_() + 0.5);
                serverWorld.m_7967_(entity);
                OverVaultsEventHandler.showTextAboveEntity(entity, "please send kelp");
            }), 2300L, TimeUnit.MILLISECONDS);
        }

        public static void removeAdvancement(ServerPlayer player, String advancementID) {
            MinecraftServer server = player.m_20194_();
            if (server != null) {
                String command = String.format("advancement revoke %s from %s", player.m_7755_().getString(), advancementID);
                CommandSourceStack commandSourceStack = server.m_129893_().m_81324_();
                server.m_129892_().m_82117_(commandSourceStack, command);
            }
        }

        public static void showTextAboveEntity(Entity entity, String text) {
            ServerLevel serverWorld = (ServerLevel)entity.f_19853_;
            ArmorStand armorStand = (ArmorStand)EntityType.f_20529_.m_20615_((Level)serverWorld);
            if (armorStand == null) {
                return;
            }
            armorStand.m_6593_((Component)new TextComponent(text).m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.OBFUSCATED));
            armorStand.m_20340_(true);
            armorStand.m_20242_(true);
            armorStand.m_6842_(true);
            armorStand.m_6027_(entity.m_20185_(), entity.m_20186_() - 0.5, entity.m_20189_());
            serverWorld.m_7967_((Entity)armorStand);
            armorStand.m_31677_();
            armorStand.m_20329_(entity);
            entity.m_7332_((Entity)armorStand);
        }

        public static BlockPos isBlockNearby(ServerLevel world, BlockPos center, List<Block> blocksToFind, int maxRadius) {
            for (int radius = 0; radius <= maxRadius; ++radius) {
                for (int x = -radius; x <= radius; ++x) {
                    for (int y = -radius; y <= radius; ++y) {
                        for (int z = -radius; z <= radius; ++z) {
                            boolean isTransparent;
                            BlockPos pos;
                            if (Math.abs(x) != radius && Math.abs(y) != radius && Math.abs(z) != radius || !blocksToFind.contains(world.m_8055_(pos = center.m_142082_(x, y, z)).m_60734_())) continue;
                            boolean bl = isTransparent = world.m_8055_(pos.m_7494_()).m_60767_().m_76336_() && world.m_8055_(pos.m_6630_(2)).m_60767_().m_76336_();
                            if (!isTransparent) continue;
                            return pos;
                        }
                    }
                }
            }
            return null;
        }

        @SubscribeEvent
        public static void onEntityDeath(LivingDeathEvent event) {
            Entity entity;
            Entity passenger;
            if (event.getEntity().m_20197_().size() > 0 && (passenger = (Entity)(entity = event.getEntity()).m_20197_().get(0)) instanceof ArmorStand) {
                passenger.m_6074_();
                passenger.m_146870_();
            }
        }
    }
}

