/*
 * Decompiled with CFR 0.152.
 */
package io.iridium.overvaults.world.structure;

import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraftforge.registries.ForgeRegistries;

public class VaultPortalStructures
extends StructureFeature<JigsawConfiguration> {
    private static Block CUT_VINE = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("quark:cut_vine"));
    private static Block CHROMATIC_IRON_ORE = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("the_vault:chromatic_iron_ore"));
    private static Block RAW_CHROMATIC_IRON_BLOCK = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("the_vault:raw_chromatic_iron_block"));
    private static Block GILDED_SCONCE = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("the_vault:gilded_sconce"));

    public VaultPortalStructures() {
        super(JigsawConfiguration.f_67756_, VaultPortalStructures::createPiecesGenerator, VaultPortalStructures::afterPlace);
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    private static boolean isValidFlatLand(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        int[][] offsets;
        ChunkPos chunkPos = context.f_197355_();
        ChunkGenerator chunkGenerator = context.f_197352_();
        Heightmap.Types heightmapType = Heightmap.Types.WORLD_SURFACE_WG;
        int maxHeightDifference = 8;
        int baseX = chunkPos.m_151390_();
        int baseZ = chunkPos.m_151393_();
        int baseY = chunkGenerator.m_142647_(baseX, baseZ, heightmapType, context.f_197357_());
        for (int[] offset : offsets = new int[][]{{0, 0}, {-7, -7}, {7, -7}, {-7, 7}, {7, 7}}) {
            int x = baseX + offset[0];
            int z = baseZ + offset[1];
            int currentY = chunkGenerator.m_142647_(x, z, heightmapType, context.f_197357_());
            if (Math.abs(currentY - baseY) <= maxHeightDifference) continue;
            return false;
        }
        return true;
    }

    public static Optional<PieceGenerator<JigsawConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        BlockPos blockpos = context.f_197355_().m_151394_(0);
        int surfaceY = context.f_197352_().m_142647_(blockpos.m_123341_(), blockpos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
        BlockPos surfacePos = new BlockPos(blockpos.m_123341_(), surfaceY, blockpos.m_123343_());
        BlockState blockState = context.f_197352_().m_141914_(surfacePos.m_123341_(), surfacePos.m_123343_(), context.f_197357_()).m_183556_(surfacePos.m_123342_() - 1);
        boolean isWater = blockState.m_60819_().m_76170_();
        if (!isWater && !VaultPortalStructures.isValidFlatLand(context)) {
            return Optional.empty();
        }
        blockpos = new BlockPos(blockpos.m_123341_(), surfaceY, blockpos.m_123343_());
        if (isWater) {
            int oceanFloorY = context.f_197352_().m_142647_(blockpos.m_123341_(), blockpos.m_123343_(), Heightmap.Types.OCEAN_FLOOR_WG, context.f_197357_());
            blockpos = new BlockPos(blockpos.m_123341_(), oceanFloorY, blockpos.m_123343_());
        }
        Optional structurePiecesGenerator = JigsawPlacement.m_210284_(context, PoolElementStructurePiece::new, (BlockPos)blockpos, (boolean)false, (boolean)false);
        return structurePiecesGenerator;
    }

    private static void afterPlace(WorldGenLevel level, StructureFeatureManager structureFeatureManager, ChunkGenerator chunkGenerator, Random random, BoundingBox boundingBox, ChunkPos chunkPos, PiecesContainer piecesContainer) {
        for (int x = boundingBox.m_162395_(); x <= boundingBox.m_162399_(); ++x) {
            for (int y = boundingBox.m_162396_(); y <= boundingBox.m_162400_(); ++y) {
                for (int z = boundingBox.m_162398_(); z <= boundingBox.m_162401_(); ++z) {
                    boolean isSubmerged;
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState currentState = level.m_8055_(pos);
                    if (!currentState.m_60713_(Blocks.f_50191_) && !currentState.m_60713_(CUT_VINE) && !currentState.m_60713_(CHROMATIC_IRON_ORE) && !currentState.m_60713_(GILDED_SCONCE)) continue;
                    boolean bl = isSubmerged = level.m_8055_(pos.m_7494_()).m_60819_().m_76170_() || level.m_8055_(pos.m_142127_()).m_60819_().m_76170_() || level.m_8055_(pos.m_142128_()).m_60819_().m_76170_() || level.m_8055_(pos.m_142126_()).m_60819_().m_76170_() || level.m_8055_(pos.m_142125_()).m_60819_().m_76170_();
                    if (!isSubmerged) continue;
                    if (currentState.m_60713_(Blocks.f_50191_) || currentState.m_60713_(CUT_VINE)) {
                        level.m_7731_(pos, Blocks.f_49990_.m_49966_(), 3);
                    }
                    if (!currentState.m_60713_(CHROMATIC_IRON_ORE) || !(random.nextFloat() < 0.2f)) continue;
                    level.m_7731_(pos, RAW_CHROMATIC_IRON_BLOCK.m_49966_(), 3);
                }
            }
        }
    }
}

