/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.mcjty_lib;

import mcjty.lib.api.infusable.CapabilityInfusable;
import mcjty.lib.base.GeneralConfig;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.tileentity.GenericTileEntity;
import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.config.IPluginConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import snownee.jade.addon.mcjty_lib.McjtyLibPlugin;

public enum BaseBlockProvider implements IComponentProvider,
IServerDataProvider<BlockEntity>
{
    INSTANCE;


    @OnlyIn(value=Dist.CLIENT)
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (!config.get(McjtyLibPlugin.GENERAL)) {
            return;
        }
        CompoundTag data = accessor.getServerData();
        if (data.m_128441_("Infused")) {
            tooltip.add((Component)new TranslatableComponent("jadeaddons.mcjtylib.infused", new Object[]{data.m_128451_("Infused")}));
        }
        if (data.m_128441_("SecurityChannel")) {
            int channel = data.m_128451_("SecurityChannel");
            String name = data.m_128461_("OwnerName");
            if (channel == -1) {
                tooltip.add((Component)new TranslatableComponent("jadeaddons.mcjtylib.ownedBy", new Object[]{name}));
            } else {
                tooltip.add((Component)new TranslatableComponent("jadeaddons.mcjtylib.ownedBy.withChannel", new Object[]{name, channel}));
            }
            if (data.m_128471_("OwnerWarning")) {
                tooltip.add((Component)new TranslatableComponent("jadeaddons.mcjtylib.ownedBy.warning").m_130940_(ChatFormatting.RED));
            }
        }
    }

    public void appendServerData(CompoundTag data, ServerPlayer player, Level level, BlockEntity blockEntity, boolean details) {
        GenericTileEntity generic;
        if (!(blockEntity.m_58900_().m_60734_() instanceof BaseBlock)) {
            return;
        }
        blockEntity.getCapability(CapabilityInfusable.INFUSABLE_CAPABILITY).ifPresent(h -> {
            int infused = h.getInfused();
            int pct = infused * 100 / (Integer)GeneralConfig.maxInfuse.get();
            data.m_128405_("Infused", pct);
        });
        if (((Boolean)GeneralConfig.manageOwnership.get()).booleanValue() && (generic = (GenericTileEntity)blockEntity).getOwnerName() != null && !generic.getOwnerName().isEmpty()) {
            data.m_128405_("SecurityChannel", generic.getSecurityChannel());
            data.m_128359_("OwnerName", generic.getOwnerName());
            if (generic.getOwnerUUID() == null) {
                data.m_128379_("OwnerWarning", true);
            }
        }
    }
}

