/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.tconstruct;

import com.google.common.base.Predicates;
import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.config.IPluginConfig;
import mcp.mobius.waila.api.ui.IElement;
import mcp.mobius.waila.api.ui.IElementHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.smeltery.block.component.SearedDuctBlock;
import slimeknights.tconstruct.smeltery.block.entity.component.DuctBlockEntity;
import snownee.jade.VanillaPlugin;
import snownee.jade.addon.tconstruct.TConstructPlugin;

public enum DrainProvider implements IComponentProvider
{
    INSTANCE;


    @OnlyIn(value=Dist.CLIENT)
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        Object matcher;
        if (!config.get(TConstructPlugin.DRAIN) || !accessor.getServerData().m_128441_("jadeTanks")) {
            return;
        }
        tooltip.remove(VanillaPlugin.FORGE_FLUID);
        tooltip.remove(VanillaPlugin.INVENTORY);
        FluidStack fluid = FluidStack.EMPTY;
        if (accessor.getBlock() instanceof SearedDuctBlock) {
            if (!(accessor.getBlockEntity() instanceof DuctBlockEntity)) {
                return;
            }
            DuctBlockEntity duct = (DuctBlockEntity)accessor.getBlockEntity();
            fluid = duct.getItemHandler().getFluid();
            matcher = arg_0 -> ((FluidStack)fluid).isFluidEqual(arg_0);
        } else {
            matcher = Predicates.alwaysTrue();
        }
        FluidStack target = FluidStack.EMPTY;
        for (Tag tag : accessor.getServerData().m_128437_("jadeTanks", 10)) {
            FluidStack fluid0 = FluidStack.loadFluidStackFromNBT((CompoundTag)((CompoundTag)tag));
            if (fluid0.isEmpty() || !matcher.test(fluid0)) continue;
            target = fluid0;
            break;
        }
        if (target.isEmpty() && accessor.getBlock() instanceof SearedDuctBlock) {
            target = fluid;
        }
        if (!target.isEmpty()) {
            IElementHelper elements = tooltip.getElementHelper();
            tooltip.add(elements.fluid(target));
            tooltip.append(elements.spacer(2, 0));
            tooltip.append(target.getDisplayName());
            IElement amount = target == fluid ? elements.text((Component)new TranslatableComponent("jade.fluid.empty")) : elements.text((Component)new TextComponent(TConstructPlugin.client.getDisplayHelper().humanReadableNumber((double)target.getAmount(), "B", true)));
            amount.size(new Vec2(amount.getSize().f_82470_ + 18.0f, 2.0f)).translate(new Vec2(18.0f, -7.0f));
            tooltip.add(amount);
        }
    }
}

