/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.info.type;

import com.probejs.info.type.ITypeInfo;
import com.probejs.info.type.InfoTypeResolver;
import com.probejs.info.type.TypeInfoClass;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.function.Function;

public class TypeInfoWildcard
implements ITypeInfo {
    private final ITypeInfo type;

    public static boolean test(Type type) {
        return type instanceof WildcardType;
    }

    public TypeInfoWildcard(Type type, Function<Type, Type> typeTransformer) {
        if (type instanceof WildcardType) {
            WildcardType wild = (WildcardType)type;
            Type[] upper = wild.getUpperBounds();
            Type[] lower = wild.getLowerBounds();
            if (upper[0] != Object.class) {
                this.type = InfoTypeResolver.resolveType(upper[0], typeTransformer);
                return;
            }
            if (lower.length != 0) {
                this.type = InfoTypeResolver.resolveType(lower[0], typeTransformer);
                return;
            }
        }
        this.type = new TypeInfoClass((Type)((Object)Object.class), typeTransformer);
    }

    private TypeInfoWildcard(ITypeInfo inner) {
        this.type = inner;
    }

    @Override
    public ITypeInfo getBaseType() {
        return this.type;
    }

    @Override
    public Class<?> getResolvedClass() {
        return this.type.getResolvedClass();
    }

    @Override
    public String getTypeName() {
        return this.type.getTypeName();
    }

    @Override
    public ITypeInfo copy() {
        return new TypeInfoWildcard(this.type.copy());
    }

    @Override
    public boolean assignableFrom(ITypeInfo info) {
        return info.getBaseType().assignableFrom(this.type);
    }
}

