/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.jdoc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.probejs.ProbeConfig;
import com.probejs.ProbeJS;
import com.probejs.ProbePaths;
import com.probejs.info.ClassInfo;
import com.probejs.jdoc.IConditional;
import com.probejs.jdoc.Serde;
import com.probejs.jdoc.document.AbstractDocument;
import com.probejs.jdoc.document.DocumentClass;
import com.probejs.jdoc.property.AbstractProperty;
import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;

public class Manager {
    private static boolean docsDownloaded = false;
    private static final String TIMESTAMP_API = "http://static.wolfgirl.moe/api/timestamp?path=probejs/docs-1.18.2.zip";
    private static final String DOWNLOAD_API = "http://static.wolfgirl.moe/object-service/checked/probejs/docs-1.18.2.zip?timestamp=%s";

    public static List<DocumentClass> loadJavaClasses(Set<Class<?>> classes) {
        ArrayList<DocumentClass> javaClasses = new ArrayList<DocumentClass>();
        for (Class<?> clazz : classes) {
            DocumentClass document = DocumentClass.fromJava(ClassInfo.getOrCache(clazz));
            javaClasses.add(document);
        }
        return javaClasses;
    }

    public static void downloadDocs() throws IOException {
        long remoteTimestamp;
        if (docsDownloaded) {
            return;
        }
        ProbeJS.LOGGER.info("Checking docs timestamps...");
        try {
            URL timestampApi = new URL(TIMESTAMP_API);
            BufferedReader in = new BufferedReader(new InputStreamReader(timestampApi.openStream()));
            remoteTimestamp = Long.parseLong(in.readLine());
        }
        catch (Exception e) {
            ProbeJS.LOGGER.warn("Cannot connect to remote server, docs are not checked or downloaded!");
            ProbeJS.LOGGER.warn("The server might come back online later, this is not an error.");
            return;
        }
        if (ProbeConfig.INSTANCE.docsTimestamp != remoteTimestamp) {
            ProbeJS.LOGGER.info("Found timestamp mismatch (local=%s, remote=%s), downloading docs from remote.".formatted(ProbeConfig.INSTANCE.docsTimestamp, remoteTimestamp));
            Path docsPath = ProbePaths.CACHE.resolve("docs");
            if (Files.exists(docsPath, new LinkOption[0])) {
                FileUtils.deleteDirectory((File)docsPath.toFile());
            }
            UtilsJS.tryIO(() -> Files.createDirectories(docsPath, new FileAttribute[0]));
            URL downloadUrl = new URL(DOWNLOAD_API.formatted(ProbeConfig.INSTANCE.docsTimestamp));
            ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(downloadUrl.openStream()));
            ZipEntry entry = zipInputStream.getNextEntry();
            byte[] buffer = new byte[1024];
            while (entry != null) {
                try (FileOutputStream outputStream = new FileOutputStream(docsPath.resolve(entry.getName()).toFile());){
                    int len;
                    while ((len = zipInputStream.read(buffer)) > 0) {
                        outputStream.write(buffer, 0, len);
                    }
                }
                ProbeJS.LOGGER.info("Downloaded doc: %s".formatted(entry.getName()));
                zipInputStream.closeEntry();
                entry = zipInputStream.getNextEntry();
            }
            ProbeConfig.INSTANCE.docsTimestamp = remoteTimestamp;
            ProbeConfig.INSTANCE.save();
        } else {
            ProbeJS.LOGGER.info("Timestamps are matched (local = remote = %s), no need to update docs.".formatted(remoteTimestamp));
        }
        docsDownloaded = true;
    }

    public static List<DocumentClass> loadFetchedClassDoc() throws IOException {
        ArrayList<DocumentClass> docs = new ArrayList<DocumentClass>();
        Path docsPath = ProbePaths.CACHE.resolve("docs");
        if (Files.exists(docsPath, new LinkOption[0])) {
            for (File file : Objects.requireNonNull(docsPath.toFile().listFiles())) {
                docs.addAll(Manager.loadJsonClassDoc(file.toPath()));
                ProbeJS.LOGGER.info("Loaded fetched doc: %s".formatted(file.getName()));
            }
        }
        return docs;
    }

    public static List<DocumentClass> loadJsonClassDoc(Path path) throws IOException {
        JsonObject docsObject = (JsonObject)ProbeJS.GSON.fromJson((Reader)Files.newBufferedReader(path), JsonObject.class);
        if (docsObject.has("properties")) {
            ArrayList properties = new ArrayList();
            Serde.deserializeDocuments(properties, docsObject.get("properties"));
            for (AbstractProperty property : properties) {
                IConditional condition;
                if (!(property instanceof IConditional) || (condition = (IConditional)((Object)property)).test()) continue;
                return List.of();
            }
        }
        JsonArray docsArray = docsObject.get("classes").getAsJsonArray();
        ArrayList<DocumentClass> documents = new ArrayList<DocumentClass>();
        for (JsonElement element : docsArray) {
            AbstractDocument<?> abstractDocument = Serde.deserializeDocument(element.getAsJsonObject());
            if (!(abstractDocument instanceof DocumentClass)) continue;
            DocumentClass documentClass = (DocumentClass)abstractDocument;
            documents.add(documentClass);
        }
        return documents;
    }

    public static List<DocumentClass> loadModDocuments() throws IOException {
        ArrayList<DocumentClass> documents = new ArrayList<DocumentClass>();
        for (Mod mod : Platform.getMods()) {
            Optional list = mod.findResource(new String[]{"probejs.documents.txt"});
            if (!list.isPresent()) continue;
            for (String entry : Files.lines((Path)list.get()).toList()) {
                if (!entry.endsWith(".json")) {
                    ProbeJS.LOGGER.warn("Skipping non-JsonDoc entry - %s".formatted(entry));
                    continue;
                }
                Optional entryPath = mod.findResource(new String[]{entry});
                if (entryPath.isPresent()) {
                    ProbeJS.LOGGER.info("Loading document inside jar - %s".formatted(entry));
                    List<DocumentClass> jsonDoc = Manager.loadJsonClassDoc((Path)entryPath.get());
                    documents.addAll(jsonDoc);
                    continue;
                }
                ProbeJS.LOGGER.warn("Document from file is not found - %s".formatted(entry));
            }
        }
        return documents;
    }

    public static List<DocumentClass> loadUserDocuments() throws IOException {
        ArrayList<DocumentClass> documents = new ArrayList<DocumentClass>();
        for (File file : Objects.requireNonNull(ProbePaths.DOCS.toFile().listFiles())) {
            if (!file.getName().endsWith(".json")) continue;
            Path path = Paths.get(file.toURI());
            documents.addAll(Manager.loadJsonClassDoc(path));
        }
        return documents;
    }

    @SafeVarargs
    public static Map<String, DocumentClass> mergeDocuments(List<DocumentClass> ... sources) {
        HashMap<String, DocumentClass> documents = new HashMap<String, DocumentClass>();
        for (List<DocumentClass> source : sources) {
            for (DocumentClass clazz : source) {
                if (!documents.containsKey(clazz.getName())) {
                    documents.put(clazz.getName(), clazz);
                    continue;
                }
                documents.put(clazz.getName(), ((DocumentClass)documents.get(clazz.getName())).merge(clazz));
            }
        }
        return documents;
    }
}

