/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.jdoc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.probejs.formatter.formatter.jdoc.FormatterType;
import com.probejs.formatter.formatter.jdoc.FormatterValue;
import com.probejs.info.type.ITypeInfo;
import com.probejs.info.type.TypeInfoArray;
import com.probejs.info.type.TypeInfoClass;
import com.probejs.info.type.TypeInfoParameterized;
import com.probejs.info.type.TypeInfoVariable;
import com.probejs.info.type.TypeInfoWildcard;
import com.probejs.jdoc.ISerde;
import com.probejs.jdoc.document.AbstractDocument;
import com.probejs.jdoc.document.DocumentClass;
import com.probejs.jdoc.document.DocumentConstructor;
import com.probejs.jdoc.document.DocumentField;
import com.probejs.jdoc.document.DocumentMethod;
import com.probejs.jdoc.property.AbstractProperty;
import com.probejs.jdoc.property.PropertyAssign;
import com.probejs.jdoc.property.PropertyComment;
import com.probejs.jdoc.property.PropertyHide;
import com.probejs.jdoc.property.PropertyModify;
import com.probejs.jdoc.property.PropertyParam;
import com.probejs.jdoc.property.PropertyReturns;
import com.probejs.jdoc.property.PropertyType;
import com.probejs.jdoc.property.PropertyUnderscored;
import com.probejs.jdoc.property.PropertyValue;
import com.probejs.jdoc.property.condition.PropertyMod;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public class Serde {
    public static void init() {
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyType.Array.class, (Object)"type:array");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyType.Clazz.class, (Object)"type:class");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyType.Parameterized.class, (Object)"type:parameterized");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyType.Variable.class, (Object)"type:variable");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyType.Native.class, (Object)"type:primitive");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyType.Intersection.class, (Object)"type:intersection");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyType.Union.class, (Object)"type:union");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyType.JSObject.class, (Object)"type:object");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyType.JSArray.class, (Object)"type:jsArray");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyComment.class, (Object)"property:comment");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyHide.class, (Object)"property:hide");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyMod.class, (Object)"property:mod");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyModify.class, (Object)"property:modify");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyReturns.class, (Object)"property:returns");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyParam.class, (Object)"property:param");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyAssign.class, (Object)"property:assign");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyUnderscored.class, (Object)"property:underscored");
        AbstractDocument.DOCUMENT_TYPE_REGISTRY.put(DocumentClass.class, (Object)"document:class");
        AbstractDocument.DOCUMENT_TYPE_REGISTRY.put(DocumentMethod.class, (Object)"document:method");
        AbstractDocument.DOCUMENT_TYPE_REGISTRY.put(DocumentField.class, (Object)"document:field");
        AbstractDocument.DOCUMENT_TYPE_REGISTRY.put(DocumentConstructor.class, (Object)"document:constructor");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyValue.NumberValue.class, (Object)"value:number");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyValue.BooleanValue.class, (Object)"value:boolean");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyValue.StringValue.class, (Object)"value:string");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyValue.CharacterValue.class, (Object)"value:character");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyValue.FallbackValue.class, (Object)"value:fallback");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyValue.NullValue.class, (Object)"value:null");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyValue.MapValue.class, (Object)"value:map");
        AbstractProperty.DOCUMENT_TYPE_REGISTRY.put(PropertyValue.ListValue.class, (Object)"value:list");
        PropertyValue.init();
        FormatterValue.init();
        FormatterType.init();
    }

    public static AbstractDocument<?> deserializeDocument(JsonObject obj) {
        String type = obj.get("type").getAsString();
        try {
            AbstractDocument doc = (AbstractDocument)((Class)AbstractDocument.DOCUMENT_TYPE_REGISTRY.inverse().get((Object)type)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            doc.deserialize(obj);
            return doc;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static AbstractProperty<?> deserializeProperty(JsonObject obj) {
        String type = obj.get("type").getAsString();
        try {
            AbstractProperty property = (AbstractProperty)((Class)AbstractProperty.DOCUMENT_TYPE_REGISTRY.inverse().get((Object)type)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            property.deserialize(obj);
            return property;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static PropertyType<?> constructType(Supplier<PropertyType<?>> builder, ITypeInfo type) {
        PropertyType<?> property = builder.get();
        property.fromJava(type);
        return property;
    }

    public static PropertyType<?> deserializeFromJavaType(ITypeInfo type, boolean insideType) {
        if (type instanceof TypeInfoClass) {
            TypeInfoClass clazz = (TypeInfoClass)type;
            if (!clazz.getTypeVariables().isEmpty() && !insideType) {
                return Serde.constructType(PropertyType.Parameterized::new, clazz);
            }
            return Serde.constructType(PropertyType.Clazz::new, clazz);
        }
        if (type instanceof TypeInfoArray) {
            return Serde.constructType(PropertyType.Array::new, type);
        }
        if (type instanceof TypeInfoVariable) {
            return Serde.constructType(PropertyType.Variable::new, type);
        }
        if (type instanceof TypeInfoParameterized) {
            return Serde.constructType(PropertyType.Parameterized::new, type);
        }
        if (type instanceof TypeInfoWildcard) {
            return Serde.constructType(PropertyType.Clazz::new, new TypeInfoClass(Object.class));
        }
        return null;
    }

    public static PropertyType<?> deserializeFromJavaType(ITypeInfo type) {
        return Serde.deserializeFromJavaType(type, false);
    }

    public static void serializeCollection(JsonObject object, String key, Iterable<? extends ISerde> serdes) {
        Serde.serializeCollection(object, key, serdes, false);
    }

    public static void serializeCollection(JsonObject object, String key, Iterable<? extends ISerde> serdes, boolean skipIfEmpty) {
        if (serdes == null) {
            return;
        }
        JsonArray result = new JsonArray();
        serdes.forEach(serde -> result.add((JsonElement)serde.serialize()));
        if (result.isEmpty() && skipIfEmpty) {
            return;
        }
        object.add(key, (JsonElement)result);
    }

    public static <T extends AbstractDocument<?>> void deserializeDocuments(Collection<T> serdes, JsonElement jsonArray) {
        if (jsonArray == null || serdes == null) {
            return;
        }
        for (JsonElement element : jsonArray.getAsJsonArray()) {
            AbstractDocument<?> document = Serde.deserializeDocument(element.getAsJsonObject());
            if (document == null || !document.fulfillsConditions()) continue;
            serdes.add(document);
        }
    }

    public static PropertyValue<?, ?> getValueProperty(Object o) {
        if (o == null) {
            return new PropertyValue.NullValue();
        }
        Function<Object, PropertyValue<?, ?>> constructor = PropertyValue.VALUES_REGISTRY.get(o.getClass());
        if (constructor != null) {
            return constructor.apply(o);
        }
        for (Map.Entry<Class<?>, Function<Object, PropertyValue<?, ?>>> entry : PropertyValue.VALUES_REGISTRY.entrySet()) {
            Class<?> clazz = entry.getKey();
            Function<Object, PropertyValue<?, ?>> subConstructor = entry.getValue();
            if (!clazz.isAssignableFrom(o.getClass())) continue;
            return subConstructor.apply(o);
        }
        return new PropertyValue.FallbackValue(o);
    }

    public static FormatterValue<?, ?> getValueFormatter(PropertyValue<?, ?> property) {
        Function<PropertyValue<?, ?>, FormatterValue<?, ?>> constructor = FormatterValue.VALUE_FORMATTERS_REGISTRY.get(property.getClass());
        if (constructor != null) {
            return constructor.apply(property);
        }
        return null;
    }

    public static FormatterType<?> getTypeFormatter(PropertyType<?> type) {
        Function<PropertyType<?>, FormatterType<?>> constructor = FormatterType.FORMATTER_REGISTRY.get(type.getClass());
        if (constructor != null) {
            return constructor.apply(type);
        }
        return new FormatterType.Native(new PropertyType.Native("any"));
    }

    public static JsonElement getPrimitive(Object o) {
        if (o instanceof Boolean) {
            Boolean bool = (Boolean)o;
            return new JsonPrimitive(bool);
        }
        if (o instanceof String) {
            String string = (String)o;
            return new JsonPrimitive(string);
        }
        if (o instanceof Number) {
            Number number = (Number)o;
            return new JsonPrimitive(number);
        }
        if (o instanceof Character) {
            Character character = (Character)o;
            return new JsonPrimitive(character);
        }
        throw new IllegalArgumentException("The argument is not primitive type!");
    }

    public static Object getAsPrimitive(JsonElement element) {
        JsonPrimitive primitive = element.getAsJsonPrimitive();
        if (primitive.isBoolean()) {
            return primitive.getAsBoolean();
        }
        if (primitive.isNumber()) {
            return primitive.getAsNumber();
        }
        if (primitive.isString()) {
            return primitive.getAsString();
        }
        throw new IllegalArgumentException("The argument is not primitive value!");
    }
}

