/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.jdoc.document;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.probejs.info.ClassInfo;
import com.probejs.jdoc.Serde;
import com.probejs.jdoc.document.AbstractDocument;
import com.probejs.jdoc.document.DocumentConstructor;
import com.probejs.jdoc.document.DocumentField;
import com.probejs.jdoc.document.DocumentMethod;
import com.probejs.jdoc.property.PropertyType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class DocumentClass
extends AbstractDocument<DocumentClass> {
    protected String name;
    protected List<PropertyType<?>> generics = new ArrayList();
    protected PropertyType<?> parent;
    protected Set<PropertyType<?>> interfaces = new HashSet();
    protected Set<DocumentField> fields = new HashSet<DocumentField>();
    protected Set<DocumentMethod> methods = new HashSet<DocumentMethod>();
    protected Set<DocumentConstructor> constructors = new HashSet<DocumentConstructor>();
    protected boolean isAbstract = false;
    protected boolean isInterface = false;

    @Override
    public JsonObject serialize() {
        JsonObject object = super.serialize();
        object.addProperty("className", this.name);
        if (this.parent != null) {
            object.add("parent", (JsonElement)this.parent.serialize());
        }
        Serde.serializeCollection(object, "fields", this.fields);
        Serde.serializeCollection(object, "methods", this.methods);
        Serde.serializeCollection(object, "variables", this.generics, true);
        Serde.serializeCollection(object, "interfaces", this.interfaces, true);
        Serde.serializeCollection(object, "constructors", this.constructors);
        return object;
    }

    @Override
    public void deserialize(JsonObject object) {
        super.deserialize(object);
        this.name = object.get("className").getAsString();
        if (object.has("parent")) {
            this.parent = (PropertyType)Serde.deserializeProperty(object.get("parent").getAsJsonObject());
        }
        Serde.deserializeDocuments(this.fields, object.get("fields"));
        Serde.deserializeDocuments(this.methods, object.get("methods"));
        Serde.deserializeDocuments(this.constructors, object.get("constructors"));
        Serde.deserializeDocuments(this.generics, object.get("variables"));
        Serde.deserializeDocuments(this.interfaces, object.get("interfaces"));
    }

    public static DocumentClass fromJava(ClassInfo info) {
        DocumentClass document = new DocumentClass();
        document.name = info.getName();
        document.isAbstract = info.isAbstract();
        document.isInterface = info.isInterface();
        document.parent = info.getSuperClass() != null ? Serde.deserializeFromJavaType(info.getSuperClassType()) : null;
        document.interfaces.addAll(info.getInterfaceTypes().stream().map(Serde::deserializeFromJavaType).toList());
        document.generics.addAll(info.getParameters().stream().map(Serde::deserializeFromJavaType).toList());
        info.getFieldInfo().stream().map(DocumentField::fromJava).forEach(document.fields::add);
        info.getMethodInfo().stream().map(DocumentMethod::fromJava).forEach(document.methods::add);
        info.getConstructorInfo().stream().map(DocumentConstructor::fromJava).forEach(document.constructors::add);
        return document;
    }

    @Override
    public DocumentClass applyProperties() {
        return this;
    }

    @Override
    public DocumentClass merge(DocumentClass other) {
        if (this == other) {
            return this;
        }
        DocumentClass document = other.copy();
        document.parent = this.parent;
        document.interfaces.addAll(this.interfaces);
        document.methods.addAll(this.methods);
        document.fields.addAll(this.fields);
        document.properties.addAll(this.properties);
        document.constructors = this.constructors;
        document.generics = this.generics;
        document.isInterface = this.isInterface;
        document.isAbstract = this.isAbstract;
        document.builtinComments.addAll(this.builtinComments);
        return document;
    }

    @Override
    public DocumentClass copy() {
        DocumentClass document = new DocumentClass();
        document.name = this.name;
        document.parent = this.parent;
        document.isInterface = this.isInterface;
        document.isAbstract = this.isAbstract;
        document.interfaces.addAll(this.interfaces);
        document.properties.addAll(this.properties);
        document.methods.addAll(this.methods);
        document.fields.addAll(this.fields);
        document.builtinComments.addAll(this.builtinComments);
        return document;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentClass that = (DocumentClass)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String getName() {
        return this.name;
    }

    public Set<DocumentConstructor> getConstructors() {
        return this.constructors;
    }

    public Set<DocumentMethod> getMethods() {
        return this.methods;
    }

    public Set<DocumentField> getFields() {
        return this.fields;
    }

    public Set<PropertyType<?>> getInterfaces() {
        return this.interfaces;
    }

    public List<PropertyType<?>> getGenerics() {
        return this.generics;
    }

    public PropertyType<?> getParent() {
        return this.parent;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isInterface() {
        return this.isInterface;
    }
}

