/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.jdoc.document;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.probejs.info.FieldInfo;
import com.probejs.jdoc.Serde;
import com.probejs.jdoc.document.AbstractDocument;
import com.probejs.jdoc.property.PropertyType;
import com.probejs.jdoc.property.PropertyValue;
import dev.latvian.mods.rhino.util.RemapForJS;
import java.lang.annotation.Annotation;
import java.util.Objects;

public class DocumentField
extends AbstractDocument<DocumentField> {
    private String name;
    private boolean isStatic;
    private boolean isFinal;
    private boolean shouldGSON = false;
    private PropertyType<?> type;
    private PropertyValue<?, ?> value;

    @Override
    public JsonObject serialize() {
        JsonObject object = super.serialize();
        object.addProperty("name", this.name);
        object.addProperty("static", Boolean.valueOf(this.isStatic));
        object.addProperty("final", Boolean.valueOf(this.isFinal));
        object.add("fieldType", (JsonElement)this.type.serialize());
        if (this.value != null) {
            object.add("value", (JsonElement)this.value.serialize());
        }
        return object;
    }

    @Override
    public void deserialize(JsonObject object) {
        super.deserialize(object);
        this.name = object.get("name").getAsString();
        if (object.has("static")) {
            this.isStatic = object.get("static").getAsBoolean();
        }
        if (object.has("final")) {
            this.isFinal = object.get("final").getAsBoolean();
        }
        this.type = (PropertyType)Serde.deserializeProperty(object.get("fieldType").getAsJsonObject());
        if (object.has("value")) {
            this.value = (PropertyValue)Serde.deserializeProperty(object.get("value").getAsJsonObject());
        }
    }

    public static DocumentField fromJava(FieldInfo info) {
        DocumentField document = new DocumentField();
        document.name = info.getName();
        document.isFinal = info.isFinal();
        document.isStatic = info.isStatic();
        document.type = Serde.deserializeFromJavaType(info.getType());
        document.shouldGSON = true;
        if (info.getStaticValue() != null) {
            document.value = Serde.getValueProperty(info.getStaticValue());
        }
        info.getAnnotations().stream().filter(annotation -> !(annotation instanceof RemapForJS)).map(Annotation::toString).forEach(document.builtinComments::add);
        return document;
    }

    @Override
    public DocumentField applyProperties() {
        return this;
    }

    @Override
    public DocumentField copy() {
        DocumentField document = new DocumentField();
        document.name = this.name;
        document.isStatic = this.isStatic;
        document.isFinal = this.isFinal;
        document.shouldGSON = this.shouldGSON;
        document.type = this.type;
        document.properties.addAll(this.properties);
        return document;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentField that = (DocumentField)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    public String getName() {
        return this.name;
    }

    public PropertyType<?> getType() {
        return this.type;
    }

    public PropertyValue<?, ?> getValue() {
        return this.value;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isShouldGSON() {
        return this.shouldGSON;
    }
}

