/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.jdoc.property;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.probejs.info.MethodInfo;
import com.probejs.jdoc.Serde;
import com.probejs.jdoc.property.AbstractProperty;
import com.probejs.jdoc.property.PropertyType;
import java.util.Objects;

public class PropertyParam
extends AbstractProperty<PropertyParam> {
    private String name;
    private PropertyType<?> type;
    private boolean varArg;

    public PropertyParam(String name, PropertyType<?> type, boolean isVarArg) {
        this.name = name;
        this.type = type;
        this.varArg = isVarArg;
    }

    public PropertyParam() {
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = super.serialize();
        object.addProperty("name", this.name);
        object.add("paramType", (JsonElement)this.type.serialize());
        object.addProperty("varArg", Boolean.valueOf(this.varArg));
        return object;
    }

    @Override
    public void deserialize(JsonObject object) {
        this.name = object.get("name").getAsString();
        this.type = (PropertyType)Serde.deserializeProperty(object.get("paramType").getAsJsonObject());
        if (object.has("varArg")) {
            this.varArg = object.get("varArg").getAsBoolean();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyParam that = (PropertyParam)o;
        return Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.type);
    }

    public PropertyType<?> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public static PropertyParam fromJava(MethodInfo.ParamInfo info) {
        PropertyParam param = new PropertyParam();
        param.name = info.getName();
        param.type = Serde.deserializeFromJavaType(info.getType());
        param.varArg = info.isVararg();
        return param;
    }

    @Override
    public PropertyParam copy() {
        return new PropertyParam(this.name, this.type, this.varArg);
    }

    public boolean isVarArg() {
        return this.varArg;
    }
}

