/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.javd.util;

import com.unrealdinnerbone.javd.JAVD;
import com.unrealdinnerbone.javd.JAVDRegistry;
import com.unrealdinnerbone.javd.block.PortalBlock;
import com.unrealdinnerbone.javd.block.PortalTileEntity;
import com.unrealdinnerbone.javd.util.SimpleTeleporter;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.ITeleporter;

public class TelerportUtils {
    public static void teleport(Block clickedBlock, Player playerEntity, Level toWorld, BlockPos blockPos, boolean spawnPlatform) throws RuntimeException {
        if (!toWorld.m_5776_() && playerEntity.f_19853_ instanceof ServerLevel && toWorld instanceof ServerLevel) {
            BlockPos portalLocation = TelerportUtils.findPortalLocation(toWorld, blockPos).orElseThrow(() -> new RuntimeException("Cant find location to spawn portal"));
            if (toWorld.m_8055_(portalLocation).m_60795_()) {
                Block block = Registry.f_122824_.m_203431_(JAVD.GENERATOR_BLOCKS).map(named -> named.m_203450_(toWorld.m_5822_())).filter(Optional::isPresent).map(Optional::get).map(Holder::m_203334_).orElse(Blocks.f_50069_);
                if (spawnPlatform && toWorld.m_8055_(portalLocation).m_60795_()) {
                    int range = (Integer)JAVD.PLATFORM_RANGE.get();
                    BlockPos.m_121990_((BlockPos)portalLocation.m_142082_(range, 0, range), (BlockPos)portalLocation.m_142082_(-range, 0, -range)).forEach(blockPos1 -> {
                        if (toWorld.m_8055_(blockPos1).m_60795_()) {
                            toWorld.m_46597_(blockPos1, block.m_49966_());
                        }
                    });
                }
                toWorld.m_46597_(portalLocation, ((PortalBlock)JAVDRegistry.PORTAL_BLOCK.get()).m_49966_());
            }
            playerEntity.changeDimension((ServerLevel)toWorld, (ITeleporter)new SimpleTeleporter(portalLocation.m_123341_(), portalLocation.m_7494_().m_123342_(), portalLocation.m_123343_()));
        }
    }

    private static Optional<BlockPos> findPortalLocation(Level worldTo, BlockPos fromPos) {
        if (worldTo.m_8055_(fromPos).m_60734_() == JAVDRegistry.PORTAL_BLOCK.get() && TelerportUtils.isSafeSpawnLocation(worldTo, fromPos)) {
            return Optional.of(fromPos.m_7494_());
        }
        int range = 5;
        return Optional.ofNullable(ChunkPos.m_45596_((ChunkPos)worldTo.m_46745_(fromPos).m_7697_(), (int)range).map(chunkPos -> worldTo.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_).m_5928_()).flatMap(Collection::stream).collect(Collectors.toList()).stream().filter(pos -> worldTo.m_7702_(pos) instanceof PortalTileEntity).findFirst().orElseGet(() -> {
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(0, 0, 0);
            for (int y = worldTo.m_141937_(); y < worldTo.m_151558_(); ++y) {
                for (int x = fromPos.m_123341_() - 6; x < fromPos.m_123341_() + 6; ++x) {
                    for (int z = fromPos.m_123343_() - 6; z < fromPos.m_123343_() + 6; ++z) {
                        mutableBlockPos.m_122178_(x, y, z);
                        BlockState blockState = worldTo.m_8055_((BlockPos)mutableBlockPos);
                        if (!blockState.m_60795_() || !TelerportUtils.isSafeSpawnLocation(worldTo, mutableBlockPos.m_7494_())) continue;
                        return mutableBlockPos;
                    }
                }
            }
            return null;
        }));
    }

    private static boolean isSafeSpawnLocation(Level world, BlockPos blockPos) {
        return world.m_8055_(blockPos).m_60795_() && world.m_8055_(blockPos.m_7494_()).m_60795_();
    }
}

