/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.vaultbeacon;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import com.shiftthedev.vaultbeacon.VaultBeaconClient;
import com.shiftthedev.vaultbeacon.commands.ReloadConfigCommand;
import com.shiftthedev.vaultbeacon.config.VBConfig;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.slf4j.Logger;

@Mod(value="vaultbeacon")
public class VaultBeacon {
    public static final String MOD_ID = "vaultbeacon";
    public static final Logger LOGGER = LogUtils.getLogger();

    public VaultBeacon() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, this::registerCommand);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, VaultBeaconClient::registerClientCommand);
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        VBConfig.initConfigs();
    }

    private void registerCommand(RegisterCommandsEvent event) {
        ReloadConfigCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static ResourceLocation id(String name) {
        return new ResourceLocation(MOD_ID, name);
    }
}

