/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.vaultbeacon.blocks.beacon;

import com.shiftthedev.vaultbeacon.VBRegistry;
import com.shiftthedev.vaultbeacon.blocks.beacon.VaultBeaconBlock;
import com.shiftthedev.vaultbeacon.blocks.beacon.VaultBeaconHelper;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.PlayerReference;
import iskallia.vault.world.data.PlayerResearchesData;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class VaultBeaconBlockEntity
extends BlockEntity {
    public static final Set<Block> VALID_BASE_BLOCKS = new HashSet<Block>();
    private int levels;
    private int lastCheckY;
    private UUID owner;
    private boolean isLocked = false;
    private boolean isActive = false;
    private ItemStack itemStack = ItemStack.f_41583_;
    public boolean catalystsFound = false;
    public int jumpLevel = 0;
    public int speedLevel = 0;
    public int hasteLevel = 0;
    public int regenLevel = 0;
    public int saturationLevel = 0;
    public int resistanceLevel = 0;
    public int strengthLevel = 0;
    public int rangeLevel = 0;

    public VaultBeaconBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(VBRegistry.VAULT_BEACON_BLOCK_ENTITY_BLOCK_ENTITY_TYPE, blockPos, blockState);
    }

    public InteractionResult tryRemoveCrystal(Level level, Player player, BlockState blockState) {
        if (this.itemStack.m_41619_()) {
            return InteractionResult.FAIL;
        }
        if (!player.m_36356_(this.itemStack)) {
            return InteractionResult.FAIL;
        }
        this.itemStack = ItemStack.f_41583_;
        this.isActive = false;
        this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)VaultBeaconBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
        this.markUpdated();
        return InteractionResult.SUCCESS;
    }

    public InteractionResult tryAddCrystal(Level level, Player player, InteractionHand hand, BlockState blockState) {
        if (this.f_58857_ == null) {
            return InteractionResult.FAIL;
        }
        if (!this.itemStack.m_41619_()) {
            return InteractionResult.FAIL;
        }
        ItemStack handStack = player.m_21120_(hand);
        if (!handStack.m_150930_((Item)ModItems.VAULT_CRYSTAL)) {
            return InteractionResult.FAIL;
        }
        this.itemStack = handStack;
        this.isActive = true;
        player.m_150109_().m_36057_(handStack);
        this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)VaultBeaconBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
        this.markUpdated();
        return InteractionResult.SUCCESS;
    }

    public void tryToggleLock(ServerPlayer player) {
        this.isLocked = !this.isLocked;
        this.markUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwner(UUID owner) {
        if (this.owner != null) {
            return;
        }
        VaultBeaconBlockEntity vaultBeaconBlockEntity = this;
        synchronized (vaultBeaconBlockEntity) {
            this.owner = owner;
        }
    }

    public boolean isActive() {
        return this.isActive && !this.itemStack.m_41619_();
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public ItemStack getCrystal() {
        return this.itemStack;
    }

    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)VaultBeaconBlock.FACING);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, VaultBeaconBlockEntity blockEntity) {
        int x = blockPos.m_123341_();
        int y = blockPos.m_123342_();
        int z = blockPos.m_123343_();
        int j1 = blockEntity.levels;
        if (level.m_46467_() % 80L == 0L) {
            blockEntity.levels = VaultBeaconHelper.updateBase(level, x, y, z, blockEntity);
            if (blockEntity.levels > 0 && blockEntity.isActive && blockEntity.catalystsFound) {
                VaultBeaconBlockEntity.applyEffects(level, blockPos, blockEntity);
                VaultBeaconBlockEntity.playSound(level, blockPos, SoundEvents.f_11737_);
            }
        }
    }

    private static void applyEffects(Level level, BlockPos blockPos, VaultBeaconBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        int duration = 300;
        double d0 = (blockEntity.levels * 10 + 10) * (blockEntity.rangeLevel + 1);
        AABB aabb = new AABB(blockPos).m_82400_(d0).m_82363_(0.0, (double)level.m_141928_(), 0.0).m_82363_(0.0, (double)(-level.m_141928_()), 0.0);
        List list = level.m_45976_(Player.class, aabb);
        for (Player player : list) {
            if (blockEntity.hasteLevel > 0) {
                VaultBeaconBlockEntity.applyEffect(blockEntity, player, MobEffects.f_19598_, duration, blockEntity.hasteLevel - 1);
            }
            if (blockEntity.jumpLevel > 0) {
                VaultBeaconBlockEntity.applyEffect(blockEntity, player, MobEffects.f_19603_, duration, blockEntity.jumpLevel - 1);
            }
            if (blockEntity.regenLevel > 0) {
                VaultBeaconBlockEntity.applyEffect(blockEntity, player, MobEffects.f_19605_, duration, blockEntity.regenLevel - 1);
            }
            if (blockEntity.resistanceLevel > 0) {
                VaultBeaconBlockEntity.applyEffect(blockEntity, player, MobEffects.f_19606_, duration, blockEntity.resistanceLevel - 1);
            }
            if (blockEntity.saturationLevel > 0) {
                VaultBeaconBlockEntity.applyEffect(blockEntity, player, MobEffects.f_19618_, duration, blockEntity.saturationLevel - 1);
            }
            if (blockEntity.speedLevel > 0) {
                VaultBeaconBlockEntity.applyEffect(blockEntity, player, MobEffects.f_19596_, duration, blockEntity.speedLevel - 1);
            }
            if (blockEntity.strengthLevel <= 0) continue;
            VaultBeaconBlockEntity.applyEffect(blockEntity, player, MobEffects.f_19600_, duration, blockEntity.strengthLevel - 1);
        }
    }

    private static void applyEffect(VaultBeaconBlockEntity blockEntity, Player player, MobEffect effect, int duration, int level) {
        if (!blockEntity.isLocked) {
            player.m_7292_(new MobEffectInstance(effect, duration, level, true, true));
            return;
        }
        if (player.m_142081_().equals(blockEntity.owner)) {
            player.m_7292_(new MobEffectInstance(effect, duration, level, true, true));
            return;
        }
        PlayerResearchesData data = PlayerResearchesData.get((ServerLevel)((ServerLevel)player.f_19853_));
        if (!data.isInTeam(player.m_142081_())) {
            return;
        }
        if (data.getTeamMembers(blockEntity.owner).stream().map(PlayerReference::getId).anyMatch(id -> id.equals(player.m_142081_()))) {
            player.m_7292_(new MobEffectInstance(effect, duration, level, true, true));
        }
    }

    public void m_7651_() {
        VaultBeaconBlockEntity.playSound(this.f_58857_, this.f_58858_, SoundEvents.f_11738_);
        super.m_7651_();
    }

    private static void playSound(Level p_155104_, BlockPos p_155105_, SoundEvent p_155106_) {
        p_155104_.m_5594_((Player)null, p_155105_, p_155106_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("lastCheckY")) {
            this.lastCheckY = tag.m_128451_("lastCheckY");
        }
        if (tag.m_128441_("isActive")) {
            this.isActive = tag.m_128471_("isActive");
            this.itemStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("itemStack"));
        }
        if (tag.m_128441_("owner")) {
            this.owner = tag.m_128342_("owner");
        }
        if (tag.m_128441_("locked")) {
            this.isLocked = tag.m_128471_("locked");
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.owner != null) {
            tag.m_128362_("owner", this.owner);
        }
        tag.m_128379_("locked", this.isLocked);
        tag.m_128405_("lastCheckY", this.lastCheckY);
        tag.m_128379_("isActive", this.isActive);
        if (!this.itemStack.m_41619_()) {
            CompoundTag stackTag = new CompoundTag();
            this.itemStack.m_41739_(stackTag);
            tag.m_128365_("itemStack", (Tag)stackTag);
        }
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        this.lastCheckY = level.m_141937_() - 1;
    }

    private void markUpdated() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        assert (this.f_58857_ != null);
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.f_58857_.m_46473_().m_7238_();
    }

    static {
        Collections.addAll(VALID_BASE_BLOCKS, ModBlocks.VAULT_DIAMOND_BLOCK, ModBlocks.CHROMATIC_IRON_BLOCK, ModBlocks.CHROMATIC_STEEL_BLOCK, ModBlocks.BLACK_CHROMATIC_STEEL_BLOCK);
    }
}

