/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.vaultbeacon.blocks.beacon;

import com.shiftthedev.vaultbeacon.VBRegistry;
import com.shiftthedev.vaultbeacon.blocks.VaultBeaconCatalyst;
import com.shiftthedev.vaultbeacon.blocks.beacon.VaultBeaconBlockEntity;
import com.shiftthedev.vaultbeacon.config.VBConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class VaultBeaconHelper {
    public static int updateBase(Level level, int x, int y, int z, VaultBeaconBlockEntity blockEntity) {
        blockEntity.hasteLevel = 0;
        blockEntity.jumpLevel = 0;
        blockEntity.regenLevel = 0;
        blockEntity.resistanceLevel = 0;
        blockEntity.saturationLevel = 0;
        blockEntity.speedLevel = 0;
        blockEntity.strengthLevel = 0;
        blockEntity.rangeLevel = 0;
        blockEntity.catalystsFound = false;
        return switch (blockEntity.getDirection()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> VaultBeaconHelper.updateBaseUp(level, x, y, z, blockEntity);
            case Direction.DOWN -> VaultBeaconHelper.updateBaseDown(level, x, y, z, blockEntity);
            case Direction.NORTH -> VaultBeaconHelper.updateBaseNorth(level, x, y, z, blockEntity);
            case Direction.SOUTH -> VaultBeaconHelper.updateBaseSouth(level, x, y, z, blockEntity);
            case Direction.EAST -> VaultBeaconHelper.updateBaseEast(level, x, y, z, blockEntity);
            case Direction.WEST -> VaultBeaconHelper.updateBaseWest(level, x, y, z, blockEntity);
        };
    }

    private static int updateBaseUp(Level level, int x, int y, int z, VaultBeaconBlockEntity blockEntity) {
        int y1;
        int size = 0;
        int i = 1;
        while (i <= 4 && (y1 = y - i) >= level.m_141937_()) {
            boolean valid = true;
            block1: for (int x1 = x - i; x1 <= x + i; ++x1) {
                for (int z1 = z - i; z1 <= z + i; ++z1) {
                    BlockState baseBlock = level.m_8055_(new BlockPos(x1, y1, z1));
                    if (VaultBeaconBlockEntity.VALID_BASE_BLOCKS.contains(baseBlock.m_60734_())) continue;
                    if (baseBlock.m_60734_() instanceof VaultBeaconCatalyst) {
                        VaultBeaconHelper.updateCatalysts(baseBlock.m_60734_(), blockEntity);
                        continue;
                    }
                    valid = false;
                    continue block1;
                }
            }
            if (!valid) break;
            size = i++;
        }
        return size;
    }

    private static int updateBaseDown(Level level, int x, int y, int z, VaultBeaconBlockEntity blockEntity) {
        int y1;
        int size = 0;
        int i = 1;
        while (i <= 4 && (y1 = y + i) <= level.m_151558_()) {
            boolean valid = true;
            block1: for (int x1 = x - i; x1 <= x + i; ++x1) {
                for (int z1 = z - i; z1 <= z + i; ++z1) {
                    BlockState baseBlock = level.m_8055_(new BlockPos(x1, y1, z1));
                    if (VaultBeaconBlockEntity.VALID_BASE_BLOCKS.contains(baseBlock.m_60734_())) continue;
                    if (baseBlock.m_60734_() instanceof VaultBeaconCatalyst) {
                        VaultBeaconHelper.updateCatalysts(baseBlock.m_60734_(), blockEntity);
                        continue;
                    }
                    valid = false;
                    continue block1;
                }
            }
            if (!valid) break;
            size = i++;
        }
        return size;
    }

    private static int updateBaseNorth(Level level, int x, int y, int z, VaultBeaconBlockEntity blockEntity) {
        int size = 0;
        int i = 1;
        while (i <= 4) {
            int z1 = z + i;
            if (!level.m_6857_().m_61937_(new BlockPos(x, y, z1))) break;
            boolean valid = true;
            block1: for (int y1 = y - i; y1 <= y + i; ++y1) {
                for (int x1 = x - i; x1 <= x + i; ++x1) {
                    BlockState baseBlock = level.m_8055_(new BlockPos(x1, y1, z1));
                    if (VaultBeaconBlockEntity.VALID_BASE_BLOCKS.contains(baseBlock.m_60734_())) continue;
                    if (baseBlock.m_60734_() instanceof VaultBeaconCatalyst) {
                        VaultBeaconHelper.updateCatalysts(baseBlock.m_60734_(), blockEntity);
                        continue;
                    }
                    valid = false;
                    continue block1;
                }
            }
            if (!valid) break;
            size = i++;
        }
        return size;
    }

    private static int updateBaseSouth(Level level, int x, int y, int z, VaultBeaconBlockEntity blockEntity) {
        int size = 0;
        int i = 1;
        while (i <= 4) {
            int z1 = z - i;
            if (!level.m_6857_().m_61937_(new BlockPos(x, y, z1))) break;
            boolean valid = true;
            block1: for (int y1 = y - i; y1 <= y + i; ++y1) {
                for (int x1 = x - i; x1 <= x + i; ++x1) {
                    BlockState baseBlock = level.m_8055_(new BlockPos(x1, y1, z1));
                    if (VaultBeaconBlockEntity.VALID_BASE_BLOCKS.contains(baseBlock.m_60734_())) continue;
                    if (baseBlock.m_60734_() instanceof VaultBeaconCatalyst) {
                        VaultBeaconHelper.updateCatalysts(baseBlock.m_60734_(), blockEntity);
                        continue;
                    }
                    valid = false;
                    continue block1;
                }
            }
            if (!valid) break;
            size = i++;
        }
        return size;
    }

    private static int updateBaseEast(Level level, int x, int y, int z, VaultBeaconBlockEntity blockEntity) {
        int size = 0;
        int i = 1;
        while (i <= 4) {
            int x1 = x - i;
            if (!level.m_6857_().m_61937_(new BlockPos(x1, y, z))) break;
            boolean valid = true;
            block1: for (int y1 = y - i; y1 <= y + i; ++y1) {
                for (int z1 = z - i; z1 <= z + i; ++z1) {
                    BlockState baseBlock = level.m_8055_(new BlockPos(x1, y1, z1));
                    if (VaultBeaconBlockEntity.VALID_BASE_BLOCKS.contains(baseBlock.m_60734_())) continue;
                    if (baseBlock.m_60734_() instanceof VaultBeaconCatalyst) {
                        VaultBeaconHelper.updateCatalysts(baseBlock.m_60734_(), blockEntity);
                        continue;
                    }
                    valid = false;
                    continue block1;
                }
            }
            if (!valid) break;
            size = i++;
        }
        return size;
    }

    private static int updateBaseWest(Level level, int x, int y, int z, VaultBeaconBlockEntity blockEntity) {
        int size = 0;
        int i = 1;
        while (i <= 4) {
            int x1 = x + i;
            if (!level.m_6857_().m_61937_(new BlockPos(x1, y, z))) break;
            boolean valid = true;
            block1: for (int y1 = y - i; y1 <= y + i; ++y1) {
                for (int z1 = z - i; z1 <= z + i; ++z1) {
                    BlockState baseBlock = level.m_8055_(new BlockPos(x1, y1, z1));
                    if (VaultBeaconBlockEntity.VALID_BASE_BLOCKS.contains(baseBlock.m_60734_())) continue;
                    if (baseBlock.m_60734_() instanceof VaultBeaconCatalyst) {
                        VaultBeaconHelper.updateCatalysts(baseBlock.m_60734_(), blockEntity);
                        continue;
                    }
                    valid = false;
                    continue block1;
                }
            }
            if (!valid) break;
            size = i++;
        }
        return size;
    }

    private static void updateCatalysts(Block block, VaultBeaconBlockEntity blockEntity) {
        if (VBRegistry.HASTE_CATALYST.contains(block) && blockEntity.hasteLevel < VBConfig.SETTINGS.MaxHaste()) {
            ++blockEntity.hasteLevel;
            blockEntity.catalystsFound = true;
        }
        if (VBRegistry.JUMP_CATALYST.contains(block) && blockEntity.jumpLevel < VBConfig.SETTINGS.MaxJump()) {
            ++blockEntity.jumpLevel;
            blockEntity.catalystsFound = true;
        }
        if (VBRegistry.REGEN_CATALYST.contains(block) && blockEntity.regenLevel < VBConfig.SETTINGS.MaxRegen()) {
            ++blockEntity.regenLevel;
            blockEntity.catalystsFound = true;
        }
        if (VBRegistry.RESISTANCE_CATALYST.contains(block) && blockEntity.resistanceLevel < VBConfig.SETTINGS.MaxResistance()) {
            ++blockEntity.resistanceLevel;
            blockEntity.catalystsFound = true;
        }
        if (VBRegistry.SATURATION_CATALYST.contains(block) && blockEntity.saturationLevel < VBConfig.SETTINGS.MaxSaturation()) {
            ++blockEntity.saturationLevel;
            blockEntity.catalystsFound = true;
        }
        if (VBRegistry.SPEED_CATALYST.contains(block) && blockEntity.speedLevel < VBConfig.SETTINGS.MaxSpeed()) {
            ++blockEntity.speedLevel;
            blockEntity.catalystsFound = true;
        }
        if (VBRegistry.STRENGTH_CATALYST.contains(block) && blockEntity.strengthLevel < VBConfig.SETTINGS.MaxStrength()) {
            ++blockEntity.strengthLevel;
            blockEntity.catalystsFound = true;
        }
        if (VBRegistry.RANGE_CATALYST.contains(block) && blockEntity.rangeLevel < VBConfig.SETTINGS.MaxRange()) {
            ++blockEntity.rangeLevel;
        }
    }
}

