/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.vaultbeacon.blocks.beacon;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import com.shiftthedev.vaultbeacon.VBRegistry;
import com.shiftthedev.vaultbeacon.VaultBeacon;
import com.shiftthedev.vaultbeacon.VaultBeaconClient;
import com.shiftthedev.vaultbeacon.blocks.beacon.VaultBeaconBlockEntity;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class VaultBeaconRenderer
implements BlockEntityRenderer<VaultBeaconBlockEntity> {
    private final Minecraft mc = Minecraft.m_91087_();
    private final ItemRenderer itemRenderer = this.mc.m_91291_();
    private static final HashMap<Direction, double[][]> LOCK_TRANSLATES;
    private static final ResourceLocation LOCK_TEXTURE;
    private static final RenderType RENDER_TYPE_LOCK;
    private static final ResourceLocation VAULT_BEACON_BASE_LOCATION;
    private static final RenderType RENDER_TYPE_BASE;
    private final ModelPart base;

    public VaultBeaconRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelPart = context.m_173582_(VaultBeaconClient.VAULT_BEACON_BASE);
        this.base = modelPart.m_171324_("base");
    }

    public static LayerDefinition createBaseLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("base", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, 0.0f, -3.0f, 6.0f, 1.0f, 6.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)24, (int)8);
    }

    public void render(VaultBeaconBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, int overlay) {
        Level level = blockEntity.m_58904_();
        LocalPlayer player = this.mc.f_91074_;
        if (level == null || player == null) {
            return;
        }
        if (blockEntity.isActive()) {
            this.renderBase(Vector3f.f_122225_.m_122240_(this.getAngle(player, partialTicks) * -1.0f), blockEntity.getDirection(), poseStack, multiBufferSource.m_6299_(RENDER_TYPE_BASE), light, overlay);
            this.renderItem(blockEntity.getCrystal(), Vector3f.f_122225_.m_122240_(this.getAngle(player, partialTicks)), blockEntity.getDirection(), poseStack, multiBufferSource, overlay, light);
        } else {
            this.renderBase(Quaternion.f_80118_, blockEntity.getDirection(), poseStack, multiBufferSource.m_6299_(RENDER_TYPE_BASE), light, overlay);
        }
        if (blockEntity.isLocked() && player.m_21205_().m_150930_((Item)VBRegistry.SECURITY_KEY)) {
            this.renderLock(blockEntity.getDirection(), poseStack, multiBufferSource.m_6299_(RENDER_TYPE_LOCK), light, overlay);
        }
    }

    private void renderItem(ItemStack stack, Quaternion rotation, Direction direction, PoseStack poseStack, MultiBufferSource buffer, int combinedOverlay, int lightLevel) {
        poseStack.m_85836_();
        switch (direction) {
            case UP: {
                poseStack.m_85837_(0.5, 0.81, 0.5);
                break;
            }
            case DOWN: {
                poseStack.m_85837_(0.5, 0.0, 0.5);
                break;
            }
            case NORTH: {
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                poseStack.m_85837_(0.5, 0.0, -0.5);
                break;
            }
            case SOUTH: {
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                poseStack.m_85837_(0.5, 0.81, -0.5);
                break;
            }
            case EAST: {
                poseStack.m_85845_(Vector3f.f_122226_.m_122240_(90.0f));
                poseStack.m_85837_(-0.5, 0.81, 0.5);
                break;
            }
            case WEST: {
                poseStack.m_85845_(Vector3f.f_122226_.m_122240_(90.0f));
                poseStack.m_85837_(-0.5, 0.0, 0.5);
            }
        }
        poseStack.m_85841_(0.75f, 0.75f, 0.75f);
        poseStack.m_85845_(rotation);
        BakedModel ibakedmodel = this.itemRenderer.m_174264_(stack, (Level)null, (LivingEntity)null, 0);
        this.itemRenderer.m_115143_(stack, ItemTransforms.TransformType.GROUND, true, poseStack, buffer, lightLevel, combinedOverlay, ibakedmodel);
        poseStack.m_85849_();
    }

    private void renderBase(Quaternion rotation, Direction direction, PoseStack poseStack, VertexConsumer vertexBuffer, int light, int overlay) {
        poseStack.m_85836_();
        switch (direction) {
            case UP: {
                poseStack.m_85837_(0.5, 0.65625, 0.5);
                break;
            }
            case DOWN: {
                poseStack.m_85837_(0.5, 0.28125, 0.5);
                break;
            }
            case NORTH: {
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                poseStack.m_85837_(0.5, 0.28125, -0.5);
                break;
            }
            case SOUTH: {
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                poseStack.m_85837_(0.5, 0.65625, -0.5);
                break;
            }
            case EAST: {
                poseStack.m_85845_(Vector3f.f_122226_.m_122240_(90.0f));
                poseStack.m_85837_(-0.5, 0.65625, 0.5);
                break;
            }
            case WEST: {
                poseStack.m_85845_(Vector3f.f_122226_.m_122240_(90.0f));
                poseStack.m_85837_(-0.5, 0.28125, 0.5);
            }
        }
        poseStack.m_85845_(rotation);
        this.base.m_104301_(poseStack, vertexBuffer, light, overlay);
        poseStack.m_85849_();
    }

    private void renderLock(Direction direction, PoseStack poseStack, VertexConsumer vertexConsumer, int light, int overlay) {
        Vector3f normal;
        PoseStack.Pose pose;
        int i;
        double[][] translate = LOCK_TRANSLATES.get(direction);
        if (translate.length == 0) {
            return;
        }
        for (i = 0; i < 2; ++i) {
            poseStack.m_85836_();
            poseStack.m_85837_(translate[i][0], translate[i][1], translate[i][2]);
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_((float)translate[i][3]));
            poseStack.m_85841_(0.125f, 0.125f, 0.125f);
            poseStack.m_85836_();
            pose = poseStack.m_85850_();
            normal = new Vector3f(0.0f, 1.0f, 0.0f);
            normal.m_122249_(pose.m_85864_());
            this.addVertex(pose.m_85861_(), normal, vertexConsumer, 1, 0.0f, overlay, light, 1.0f, 0.0f);
            this.addVertex(pose.m_85861_(), normal, vertexConsumer, 0, 0.0f, overlay, light, 1.0f, 1.0f);
            this.addVertex(pose.m_85861_(), normal, vertexConsumer, 0, 1.0f, overlay, light, 0.0f, 1.0f);
            this.addVertex(pose.m_85861_(), normal, vertexConsumer, 1, 1.0f, overlay, light, 0.0f, 0.0f);
            poseStack.m_85849_();
            poseStack.m_85849_();
        }
        for (i = 2; i < 4; ++i) {
            poseStack.m_85836_();
            poseStack.m_85837_(translate[i][0], translate[i][1], translate[i][2]);
            if (direction == Direction.EAST || direction == Direction.WEST) {
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_((float)translate[i][3]));
            }
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_((float)translate[i][3]));
            poseStack.m_85841_(0.125f, 0.125f, 0.125f);
            poseStack.m_85836_();
            pose = poseStack.m_85850_();
            normal = new Vector3f(0.0f, 1.0f, 0.0f);
            normal.m_122249_(pose.m_85864_());
            this.addVertex(pose.m_85861_(), normal, vertexConsumer, 1, 0.0f, overlay, light, 1.0f, 0.0f);
            this.addVertex(pose.m_85861_(), normal, vertexConsumer, 0, 0.0f, overlay, light, 1.0f, 1.0f);
            this.addVertex(pose.m_85861_(), normal, vertexConsumer, 0, 1.0f, overlay, light, 0.0f, 1.0f);
            this.addVertex(pose.m_85861_(), normal, vertexConsumer, 1, 1.0f, overlay, light, 0.0f, 0.0f);
            poseStack.m_85849_();
            poseStack.m_85849_();
        }
    }

    private void addVertex(Matrix4f matrix4f, Vector3f normal, VertexConsumer vertexConsumer, int y, float x, int overlay, int light, float u, float v) {
        Vector4f pos = new Vector4f(x, (float)y, 0.0f, 1.0f);
        pos.m_123607_(matrix4f);
        vertexConsumer.m_5954_(pos.m_123601_(), pos.m_123615_(), pos.m_123616_(), 1.0f, 1.0f, 1.0f, 1.0f, u, v, overlay, light, normal.m_122239_(), normal.m_122260_(), normal.m_122269_());
    }

    private float getAngle(LocalPlayer player, float partialTicks) {
        float currentTick = player.f_19797_;
        return (currentTick + partialTicks) % 360.0f;
    }

    static {
        LOCK_TEXTURE = VaultBeacon.id("textures/block/lock.png");
        RENDER_TYPE_LOCK = RenderType.m_110458_((ResourceLocation)LOCK_TEXTURE);
        VAULT_BEACON_BASE_LOCATION = VaultBeacon.id("textures/block/vault_beacon_base.png");
        RENDER_TYPE_BASE = RenderType.m_110458_((ResourceLocation)VAULT_BEACON_BASE_LOCATION);
        LOCK_TRANSLATES = new HashMap();
        LOCK_TRANSLATES.put(Direction.UP, new double[][]{{0.4375, 0.03125, 0.18125, 0.0}, {0.4375, 0.03125, 0.81875, 0.0}, {0.18125, 0.03125, 0.4375, -90.0}, {0.81875, 0.03125, 0.4375, -90.0}});
        LOCK_TRANSLATES.put(Direction.DOWN, new double[][]{{0.4375, 0.84375, 0.18125, 0.0}, {0.4375, 0.84375, 0.81875, 0.0}, {0.18125, 0.84375, 0.4375, -90.0}, {0.81875, 0.84375, 0.4375, -90.0}});
        LOCK_TRANSLATES.put(Direction.NORTH, new double[][]{{0.4375, 0.81875, 0.96875, -90.0}, {0.4375, 0.18125, 0.96875, -90.0}, {0.81875, 0.4375, 0.84375, -90.0}, {0.18125, 0.4375, 0.84375, -90.0}});
        LOCK_TRANSLATES.put(Direction.SOUTH, new double[][]{{0.4375, 0.81875, 0.03125, 90.0}, {0.4375, 0.18125, 0.03125, 90.0}, {0.81875, 0.4375, 0.03125, -90.0}, {0.18125, 0.4375, 0.03125, -90.0}});
        LOCK_TRANSLATES.put(Direction.EAST, new double[][]{{0.03125, 0.4375, 0.18125, 0.0}, {0.03125, 0.4375, 0.81875, 0.0}, {0.03125, 0.81875, 0.4375, -90.0}, {0.03125, 0.18125, 0.4375, -90.0}});
        LOCK_TRANSLATES.put(Direction.WEST, new double[][]{{0.84375, 0.4375, 0.18125, 0.0}, {0.84375, 0.4375, 0.81875, 0.0}, {0.96875, 0.81875, 0.5625, 90.0}, {0.96875, 0.18125, 0.5625, 90.0}});
    }
}

