/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.vaultbeacon.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import net.minecraft.util.Mth;
import net.minecraftforge.common.ForgeConfigSpec;

public class VBConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static ForgeConfigSpec SPEC;
    private static String CONFIG_PATH;
    private static CommentedFileConfig CONFIG_FILE;
    public static final Settings SETTINGS;

    public static void initConfigs() {
        Path path = Paths.get(CONFIG_PATH, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.createFile(path, new FileAttribute[0]);
                CommentedFileConfig defaults = (CommentedFileConfig)CommentedFileConfig.builder((Path)path, (ConfigFormat)TomlFormat.instance()).writingMode(WritingMode.REPLACE).build();
                defaults.set("version.versionvalue", (Object)1);
                defaults.save();
                defaults.close();
            }
            catch (IOException ex) {
                throw new RuntimeException("[VB] Failed to create vault beacon config file", ex);
            }
        }
        CONFIG_FILE = (CommentedFileConfig)CommentedFileConfig.builder((Path)path, (ConfigFormat)TomlFormat.instance()).writingMode(WritingMode.REPLACE).build();
        CONFIG_FILE.load();
        SPEC.setConfig((CommentedConfig)CONFIG_FILE);
    }

    public static void reloadConfig() {
        CONFIG_FILE.load();
        SPEC.setConfig((CommentedConfig)CONFIG_FILE);
    }

    public static void resetConfig() {
        SETTINGS.setMaxJump(1);
        SETTINGS.setMaxSpeed(3);
        SETTINGS.setMaxHaste(3);
        SETTINGS.setMaxRegen(1);
        SETTINGS.setMaxSaturation(1);
        SETTINGS.setMaxResistance(2);
        SETTINGS.setMaxStrength(2);
        SETTINGS.setMaxRange(4);
        CONFIG_FILE.set("Settings.maxJump", (Object)1);
        CONFIG_FILE.set("Settings.maxSpeed", (Object)3);
        CONFIG_FILE.set("Settings.maxHaste", (Object)3);
        CONFIG_FILE.set("Settings.maxRegen", (Object)1);
        CONFIG_FILE.set("Settings.maxSaturation", (Object)1);
        CONFIG_FILE.set("Settings.maxResistance", (Object)2);
        CONFIG_FILE.set("Settings.maxStrength", (Object)2);
        CONFIG_FILE.set("Settings.maxRange", (Object)4);
        VBConfig.saveConfig();
    }

    public static void updateFromServer(Map<String, Integer> serverConfigs) {
        serverConfigs.forEach((arg_0, arg_1) -> ((CommentedFileConfig)CONFIG_FILE).set(arg_0, arg_1));
        SPEC.setConfig((CommentedConfig)CONFIG_FILE);
    }

    public static void saveConfig() {
        CONFIG_FILE.save();
    }

    static {
        CONFIG_PATH = "config/shift_mods/vaultbeacon/vaultbeacon-common.shift";
        SETTINGS = new Settings(BUILDER);
        SPEC = BUILDER.build();
    }

    public static class Settings {
        private ForgeConfigSpec.ConfigValue<Integer> maxJump;
        private ForgeConfigSpec.ConfigValue<Integer> maxSpeed;
        private ForgeConfigSpec.ConfigValue<Integer> maxHaste;
        private ForgeConfigSpec.ConfigValue<Integer> maxRegen;
        private ForgeConfigSpec.ConfigValue<Integer> maxSaturation;
        private ForgeConfigSpec.ConfigValue<Integer> maxResistance;
        private ForgeConfigSpec.ConfigValue<Integer> maxStrength;
        private ForgeConfigSpec.ConfigValue<Integer> maxRange;

        public Settings(ForgeConfigSpec.Builder builder) {
            builder.push("Settings");
            this.maxJump = builder.comment("Maximum number of Jump buff catalysts that will be counted.").defineInRange("maxJump", 1, 0, 164);
            this.maxSpeed = builder.comment("Maximum number of Speed buff catalysts that will be counted.").defineInRange("maxSpeed", 3, 0, 164);
            this.maxHaste = builder.comment("Maximum number of Haste buff catalysts that will be counted.").defineInRange("maxHaste", 3, 0, 164);
            this.maxRegen = builder.comment("Maximum number of Regen buff catalysts that will be counted.").defineInRange("maxRegen", 1, 0, 164);
            this.maxSaturation = builder.comment("Maximum number of Saturation buff catalysts that will be counted.").defineInRange("maxSaturation", 1, 0, 164);
            this.maxResistance = builder.comment("Maximum number of Resistance buff catalysts that will be counted.").defineInRange("maxResistance", 2, 0, 164);
            this.maxStrength = builder.comment("Maximum number of Strength buff catalysts that will be counted.").defineInRange("maxStrength", 2, 0, 164);
            this.maxRange = builder.comment("Maximum number of Range buff Resistance that will be counted.").defineInRange("maxRange", 4, 0, 164);
            builder.pop();
        }

        public int MaxJump() {
            return (Integer)this.maxJump.get();
        }

        public int MaxSpeed() {
            return (Integer)this.maxSpeed.get();
        }

        public int MaxHaste() {
            return (Integer)this.maxHaste.get();
        }

        public int MaxRegen() {
            return (Integer)this.maxRegen.get();
        }

        public int MaxSaturation() {
            return (Integer)this.maxSaturation.get();
        }

        public int MaxResistance() {
            return (Integer)this.maxResistance.get();
        }

        public int MaxStrength() {
            return (Integer)this.maxStrength.get();
        }

        public int MaxRange() {
            return (Integer)this.maxRange.get();
        }

        public void setMaxJump(int value) {
            this.maxJump.set((Object)Mth.m_14045_((int)value, (int)0, (int)164));
        }

        public void setMaxSpeed(int value) {
            this.maxSpeed.set((Object)Mth.m_14045_((int)value, (int)0, (int)164));
        }

        public void setMaxHaste(int value) {
            this.maxHaste.set((Object)Mth.m_14045_((int)value, (int)0, (int)164));
        }

        public void setMaxRegen(int value) {
            this.maxRegen.set((Object)Mth.m_14045_((int)value, (int)0, (int)164));
        }

        public void setMaxSaturation(int value) {
            this.maxSaturation.set((Object)Mth.m_14045_((int)value, (int)0, (int)164));
        }

        public void setMaxResistance(int value) {
            this.maxResistance.set((Object)Mth.m_14045_((int)value, (int)0, (int)164));
        }

        public void setMaxStrength(int value) {
            this.maxStrength.set((Object)Mth.m_14045_((int)value, (int)0, (int)164));
        }

        public void setMaxRange(int value) {
            this.maxRange.set((Object)Mth.m_14045_((int)value, (int)0, (int)164));
        }
    }
}

