/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.vaultbeacon.network;

import com.google.common.collect.Maps;
import com.shiftthedev.vaultbeacon.VaultBeacon;
import com.shiftthedev.vaultbeacon.config.VBConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ConfigSyncMessage {
    private Map<String, Integer> configs = Maps.newHashMap();

    public ConfigSyncMessage(VBConfig.Settings server) {
        this.configs.put("Settings.maxJump", server.MaxJump());
        this.configs.put("Settings.maxSpeed", server.MaxSpeed());
        this.configs.put("Settings.maxHaste", server.MaxHaste());
        this.configs.put("Settings.maxRegen", server.MaxRegen());
        this.configs.put("Settings.maxSaturation", server.MaxSaturation());
        this.configs.put("Settings.maxResistance", server.MaxResistance());
        this.configs.put("Settings.maxStrength", server.MaxStrength());
        this.configs.put("Settings.maxRange", server.MaxRange());
    }

    public ConfigSyncMessage(Map<String, Integer> configs) {
        this.configs = configs;
    }

    public static void encode(ConfigSyncMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.configs.size());
        message.configs.forEach((k, v) -> {
            buffer.m_130070_(k);
            buffer.writeInt(v.intValue());
        });
    }

    public static ConfigSyncMessage decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap temp = Maps.newHashMap();
        for (int i = 0; i < size; ++i) {
            String id = buffer.m_130136_(128);
            int value = buffer.readInt();
            temp.put(id, value);
        }
        return new ConfigSyncMessage(temp);
    }

    public static void handle(ConfigSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            VBConfig.updateFromServer(message.configs);
            VaultBeacon.LOGGER.info("[VB] Received config from server.");
        });
        context.setPacketHandled(true);
    }
}

