/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.model;

import com.google.common.collect.ImmutableList;
import flaxbeard.immersivepetroleum.common.entity.MotorboatEntity;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelMotorboat
extends ListModel<MotorboatEntity> {
    private final List<ModelPart> list;
    public ModelPart noWater;
    public ModelPart[] boatSides = new ModelPart[5];
    public ModelPart motor;
    public ModelPart propeller;
    public ModelPart propellerAssembly;
    public ModelPart icebreak;
    public ModelPart coreSampleBoat;
    public ModelPart coreSampleBoatDrill;
    public ModelPart tank;
    public ModelPart rudder1;
    public ModelPart rudder2;
    public ModelPart ruddersBase;
    public ModelPart[] paddles = new ModelPart[2];

    public ModelMotorboat() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition rootDefinition = meshDefinition.m_171576_();
        rootDefinition.m_171599_("boat_side0", this.singleCube(0, 0, -14.0f, -9.0f, -3.0f, 28.0f, 16.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)1.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        rootDefinition.m_171599_("boat_side1", this.singleCube(0, 19, -13.0f, -7.0f, -1.0f, 18.0f, 6.0f, 2.0f), PartPose.m_171423_((float)-15.0f, (float)4.0f, (float)4.0f, (float)0.0f, (float)4.712389f, (float)0.0f));
        rootDefinition.m_171599_("boat_side2", this.singleCube(0, 27, -8.0f, -7.0f, -1.0f, 16.0f, 6.0f, 2.0f), PartPose.m_171423_((float)15.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)1.5707964f, (float)0.0f));
        rootDefinition.m_171599_("boat_side3", this.singleCube(0, 35, -14.0f, -7.0f, -1.0f, 28.0f, 6.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-9.0f, (float)0.0f, (float)((float)Math.PI), (float)0.0f));
        rootDefinition.m_171599_("boat_side4", this.singleCube(0, 43, -14.0f, -7.0f, -1.0f, 28.0f, 6.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)9.0f));
        rootDefinition.m_171599_("no_water", this.singleCube(0, 0, -14.0f, -9.0f, -3.0f, 28.0f, 16.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)1.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        rootDefinition.m_171599_("motor", this.singleCube(104, 0, -19.0f, -8.0f, -3.0f, 6.0f, 5.0f, 6.0f), PartPose.f_171404_);
        PartDefinition propAssembly_Definition = rootDefinition.m_171599_("propeller_assembly", this.singleCube(96, 0, -1.0f, -8.1f, -1.0f, 2.0f, 10.0f, 2.0f), PartPose.m_171419_((float)-17.0f, (float)5.0f, (float)0.0f));
        propAssembly_Definition.m_171599_("handle", this.singleCube(72, 0, 4.0f, -9.7f, -0.5f, 6.0f, 1.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)this.toRadians(-5.0f)));
        PartDefinition propeller_Definition = propAssembly_Definition.m_171599_("propeller", this.singleCube(86, 0, -1.0f, -1.0f, -1.0f, 3.0f, 2.0f, 2.0f), PartPose.m_171419_((float)-3.0f, (float)0.0f, (float)0.0f));
        propeller_Definition.m_171599_("propeller1", this.singleCube(90, 4, 0.0f, 0.0f, -1.0f, 1.0f, 4.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)this.toRadians(15.0f), (float)0.0f));
        PartDefinition propeller2B_Definition = propeller_Definition.m_171599_("propeller2B", this.empty(90, 4), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)this.toRadians(120.0f), (float)0.0f, (float)0.0f)).m_171599_("propeller2", this.singleCube(90, 4, 0.0f, 0.0f, -1.0f, 1.0f, 4.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)this.toRadians(15.0f), (float)0.0f));
        PartDefinition propeller3B_Definition = propeller_Definition.m_171599_("propeller3B", this.empty(90, 4), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)this.toRadians(240.0f), (float)0.0f, (float)0.0f)).m_171599_("propeller3", this.singleCube(90, 4, 0.0f, 0.0f, -1.0f, 1.0f, 4.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)this.toRadians(15.0f), (float)0.0f));
        PartDefinition icebreak_Definition = rootDefinition.m_171599_("icebreak", this.singleCube(34, 56, 16.0f, -2.0f, -2.0f, 7.0f, 4.0f, 4.0f), PartPose.f_171404_);
        PartDefinition icebreak_iS1_Definition = icebreak_Definition.m_171599_("icebreak_iS1", this.singleCube(56, 52, 0.01f, -7.01f, -0.01f, 16.0f, 10.0f, 2.0f), PartPose.m_171423_((float)26.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)this.toRadians(225.0f), (float)0.0f));
        PartDefinition icebreak_iS1T_Definition = icebreak_iS1_Definition.m_171599_("icebreak_iS1T", this.singleCube(100, 45, 4.0f, 0.0f, -2.0f, 12.0f, 5.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)-7.0f, (float)0.0f, (float)this.toRadians(157.0f), (float)0.0f, (float)0.0f));
        PartDefinition icebreak_iS2_Definition = icebreak_Definition.m_171599_("icebreak_iS2", this.singleCube(56, 52, 0.0f, -7.0f, -2.0f, 16.0f, 10.0f, 2.0f), PartPose.m_171423_((float)26.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)this.toRadians(135.0f), (float)0.0f));
        PartDefinition icebreak_iS2T_Definition = icebreak_iS2_Definition.m_171599_("icebreak_iS2T", this.singleCube(100, 45, 4.0f, 0.0f, 0.0f, 12.0f, 5.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)-7.0f, (float)0.0f, (float)this.toRadians(203.0f), (float)0.0f, (float)0.0f));
        PartDefinition tank_Definition = rootDefinition.m_171599_("tank", this.singleCube(86, 24, -14.0f, -2.0f, -8.0f, 5.0f, 5.0f, 16.0f), PartPose.f_171404_);
        PartDefinition pipe1_Definition = tank_Definition.m_171599_("pipe1", this.singleCube(112, 38, -13.0f, -3.0f, 4.0f, 1.0f, 1.0f, 1.0f), PartPose.f_171404_);
        PartDefinition pipe2_Definition = tank_Definition.m_171599_("pipe2", this.singleCube(116, 38, -15.0f, -4.0f, 4.0f, 3.0f, 1.0f, 1.0f), PartPose.f_171404_);
        PartDefinition pipe3_Definition = tank_Definition.m_171599_("pipe3", this.singleCube(112, 38, -15.0f, -4.0f, 3.0f, 1.0f, 1.0f, 1.0f), PartPose.f_171404_);
        PartDefinition ruddersBase_Definition = rootDefinition.m_171599_("ruddersBase", this.singleCube(92, 29, -18.0f, -3.0f, -8.0f, 2.0f, 6.0f, 3.0f), PartPose.f_171404_);
        PartDefinition ruddersBase2_Definition = ruddersBase_Definition.m_171599_("ruddersBase2", this.singleCube(92, 29, -18.0f, -3.0f, 6.0f, 2.0f, 6.0f, 3.0f), PartPose.f_171404_);
        PartDefinition rudder1_Definition = rootDefinition.m_171599_("rudder1", this.singleCube(112, 23, -4.0f, 0.0f, -0.5f, 4.0f, 6.0f, 1.0f), PartPose.m_171419_((float)-15.0f, (float)3.0f, (float)-6.5f));
        PartDefinition rudder2_Definition = rootDefinition.m_171599_("rudder2", this.singleCube(112, 23, -4.0f, 0.0f, -0.5f, 4.0f, 6.0f, 1.0f), PartPose.m_171419_((float)-15.0f, (float)3.0f, (float)7.5f));
        PartDefinition coreSampleBoat_Definition = rootDefinition.m_171599_("coreSampleBoat", this.singleCube(10, 0, -10.0f, -1.0f, -13.0f, 4.0f, 2.0f, 2.0f), PartPose.f_171404_);
        PartDefinition core2_Definition = coreSampleBoat_Definition.m_171599_("core2", this.singleCube(10, 0, -11.0f, -2.0f, -14.0f, 1.0f, 4.0f, 4.0f), PartPose.f_171404_);
        PartDefinition core3_Definition = coreSampleBoat_Definition.m_171599_("core3", this.singleCube(10, 0, -6.0f, -2.0f, -14.0f, 1.0f, 4.0f, 4.0f), PartPose.f_171404_);
        PartDefinition coreSampleBoatDrill_Definition = rootDefinition.m_171599_("coreSampleBoatDrill", this.singleCube(10, 0, -3.0f, -8.0f, -16.0f, 6.0f, 18.0f, 6.0f), PartPose.f_171404_);
        PartDefinition paddle0_Definition = rootDefinition.m_171599_("paddle_left", this.makePaddle(rootDefinition, true), PartPose.m_171423_((float)3.0f, (float)-5.0f, (float)9.0f, (float)0.0f, (float)0.0f, (float)0.19634955f));
        PartDefinition paddle1_Definition = rootDefinition.m_171599_("paddle_right", this.makePaddle(rootDefinition, false), PartPose.m_171423_((float)3.0f, (float)-5.0f, (float)-9.0f, (float)0.0f, (float)((float)Math.PI), (float)0.19634955f));
        LayerDefinition layerDefinition = LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)128, (int)64);
        ModelPart root = layerDefinition.m_171564_();
        this.boatSides[0] = root.m_171324_("boat_side0");
        this.boatSides[1] = root.m_171324_("boat_side1");
        this.boatSides[2] = root.m_171324_("boat_side2");
        this.boatSides[3] = root.m_171324_("boat_side3");
        this.boatSides[4] = root.m_171324_("boat_side4");
        this.noWater = root.m_171324_("no_water");
        this.motor = root.m_171324_("motor");
        this.propellerAssembly = root.m_171324_("propeller_assembly");
        this.propeller = this.propellerAssembly.m_171324_("propeller");
        this.icebreak = root.m_171324_("icebreak");
        this.tank = root.m_171324_("tank");
        this.ruddersBase = root.m_171324_("ruddersBase");
        this.paddles[0] = root.m_171324_("paddle_left");
        this.paddles[1] = root.m_171324_("paddle_right");
        this.rudder1 = root.m_171324_("rudder1");
        this.rudder2 = root.m_171324_("rudder2");
        this.coreSampleBoat = root.m_171324_("coreSampleBoat");
        this.coreSampleBoatDrill = root.m_171324_("coreSampleBoatDrill");
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(Arrays.asList(this.boatSides));
        builder.addAll(Arrays.asList(this.motor, this.propellerAssembly));
        this.list = builder.build();
    }

    private CubeListBuilder makePaddle(PartDefinition rootDefinition, boolean left) {
        CubeListBuilder builder = CubeListBuilder.m_171558_().m_171514_(62, left ? 2 : 22).m_171481_(-1.0f, 0.0f, -5.0f, 2.0f, 2.0f, 18.0f).m_171481_(left ? -1.001f : 0.001f, -3.0f, 8.0f, 1.0f, 6.0f, 7.0f);
        return builder;
    }

    public void setupAnim(@Nonnull MotorboatEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setPaddleRotationAngles(entityIn, 0, limbSwing, entityIn.isEmergency());
        this.setPaddleRotationAngles(entityIn, 1, limbSwing, entityIn.isEmergency());
    }

    public void setPaddleRotationAngles(Boat boat, int paddle, float limbSwing, boolean isEmergency) {
        if (isEmergency) {
            float f = boat.m_38315_(paddle, limbSwing);
            ModelPart model = this.paddles[paddle];
            model.f_104203_ = (float)Mth.m_14085_((double)-1.0471975803375244, (double)-0.2617993950843811, (double)((Mth.m_14031_((float)(-f)) + 1.0f) / 2.0f));
            model.f_104204_ = (float)Mth.m_14085_((double)-0.7853981852531433, (double)0.7853981852531433, (double)((Mth.m_14031_((float)(-f + 1.0f)) + 1.0f) / 2.0f));
            model.m_104227_(3.0f, -5.0f, 9.0f);
            if (paddle == 1) {
                model.m_104227_(3.0f, -5.0f, -9.0f);
                model.f_104204_ = (float)Math.PI - model.f_104204_;
            }
        } else {
            ModelPart model = this.paddles[paddle];
            model.f_104203_ = (float)Math.toRadians(-25.0);
            model.f_104204_ = (float)Math.toRadians(-90.0);
            model.m_104227_(3.0f, -2.0f, 11.0f);
            if (paddle == 1) {
                model.m_104227_(3.0f, -2.0f, -11.0f);
                model.f_104204_ = (float)Math.PI - model.f_104204_;
            }
        }
    }

    @Nonnull
    public Iterable<ModelPart> m_6195_() {
        return this.list;
    }

    public ModelPart noWaterRenderer() {
        return this.noWater;
    }

    protected final CubeListBuilder singleCube(float pOriginX, float pOriginY, float pOriginZ, float pDimensionX, float pDimensionY, float pDimensionZ) {
        return this.singleCube(0, 0, pOriginX, pOriginY, pOriginZ, pDimensionX, pDimensionY, pDimensionZ);
    }

    protected final CubeListBuilder singleCube(int pXTexOffs, int pYTexOffs, float pOriginX, float pOriginY, float pOriginZ, float pDimensionX, float pDimensionY, float pDimensionZ) {
        return CubeListBuilder.m_171558_().m_171514_(pXTexOffs, pYTexOffs).m_171481_(pOriginX, pOriginY, pOriginZ, pDimensionX, pDimensionY, pDimensionZ);
    }

    protected final CubeListBuilder empty(int pXTexOffs, int pYTexOffs) {
        return this.empty().m_171514_(pXTexOffs, pYTexOffs);
    }

    protected final CubeListBuilder empty() {
        return CubeListBuilder.m_171558_();
    }

    private float toRadians(float degrees) {
        return (float)Math.toRadians(degrees);
    }
}

