/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import flaxbeard.immersivepetroleum.client.render.dyn.DynamicTextureWrapper;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.items.SurveyResultItem;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import flaxbeard.immersivepetroleum.common.util.survey.ISurveyInfo;
import flaxbeard.immersivepetroleum.common.util.survey.SurveyScan;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderItemInFrameEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SeismicResultRenderer {
    static final Tesselator TESSELATOR = new Tesselator();
    private static final ResourceLocation OVERLAY = ResourceUtils.ip("textures/gui/seismic_overlay.png");

    @SubscribeEvent
    public void renderHandEvent(RenderHandEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_41720_().equals(IPContent.Items.SURVEYRESULT.get()) && stack.m_41782_() && stack.m_41737_("surveyscan") != null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void renderGameOverlayEvent(RenderGameOverlayEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            ItemStack main = mc.f_91074_.m_21120_(InteractionHand.MAIN_HAND);
            ItemStack off = mc.f_91074_.m_21120_(InteractionHand.OFF_HAND);
            if (!main.m_41619_() && main.m_41720_() == IPContent.Items.SURVEYRESULT.get() || !off.m_41619_() && off.m_41720_() == IPContent.Items.SURVEYRESULT.get()) {
                SurveyScan scan;
                DynamicTextureWrapper wrapper;
                PoseStack matrix = event.getMatrixStack();
                int guiScaledWidth = event.getWindow().m_85445_();
                int guiScaledHeight = event.getWindow().m_85446_();
                float xCenter = (float)guiScaledWidth / 2.0f;
                float yCenter = (float)guiScaledHeight / 2.0f;
                ISurveyInfo iSurveyInfo = ISurveyInfo.from(main);
                if (iSurveyInfo instanceof SurveyScan && (wrapper = DynamicTextureWrapper.getOrCreate(65, 65, scan = (SurveyScan)iSurveyInfo)) != null) {
                    MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)TESSELATOR.m_85915_());
                    matrix.m_85836_();
                    matrix.m_85837_((double)xCenter, (double)yCenter, 0.0);
                    matrix.m_85841_(2.0f, 2.0f, 2.0f);
                    matrix.m_85836_();
                    matrix.m_85837_((double)((float)(-wrapper.width) / 2.0f), (double)((float)(-wrapper.height) / 2.0f), 0.0);
                    int a = wrapper.width;
                    int b = wrapper.height;
                    VertexConsumer builder = buffer.m_6299_(wrapper.renderType);
                    builder.m_142461_(255, 255, 255, 255);
                    Matrix4f mat = matrix.m_85850_().m_85861_();
                    builder.m_85982_(mat, 0.0f, 0.0f, 0.0f).m_7421_(1.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
                    builder.m_85982_(mat, 0.0f, (float)b, 0.0f).m_7421_(1.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
                    builder.m_85982_(mat, (float)a, (float)b, 0.0f).m_7421_(0.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
                    builder.m_85982_(mat, (float)a, 0.0f, 0.0f).m_7421_(0.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
                    matrix.m_85849_();
                    matrix.m_85836_();
                    int w = 85;
                    int h = 85;
                    float u = 0.33203125f;
                    float v = 0.33203125f;
                    matrix.m_85837_(-42.5, -42.5, 1.0);
                    VertexConsumer builder2 = buffer.m_6299_(RenderType.m_110497_((ResourceLocation)OVERLAY));
                    builder2.m_142461_(255, 255, 255, 255);
                    Matrix4f mat2 = matrix.m_85850_().m_85861_();
                    builder2.m_85982_(mat2, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
                    builder2.m_85982_(mat2, 0.0f, 85.0f, 0.0f).m_7421_(0.0f, 0.33203125f).m_85969_(0xF000F0).m_5752_();
                    builder2.m_85982_(mat2, 85.0f, 85.0f, 0.0f).m_7421_(0.33203125f, 0.33203125f).m_85969_(0xF000F0).m_5752_();
                    builder2.m_85982_(mat2, 85.0f, 0.0f, 0.0f).m_7421_(0.33203125f, 0.0f).m_85969_(0xF000F0).m_5752_();
                    matrix.m_85849_();
                    matrix.m_85849_();
                    buffer.m_109911_();
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderItemFrame(RenderItemInFrameEvent event) {
        SurveyScan scan;
        DynamicTextureWrapper wrapper;
        ISurveyInfo iSurveyInfo;
        if (event.getItemStack().m_41720_() instanceof SurveyResultItem && MCUtil.getPlayer().m_20270_((Entity)event.getItemFrameEntity()) < 1000.0f && (iSurveyInfo = ISurveyInfo.from(event.getItemStack())) instanceof SurveyScan && (wrapper = DynamicTextureWrapper.getOrCreate(65, 65, scan = (SurveyScan)iSurveyInfo)) != null) {
            PoseStack matrix = event.getPoseStack();
            MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)TESSELATOR.m_85915_());
            matrix.m_85836_();
            int light = event.getPackedLight();
            int rot = event.getItemFrameEntity().m_31823_();
            float scale = 0.015384615f;
            matrix.m_85845_(new Quaternion(0.0f, 0.0f, 180.0f - (float)(-rot) * 45.0f, true));
            matrix.m_85837_(-0.5, -0.5, (double)-0.00625f);
            matrix.m_85841_(scale, scale, 1.0f);
            matrix.m_85836_();
            int a = wrapper.width;
            int b = wrapper.height;
            VertexConsumer builder = buffer.m_6299_(wrapper.renderType);
            builder.m_142461_(255, 255, 255, 255);
            Matrix4f mat = matrix.m_85850_().m_85861_();
            builder.m_85982_(mat, 0.0f, 0.0f, 0.0f).m_7421_(1.0f, 1.0f).m_85969_(light).m_5752_();
            builder.m_85982_(mat, 0.0f, (float)b, 0.0f).m_7421_(1.0f, 0.0f).m_85969_(light).m_5752_();
            builder.m_85982_(mat, (float)a, (float)b, 0.0f).m_7421_(0.0f, 0.0f).m_85969_(light).m_5752_();
            builder.m_85982_(mat, (float)a, 0.0f, 0.0f).m_7421_(0.0f, 1.0f).m_85969_(light).m_5752_();
            matrix.m_85849_();
            matrix.m_85836_();
            int w = 65;
            int h = 65;
            float u = 0.29296875f;
            float v = 0.29296875f;
            matrix.m_85837_(0.0, 0.0, (double)-0.002f);
            VertexConsumer builder2 = buffer.m_6299_(RenderType.m_110497_((ResourceLocation)OVERLAY));
            builder2.m_142461_(255, 255, 255, 255);
            Matrix4f mat2 = matrix.m_85850_().m_85861_();
            builder2.m_85982_(mat2, 0.0f, 0.0f, 0.0f).m_7421_(0.0390625f, 0.0390625f).m_85969_(light).m_5752_();
            builder2.m_85982_(mat2, 0.0f, 65.0f, 0.0f).m_7421_(0.0390625f, 0.29296875f).m_85969_(light).m_5752_();
            builder2.m_85982_(mat2, 65.0f, 65.0f, 0.0f).m_7421_(0.29296875f, 0.29296875f).m_85969_(light).m_5752_();
            builder2.m_85982_(mat2, 65.0f, 0.0f, 0.0f).m_7421_(0.29296875f, 0.0390625f).m_85969_(light).m_5752_();
            matrix.m_85849_();
            matrix.m_85849_();
            buffer.m_109911_();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void entityViewRenderEvent(EntityViewRenderEvent event) {
    }

    @SubscribeEvent
    public void cameraSetupRenderEvent(EntityViewRenderEvent.CameraSetup event) {
    }

    @SubscribeEvent
    public void fieldOfViewRenderEvent(EntityViewRenderEvent.FieldOfView event) {
    }
}

