/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.common.blocks.metal.CrusherBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ExcavatorBlockEntity;
import blusunrize.immersiveengineering.common.register.IEPotions;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.IPTags;
import flaxbeard.immersivepetroleum.api.crafting.FlarestackHandler;
import flaxbeard.immersivepetroleum.api.crafting.LubricantHandler;
import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import flaxbeard.immersivepetroleum.client.particle.FlareFire;
import flaxbeard.immersivepetroleum.client.particle.FluidSpill;
import flaxbeard.immersivepetroleum.client.particle.IPParticleTypes;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.IPMenuTypes;
import flaxbeard.immersivepetroleum.common.IPRegisters;
import flaxbeard.immersivepetroleum.common.blocks.IPBlockItemBase;
import flaxbeard.immersivepetroleum.common.blocks.metal.CokerUnitBlock;
import flaxbeard.immersivepetroleum.common.blocks.metal.DerrickBlock;
import flaxbeard.immersivepetroleum.common.blocks.metal.DistillationTowerBlock;
import flaxbeard.immersivepetroleum.common.blocks.metal.FlarestackBlock;
import flaxbeard.immersivepetroleum.common.blocks.metal.GasGeneratorBlock;
import flaxbeard.immersivepetroleum.common.blocks.metal.HydrotreaterBlock;
import flaxbeard.immersivepetroleum.common.blocks.metal.OilTankBlock;
import flaxbeard.immersivepetroleum.common.blocks.metal.PumpjackBlock;
import flaxbeard.immersivepetroleum.common.blocks.metal.SeismicSurveyBlock;
import flaxbeard.immersivepetroleum.common.blocks.stone.AsphaltBlock;
import flaxbeard.immersivepetroleum.common.blocks.stone.AsphaltSlab;
import flaxbeard.immersivepetroleum.common.blocks.stone.AsphaltStairs;
import flaxbeard.immersivepetroleum.common.blocks.stone.ParaffinWaxBlock;
import flaxbeard.immersivepetroleum.common.blocks.stone.PetcokeBlock;
import flaxbeard.immersivepetroleum.common.blocks.stone.WellBlock;
import flaxbeard.immersivepetroleum.common.blocks.stone.WellPipeBlock;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.PumpjackTileEntity;
import flaxbeard.immersivepetroleum.common.blocks.wooden.AutoLubricatorBlock;
import flaxbeard.immersivepetroleum.common.crafting.Serializers;
import flaxbeard.immersivepetroleum.common.entity.MolotovItemEntity;
import flaxbeard.immersivepetroleum.common.entity.MotorboatEntity;
import flaxbeard.immersivepetroleum.common.fluids.CrudeOilFluid;
import flaxbeard.immersivepetroleum.common.fluids.DieselFluid;
import flaxbeard.immersivepetroleum.common.fluids.IPFluid;
import flaxbeard.immersivepetroleum.common.fluids.NapalmFluid;
import flaxbeard.immersivepetroleum.common.items.DebugItem;
import flaxbeard.immersivepetroleum.common.items.GasolineBottleItem;
import flaxbeard.immersivepetroleum.common.items.IPItemBase;
import flaxbeard.immersivepetroleum.common.items.IPUpgradeItem;
import flaxbeard.immersivepetroleum.common.items.MolotovItem;
import flaxbeard.immersivepetroleum.common.items.MotorboatItem;
import flaxbeard.immersivepetroleum.common.items.OilCanItem;
import flaxbeard.immersivepetroleum.common.items.ProjectorItem;
import flaxbeard.immersivepetroleum.common.items.SurveyResultItem;
import flaxbeard.immersivepetroleum.common.lubehandlers.CrusherLubricationHandler;
import flaxbeard.immersivepetroleum.common.lubehandlers.ExcavatorLubricationHandler;
import flaxbeard.immersivepetroleum.common.lubehandlers.PumpjackLubricationHandler;
import flaxbeard.immersivepetroleum.common.multiblocks.CokerUnitMultiblock;
import flaxbeard.immersivepetroleum.common.multiblocks.DerrickMultiblock;
import flaxbeard.immersivepetroleum.common.multiblocks.DistillationTowerMultiblock;
import flaxbeard.immersivepetroleum.common.multiblocks.HydroTreaterMultiblock;
import flaxbeard.immersivepetroleum.common.multiblocks.OilTankMultiblock;
import flaxbeard.immersivepetroleum.common.multiblocks.PumpjackMultiblock;
import flaxbeard.immersivepetroleum.common.util.IPEffects;
import flaxbeard.immersivepetroleum.common.world.IPWorldGen;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="immersivepetroleum", bus=Mod.EventBusSubscriber.Bus.MOD)
public class IPContent {
    public static final Logger log = LogManager.getLogger((String)"immersivepetroleum/Content");
    public static final RegistryObject<Item> DEBUGITEM = IPRegisters.registerItem("debug", DebugItem::new);

    public static void modConstruction() {
        Fluids.forceClassLoad();
        Blocks.forceClassLoad();
        Items.forceClassLoad();
        BoatUpgrades.forceClassLoad();
        Multiblock.forceClassLoad();
        IPMenuTypes.forceClassLoad();
        Serializers.forceClassLoad();
        IPEffects.forceClassLoad();
    }

    public static void preInit() {
    }

    public static void init(ParallelDispatchEvent event) {
        event.enqueueWork(IPWorldGen::registerReservoirGen);
        ChemthrowerHandler.registerEffect(IPTags.Fluids.lubricant, (ChemthrowerHandler.ChemthrowerEffect)new LubricatedHandler.LubricantEffect());
        ChemthrowerHandler.registerEffect(IPTags.Fluids.lubricant, (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, (MobEffect)IEPotions.SLIPPERY.get(), 60, 1));
        ChemthrowerHandler.registerEffect((TagKey)IETags.fluidPlantoil, (ChemthrowerHandler.ChemthrowerEffect)new LubricatedHandler.LubricantEffect());
        ChemthrowerHandler.registerEffect(IPTags.Fluids.crudeOil, (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, (MobEffect)IEPotions.FLAMMABLE.get(), 60, 1));
        ChemthrowerHandler.registerEffect(IPTags.Fluids.gasoline, (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, (MobEffect)IEPotions.FLAMMABLE.get(), 60, 1));
        ChemthrowerHandler.registerEffect(IPTags.Fluids.naphtha, (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, (MobEffect)IEPotions.FLAMMABLE.get(), 60, 1));
        ChemthrowerHandler.registerEffect(IPTags.Fluids.benzene, (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, (MobEffect)IEPotions.FLAMMABLE.get(), 60, 1));
        ChemthrowerHandler.registerEffect(IPTags.Fluids.napalm, (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, (MobEffect)IEPotions.FLAMMABLE.get(), 60, 2));
        ChemthrowerHandler.registerFlammable(IPTags.Fluids.crudeOil);
        ChemthrowerHandler.registerFlammable(IPTags.Fluids.gasoline);
        ChemthrowerHandler.registerFlammable(IPTags.Fluids.naphtha);
        ChemthrowerHandler.registerFlammable(IPTags.Fluids.benzene);
        ChemthrowerHandler.registerFlammable(IPTags.Fluids.napalm);
        MultiblockHandler.registerMultiblock((MultiblockHandler.IMultiblock)DistillationTowerMultiblock.INSTANCE);
        MultiblockHandler.registerMultiblock((MultiblockHandler.IMultiblock)PumpjackMultiblock.INSTANCE);
        MultiblockHandler.registerMultiblock((MultiblockHandler.IMultiblock)CokerUnitMultiblock.INSTANCE);
        MultiblockHandler.registerMultiblock((MultiblockHandler.IMultiblock)HydroTreaterMultiblock.INSTANCE);
        MultiblockHandler.registerMultiblock((MultiblockHandler.IMultiblock)DerrickMultiblock.INSTANCE);
        MultiblockHandler.registerMultiblock((MultiblockHandler.IMultiblock)OilTankMultiblock.INSTANCE);
        LubricantHandler.register(IPTags.Fluids.lubricant, 3);
        LubricantHandler.register((TagKey<Fluid>)IETags.fluidPlantoil, 12);
        FlarestackHandler.register(IPTags.Utility.burnableInFlarestack);
        LubricatedHandler.registerLubricatedTile(PumpjackTileEntity.class, PumpjackLubricationHandler::new);
        LubricatedHandler.registerLubricatedTile(ExcavatorBlockEntity.class, ExcavatorLubricationHandler::new);
        LubricatedHandler.registerLubricatedTile(CrusherBlockEntity.class, CrusherLubricationHandler::new);
    }

    @SubscribeEvent
    public static void registerEntityTypes(RegistryEvent.Register<EntityType<?>> event) {
        try {
            event.getRegistry().register(MotorboatEntity.TYPE);
            event.getRegistry().register(MolotovItemEntity.TYPE);
        }
        catch (Throwable e) {
            log.error("Failed to register Speedboat Entity. {}", (Object)e.getMessage());
            throw e;
        }
    }

    @SubscribeEvent
    public static void registerEffects(RegistryEvent.Register<MobEffect> event) {
        event.getRegistry().register((IForgeRegistryEntry)((MobEffect)IPEffects.ANTI_DISMOUNT_FIRE.get()));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerParticles(RegistryEvent.Register<ParticleType<?>> event) {
        event.getRegistry().register((IForgeRegistryEntry)IPParticleTypes.FLARE_FIRE);
        event.getRegistry().register(IPParticleTypes.FLUID_SPILL);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerParticleFactories(ParticleFactoryRegisterEvent event) {
        ParticleEngine manager = MCUtil.getParticleEngine();
        manager.m_107378_((ParticleType)IPParticleTypes.FLARE_FIRE, FlareFire.Factory::new);
        manager.m_107381_(IPParticleTypes.FLUID_SPILL, (ParticleProvider)new FluidSpill.Factory());
    }

    public static class Fluids {
        public static final IPFluid.IPFluidEntry CRUDEOIL = IPFluid.makeFluid("crudeoil", CrudeOilFluid::new);
        public static final IPFluid.IPFluidEntry DIESEL_SULFUR = IPFluid.makeFluid("diesel_sulfur", DieselFluid::new);
        public static final IPFluid.IPFluidEntry DIESEL = IPFluid.makeFluid("diesel", DieselFluid::new);
        public static final IPFluid.IPFluidEntry LUBRICANT = IPFluid.makeFluid("lubricant", e -> new IPFluid((IPFluid.IPFluidEntry)e, 925, 1000, false));
        public static final IPFluid.IPFluidEntry GASOLINE = IPFluid.makeFluid("gasoline", e -> new IPFluid((IPFluid.IPFluidEntry)e, 789, 1200, false));
        public static final IPFluid.IPFluidEntry NAPHTHA = IPFluid.makeFluid("naphtha", e -> new IPFluid((IPFluid.IPFluidEntry)e, 750, 750, false));
        public static final IPFluid.IPFluidEntry NAPHTHA_CRACKED = IPFluid.makeFluid("naphtha_cracked", e -> new IPFluid((IPFluid.IPFluidEntry)e, 750, 750, false));
        public static final IPFluid.IPFluidEntry BENZENE = IPFluid.makeFluid("benzene", e -> new IPFluid((IPFluid.IPFluidEntry)e, 876, 700, false));
        public static final IPFluid.IPFluidEntry PROPYLENE = IPFluid.makeFluid("propylene", e -> new IPFluid((IPFluid.IPFluidEntry)e, 2, 1, true));
        public static final IPFluid.IPFluidEntry ETHYLENE = IPFluid.makeFluid("ethylene", e -> new IPFluid((IPFluid.IPFluidEntry)e, 1, 1, true));
        public static final IPFluid.IPFluidEntry LUBRICANT_CRACKED = IPFluid.makeFluid("lubricant_cracked", e -> new IPFluid((IPFluid.IPFluidEntry)e, 925, 1000, false));
        public static final IPFluid.IPFluidEntry KEROSENE = IPFluid.makeFluid("kerosene", e -> new IPFluid((IPFluid.IPFluidEntry)e, 810, 900, false));
        public static final IPFluid.IPFluidEntry GASOLINE_ADDITIVES = IPFluid.makeFluid("gasoline_additives", e -> new IPFluid((IPFluid.IPFluidEntry)e, 800, 900, false));
        public static final IPFluid.IPFluidEntry NAPALM = NapalmFluid.makeFluid();

        private static void forceClassLoad() {
        }
    }

    public static class Blocks {
        public static final RegistryObject<SeismicSurveyBlock> SEISMIC_SURVEY = IPRegisters.registerIPBlock("seismic_survey", SeismicSurveyBlock::new);
        public static final RegistryObject<GasGeneratorBlock> GAS_GENERATOR = IPRegisters.registerIPBlock("gas_generator", GasGeneratorBlock::new);
        public static final RegistryObject<AutoLubricatorBlock> AUTO_LUBRICATOR = IPRegisters.registerIPBlock("auto_lubricator", AutoLubricatorBlock::new);
        public static final RegistryObject<FlarestackBlock> FLARESTACK = IPRegisters.registerIPBlock("flarestack", FlarestackBlock::new);
        public static final RegistryObject<AsphaltBlock> ASPHALT = IPRegisters.registerIPBlock("asphalt", AsphaltBlock::new);
        public static final RegistryObject<SlabBlock> ASPHALT_SLAB = IPRegisters.registerBlock("asphalt_slab", () -> new AsphaltSlab((AsphaltBlock)((Object)((Object)ASPHALT.get()))));
        public static final RegistryObject<StairBlock> ASPHALT_STAIR = IPRegisters.registerBlock("asphalt_stair", () -> new AsphaltStairs((AsphaltBlock)((Object)((Object)ASPHALT.get()))));
        public static final RegistryObject<PetcokeBlock> PETCOKE = IPRegisters.registerIPBlock("petcoke_block", PetcokeBlock::new);
        public static final RegistryObject<WellBlock> WELL = IPRegisters.registerBlock("well", WellBlock::new);
        public static final RegistryObject<WellPipeBlock> WELL_PIPE = IPRegisters.registerBlock("well_pipe", WellPipeBlock::new);
        public static final RegistryObject<ParaffinWaxBlock> PARAFFIN_WAX = IPRegisters.registerIPBlock("paraffin_wax_block", ParaffinWaxBlock::new);

        private static void forceClassLoad() {
            Blocks.registerItemBlock(ASPHALT_SLAB);
            Blocks.registerItemBlock(ASPHALT_STAIR);
        }

        private static void registerItemBlock(RegistryObject<? extends Block> block) {
            IPRegisters.registerItem(block.getId().m_135815_(), () -> new IPBlockItemBase((Block)block.get(), new Item.Properties().m_41491_(ImmersivePetroleum.creativeTab)));
        }
    }

    public static class Items {
        public static final RegistryObject<Item> PROJECTOR = IPRegisters.registerItem("projector", ProjectorItem::new);
        public static final RegistryObject<MotorboatItem> SPEEDBOAT = IPRegisters.registerItem("speedboat", MotorboatItem::new);
        public static final RegistryObject<OilCanItem> OIL_CAN = IPRegisters.registerItem("oil_can", OilCanItem::new);
        public static final RegistryObject<Item> BITUMEN = IPRegisters.registerItem("bitumen", IPItemBase::new);
        public static final RegistryObject<Item> PETCOKE = IPRegisters.registerItem("petcoke", () -> new IPItemBase(){

            public int getBurnTime(ItemStack itemStack, RecipeType<?> recipeType) {
                return 3200;
            }
        });
        public static final RegistryObject<Item> PETCOKEDUST = IPRegisters.registerItem("petcoke_dust", IPItemBase::new);
        public static final RegistryObject<Item> SURVEYRESULT = IPRegisters.registerItem("survey_result", SurveyResultItem::new);
        public static final RegistryObject<Item> PARAFFIN_WAX = IPRegisters.registerItem("paraffin_wax", () -> new IPItemBase(){

            public int getBurnTime(ItemStack itemStack, RecipeType<?> recipeType) {
                return 800;
            }
        });
        public static final RegistryObject<Item> GASOLINE_BOTTLE = IPRegisters.registerItem("gasoline_bottle", GasolineBottleItem::new);
        public static final RegistryObject<Item> MOLOTOV = IPRegisters.registerItem("molotov", () -> new MolotovItem(false));
        public static final RegistryObject<Item> MOLOTOV_LIT = IPRegisters.registerItem("molotov_lit", () -> new MolotovItem(true));

        private static void forceClassLoad() {
        }
    }

    public static class BoatUpgrades {
        public static final RegistryObject<IPUpgradeItem> REINFORCED_HULL = BoatUpgrades.createBoatUpgrade("reinforced_hull");
        public static final RegistryObject<IPUpgradeItem> ICE_BREAKER = BoatUpgrades.createBoatUpgrade("icebreaker");
        public static final RegistryObject<IPUpgradeItem> TANK = BoatUpgrades.createBoatUpgrade("tank");
        public static final RegistryObject<IPUpgradeItem> RUDDERS = BoatUpgrades.createBoatUpgrade("rudders");
        public static final RegistryObject<IPUpgradeItem> PADDLES = BoatUpgrades.createBoatUpgrade("paddles");

        private static void forceClassLoad() {
        }

        private static <T extends Item> RegistryObject<IPUpgradeItem> createBoatUpgrade(String name) {
            return IPRegisters.registerItem("upgrade_" + name, () -> new IPUpgradeItem("MOTORBOAT"));
        }
    }

    public static class Multiblock {
        public static final RegistryObject<DistillationTowerBlock> DISTILLATIONTOWER = IPRegisters.registerMultiblockBlock("distillation_tower", DistillationTowerBlock::new);
        public static final RegistryObject<PumpjackBlock> PUMPJACK = IPRegisters.registerMultiblockBlock("pumpjack", PumpjackBlock::new);
        public static final RegistryObject<CokerUnitBlock> COKERUNIT = IPRegisters.registerMultiblockBlock("coker_unit", CokerUnitBlock::new);
        public static final RegistryObject<HydrotreaterBlock> HYDROTREATER = IPRegisters.registerMultiblockBlock("hydrotreater", HydrotreaterBlock::new);
        public static final RegistryObject<DerrickBlock> DERRICK = IPRegisters.registerMultiblockBlock("derrick", DerrickBlock::new);
        public static final RegistryObject<OilTankBlock> OILTANK = IPRegisters.registerMultiblockBlock("oiltank", OilTankBlock::new);

        private static void forceClassLoad() {
        }
    }
}

